/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server;

import com.vaadin.flow.internal.StringUtil;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import org.slf4j.LoggerFactory;

public class Version
implements Serializable {
    private static final String VERSION;
    private static final int VERSION_MAJOR;
    private static final int VERSION_MINOR;
    private static final int VERSION_REVISION;
    private static final String VERSION_BUILD;
    private static final String VERSION_BUILD_HASH;

    public static String getFullVersion() {
        return VERSION;
    }

    public static int getMajorVersion() {
        return VERSION_MAJOR;
    }

    public static int getMinorVersion() {
        return VERSION_MINOR;
    }

    public static int getRevision() {
        return VERSION_REVISION;
    }

    public static String getBuildIdentifier() {
        return VERSION_BUILD;
    }

    public static String getBuildHash() {
        return VERSION_BUILD_HASH;
    }

    static {
        int revision;
        String build;
        String buildTimestamp;
        block5: {
            String flowVersion = "9.9.9.INTERNAL-DEBUG-BUILD";
            buildTimestamp = "";
            Properties properties = new Properties();
            try {
                properties.load(Version.class.getResourceAsStream("version.properties"));
                flowVersion = properties.getProperty("flow.version");
                buildTimestamp = properties.getProperty("flow.build.timestamp");
            }
            catch (IOException e) {
                LoggerFactory.getLogger((String)Version.class.getName()).warn("Unable to determine Flow version number", (Throwable)e);
            }
            VERSION = flowVersion;
            String[] digits = VERSION.split("[-.]", 4);
            VERSION_MAJOR = Integer.parseInt(digits[0]);
            VERSION_MINOR = Integer.parseInt(digits[1]);
            build = "";
            try {
                revision = Integer.parseInt(digits[2]);
                if (digits.length == 4) {
                    build = digits[3];
                }
            }
            catch (NumberFormatException e) {
                revision = 0;
                if (digits.length < 3) break block5;
                build = digits[2];
            }
        }
        VERSION_REVISION = revision;
        VERSION_BUILD = build;
        VERSION_BUILD_HASH = StringUtil.getHash(buildTimestamp, StandardCharsets.UTF_8);
    }
}

