/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.streams;

import com.vaadin.flow.dom.Element;
import com.vaadin.flow.server.HttpStatusCode;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinResponse;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.streams.ElementRequestHandler;
import com.vaadin.flow.server.streams.FileFactory;
import com.vaadin.flow.server.streams.FileUploadCallback;
import com.vaadin.flow.server.streams.FileUploadHandler;
import com.vaadin.flow.server.streams.InMemoryUploadCallback;
import com.vaadin.flow.server.streams.InMemoryUploadHandler;
import com.vaadin.flow.server.streams.TemporaryFileUploadHandler;
import com.vaadin.flow.server.streams.TransferProgressListener;
import com.vaadin.flow.server.streams.TransferUtil;
import com.vaadin.flow.server.streams.UploadEvent;
import java.io.IOException;

@FunctionalInterface
public interface UploadHandler
extends ElementRequestHandler {
    public void handleUploadRequest(UploadEvent var1) throws IOException;

    default public void responseHandled(boolean success, VaadinResponse response) {
        if (success) {
            response.setStatus(HttpStatusCode.OK.getCode());
        } else {
            response.setStatus(HttpStatusCode.INTERNAL_SERVER_ERROR.getCode());
        }
    }

    @Override
    default public void handleRequest(VaadinRequest request, VaadinResponse response, VaadinSession session, Element owner) throws IOException {
        TransferUtil.handleUpload(this, request, response, session, owner);
    }

    default public long getRequestSizeMax() {
        return -1L;
    }

    default public long getFileSizeMax() {
        return -1L;
    }

    default public long getFileCountMax() {
        return 10000L;
    }

    public static FileUploadHandler toFile(FileUploadCallback successCallback, FileFactory fileFactory) {
        return new FileUploadHandler(successCallback, fileFactory);
    }

    public static FileUploadHandler toFile(FileUploadCallback successCallback, FileFactory fileFactory, TransferProgressListener listener) {
        FileUploadHandler fileUploadHandler = new FileUploadHandler(successCallback, fileFactory);
        fileUploadHandler.addTransferProgressListener(listener);
        return fileUploadHandler;
    }

    public static TemporaryFileUploadHandler toTempFile(FileUploadCallback successCallback) {
        return new TemporaryFileUploadHandler(successCallback);
    }

    public static TemporaryFileUploadHandler toTempFile(FileUploadCallback successCallback, TransferProgressListener listener) {
        TemporaryFileUploadHandler temporaryFileUploadHandler = new TemporaryFileUploadHandler(successCallback);
        temporaryFileUploadHandler.addTransferProgressListener(listener);
        return temporaryFileUploadHandler;
    }

    public static InMemoryUploadHandler inMemory(InMemoryUploadCallback successCallback) {
        return new InMemoryUploadHandler(successCallback);
    }

    public static InMemoryUploadHandler inMemory(InMemoryUploadCallback successCallback, TransferProgressListener listener) {
        InMemoryUploadHandler inMemoryUploadHandler = new InMemoryUploadHandler(successCallback);
        inMemoryUploadHandler.addTransferProgressListener(listener);
        return inMemoryUploadHandler;
    }
}

