/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.fasterxml.jackson.databind.JsonNode;
import com.vaadin.flow.di.Lookup;
import com.vaadin.flow.di.ResourceProvider;
import com.vaadin.flow.function.DeploymentConfiguration;
import com.vaadin.flow.internal.DevModeHandler;
import com.vaadin.flow.internal.DevModeHandlerManager;
import com.vaadin.flow.internal.Pair;
import com.vaadin.flow.internal.StringUtil;
import com.vaadin.flow.internal.hilla.EndpointRequestUtil;
import com.vaadin.flow.internal.menu.MenuRegistry;
import com.vaadin.flow.server.AbstractConfiguration;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinServlet;
import com.vaadin.flow.server.frontend.FileIOUtils;
import com.vaadin.flow.server.frontend.FrontendVersion;
import com.vaadin.flow.server.frontend.Options;
import com.vaadin.flow.server.frontend.scanner.ClassFinder;
import jakarta.servlet.ServletContext;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.UnaryOperator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FrontendUtils {
    public static final String PROJECT_BASEDIR = "project.basedir";
    public static final String DEFAULT_NODE_DIR = "./";
    public static final String NODE_MODULES = "node_modules/";
    public static final String FRONTEND = "frontend/";
    public static final String GENERATED = "generated/";
    public static final String DEFAULT_FRONTEND_DIR = "./src/main/frontend/";
    public static final String LEGACY_FRONTEND_DIR = "./frontend/";
    public static final String VITE_CONFIG = "vite.config.ts";
    public static final String VITE_GENERATED_CONFIG = "vite.generated.ts";
    public static final String SERVICE_WORKER_SRC = "sw.ts";
    public static final String SERVICE_WORKER_SRC_JS = "sw.js";
    public static final String JAR_RESOURCES_FOLDER = "jar-resources";
    public static final String JAR_RESOURCES_IMPORT = "Frontend/generated/jar-resources/";
    public static final String JAR_RESOURCES_IMPORT_FRONTEND_RELATIVE = "Frontend/generated/jar-resources/".replace("Frontend/", "./");
    public static final String IMPORTS_NAME = "generated-flow-imports.js";
    public static final String IMPORTS_D_TS_NAME = "generated-flow-imports.d.ts";
    public static final String IMPORTS_WEB_COMPONENT_NAME = "generated-flow-webcomponent-imports.js";
    public static final String THEME_IMPORTS_D_TS_NAME = "theme.d.ts";
    public static final String THEME_IMPORTS_NAME = "theme.js";
    public static final String BOOTSTRAP_FILE_NAME = "vaadin.ts";
    public static final String WEB_COMPONENT_BOOTSTRAP_FILE_NAME = "vaadin-web-component.ts";
    public static final String FEATURE_FLAGS_FILE_NAME = "vaadin-featureflags.js";
    public static final String INDEX_HTML = "index.html";
    public static final String WEB_COMPONENT_HTML = "web-component.html";
    public static final String INDEX_TS = "index.ts";
    public static final String INDEX_JS = "index.js";
    public static final String INDEX_TSX = "index.tsx";
    public static final String VITE_DEVMODE_TS = "vite-devmode.ts";
    public static final String COMMERCIAL_BANNER_JS = "commercial-banner.js";
    public static final String ROUTES_TS = "routes.ts";
    public static final String ROUTES_TSX = "routes.tsx";
    public static final String ROUTES_FLOW_TSX = "routes-flow.tsx";
    public static final String ROUTES_JS = "routes.js";
    public static final String DEFAULT_PROJECT_FRONTEND_GENERATED_DIR = "./src/main/frontend/generated/";
    public static final String PARAM_FRONTEND_DIR = "vaadin.frontend.frontend.folder";
    public static final String PARAM_IGNORE_VERSION_CHECKS = "vaadin.ignoreVersionChecks";
    public static final String FRONTEND_FOLDER_ALIAS = "Frontend/";
    public static final String FRONTEND_GENERATED_FLOW_IMPORT_PATH = "Frontend/generated/flow/";
    public static final String HILLA_VIEWS_PATH = "views";
    public static final String TOKEN_FILE = "config/flow-build-info.json";
    public static final String CHUNKS = "chunks";
    public static final String EXPORT_CHUNK = "export";
    public static final String CSS_IMPORTS = "cssImports";
    public static final String JS_MODULES = "jsModules";
    public static final String PARAM_TOKEN_FILE = "vaadin.frontend.token.file";
    public static final String DISABLE_CHECK = "%nYou can disable the version check using -D%s=true";
    private static final String TOO_OLD = "%n%n======================================================================================================%nYour installed '%s' version (%s) is too old. Supported versions are %d.%d+%nPlease install a new one either:%n  - by following the https://nodejs.org/en/download/ guide to install it globally%n  - or by running the frontend-maven-plugin goal to install it in this project:%n  $ mvn com.github.eirslett:frontend-maven-plugin:1.10.0:install-node-and-npm -DnodeVersion=\"v22.22.0\" %n%nYou can disable the version check using -D%s=true%n======================================================================================================%n";
    static final String SYSTEM_NOPROXY_PROPERTY_KEY = "NOPROXY";
    static final String SYSTEM_HTTPS_PROXY_PROPERTY_KEY = "HTTPS_PROXY";
    static final String SYSTEM_HTTP_PROXY_PROPERTY_KEY = "HTTP_PROXY";
    public static final String YELLOW = "\u001b[38;5;111m%s\u001b[0m";
    public static final String RED = "\u001b[38;5;196m%s\u001b[0m";
    public static final String GREEN = "\u001b[38;5;35m%s\u001b[0m";
    public static final String BRIGHT_BLUE = "\u001b[94m%s\u001b[0m";
    private static final Pattern SERVER_SIDE_ROUTES_PATTERN = Pattern.compile("(?<=\\s|^)\\.{3}serverSideRoutes(?=\\s|$)", 8);
    private static final Pattern CLIENT_SIDE_ROUTES_PATTERN = Pattern.compile("(?<=(?:const|let|var) routes)(:\\s?\\w*\\[\\s?])?\\s?=\\s?\\[([\\s\\S]*?)(?=\\.{3}serverSideRoutes)", 8);
    private static final ExecutorService STREAM_EXECUTOR = Executors.newCachedThreadPool(r -> {
        Thread thread = new Thread(r, "vaadin-stream-consumer");
        thread.setDaemon(true);
        return thread;
    });

    private FrontendUtils() {
    }

    public static String getOsName() {
        return System.getProperty("os.name");
    }

    public static boolean isWindows() {
        return FrontendUtils.getOsName().startsWith("Windows");
    }

    public static String streamToString(InputStream inputStream) {
        String string;
        block8: {
            String ret = "";
            InputStream handledStream = inputStream;
            try {
                string = IOUtils.toString((InputStream)handledStream, (Charset)StandardCharsets.UTF_8).replaceAll("\\R", System.lineSeparator());
                if (handledStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (handledStream != null) {
                        try {
                            handledStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException exception) {
                    FrontendUtils.getLogger().warn("Couldn't close template input stream", (Throwable)exception);
                    return ret;
                }
            }
            handledStream.close();
        }
        return string;
    }

    public static ProcessBuilder createProcessBuilder(List<String> command) {
        return FrontendUtils.createProcessBuilder(command, UnaryOperator.identity());
    }

    public static ProcessBuilder createProcessBuilder(List<String> command, UnaryOperator<ProcessBuilder> configureProcessBuilder) {
        ProcessBuilder processBuilder = new ProcessBuilder(command);
        File commandFile = new File(command.get(0));
        if (commandFile.isAbsolute()) {
            String commandPath = commandFile.getParent();
            Map<String, String> environment = processBuilder.environment();
            String pathEnvVar = FrontendUtils.isWindows() ? environment.keySet().stream().filter("PATH"::equalsIgnoreCase).findFirst().orElse("Path") : "PATH";
            Object path = environment.get(pathEnvVar);
            path = path == null || ((String)path).isEmpty() ? commandPath : commandPath + File.pathSeparatorChar + (String)path;
            environment.put(pathEnvVar, (String)path);
        }
        return (ProcessBuilder)configureProcessBuilder.apply(processBuilder);
    }

    public static String getIndexHtmlContent(VaadinService service) throws IOException {
        return FrontendUtils.getFileContent(service, INDEX_HTML);
    }

    public static String getWebComponentHtmlContent(VaadinService service) throws IOException {
        return FrontendUtils.getFileContent(service, WEB_COMPONENT_HTML);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getFileContent(VaadinService service, String path) throws IOException {
        String string;
        DeploymentConfiguration config = service.getDeploymentConfiguration();
        InputStream content = null;
        try {
            Optional<DevModeHandler> devModeHandler = FrontendUtils.activeDevModeHandler(service);
            content = config.isProductionMode() ? FrontendUtils.getFileFromClassPath(service, path) : (devModeHandler.isPresent() ? FrontendUtils.getFileFromDevModeHandler(devModeHandler.get(), path) : FrontendUtils.getFileFromFrontendDir(config, path));
            string = content != null ? FrontendUtils.streamToString(content) : null;
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(content);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)content);
        return string;
    }

    private static Optional<DevModeHandler> activeDevModeHandler(VaadinService service) {
        return DevModeHandlerManager.getDevModeHandler(service).filter(d -> d.getPort() >= 0);
    }

    private static InputStream getFileFromFrontendDir(AbstractConfiguration config, String path) {
        File file = new File(FrontendUtils.getProjectFrontendDir(config), path);
        if (file.exists()) {
            try {
                return Files.newInputStream(file.toPath(), new OpenOption[0]);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return null;
    }

    private static InputStream getFileFromClassPath(VaadinService service, String filePath) {
        URL resource = service.getContext().getAttribute(Lookup.class).lookup(ResourceProvider.class).getApplicationResource("META-INF/VAADIN/webapp/" + filePath);
        if (resource == null) {
            FrontendUtils.getLogger().error("Cannot get the '{}' from the classpath", (Object)filePath);
            return null;
        }
        try {
            return resource.openStream();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static InputStream getFileFromDevModeHandler(DevModeHandler devModeHandler, String filePath) throws IOException {
        return devModeHandler.prepareConnection("/" + filePath, "GET").getInputStream();
    }

    public static InputStream getFrontendFileFromDevModeHandler(VaadinService service, String path) {
        Optional<DevModeHandler> devModeHandler = FrontendUtils.activeDevModeHandler(service);
        if (devModeHandler.isPresent()) {
            try {
                File frontendFile = FrontendUtils.resolveFrontendPath(devModeHandler.get().getProjectRoot(), service.getDeploymentConfiguration(), path);
                return frontendFile == null ? null : new FileInputStream(frontendFile);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Error reading file " + path, e);
            }
        }
        return null;
    }

    public static File resolveFrontendPath(File projectRoot, DeploymentConfiguration deploymentConfiguration, String path) {
        return FrontendUtils.resolveFrontendPath(projectRoot, path, deploymentConfiguration.getFrontendFolder());
    }

    public static File getLegacyFrontendFolderIfExists(File projectRoot, File frontendDir) {
        File legacy;
        if (!frontendDir.exists() && frontendDir.toPath().endsWith(DEFAULT_FRONTEND_DIR.substring(2)) && (legacy = new File(projectRoot, LEGACY_FRONTEND_DIR)).exists()) {
            return legacy;
        }
        return frontendDir;
    }

    public static File resolveFrontendPath(File projectRoot, String path, File frontendDirectory) {
        File nodeModulesFolder = new File(projectRoot, NODE_MODULES);
        File addonsFolder = FrontendUtils.getJarResourcesFolder(frontendDirectory);
        List<File> candidateParents = path.startsWith(DEFAULT_NODE_DIR) ? Arrays.asList(frontendDirectory, addonsFolder) : Arrays.asList(nodeModulesFolder, frontendDirectory, addonsFolder);
        return candidateParents.stream().map(parent -> new File((File)parent, path)).filter(File::exists).findFirst().orElse(null);
    }

    public static String getJarResourceString(String jarImport, ClassFinder finder) {
        String string;
        block10: {
            URL resource = finder.getResource("META-INF/frontend/" + jarImport);
            if (resource == null) {
                resource = finder.getResource("META-INF/resources/frontend/" + jarImport);
            }
            if (resource == null) {
                return null;
            }
            InputStream frontendContent = resource.openStream();
            try {
                string = FrontendUtils.streamToString(frontendContent);
                if (frontendContent == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (frontendContent != null) {
                        try {
                            frontendContent.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            frontendContent.close();
        }
        return string;
    }

    public static File getJarResourcesFolder(File frontendDirectory) {
        return new File(FrontendUtils.getFrontendGeneratedFolder(frontendDirectory), JAR_RESOURCES_FOLDER);
    }

    public static File getFrontendGeneratedFolder(File frontendDirectory) {
        return new File(frontendDirectory, GENERATED);
    }

    private static String buildTooOldString(String tool, String version, int supportedMajor, int supportedMinor) {
        return String.format(TOO_OLD, tool, version, supportedMajor, supportedMinor, PARAM_IGNORE_VERSION_CHECKS);
    }

    public static File getProjectFrontendDir(AbstractConfiguration configuration) {
        return configuration.getFrontendFolder();
    }

    public static String getUnixRelativePath(Path source, Path target) {
        return FrontendUtils.getUnixPath(source.relativize(target));
    }

    public static String getUnixPath(Path source) {
        return source.toString().replaceAll("\\\\", "/");
    }

    static void validateToolVersion(String tool, FrontendVersion toolVersion, FrontendVersion supported) {
        if (toolVersion.isEqualOrNewer(supported)) {
            return;
        }
        throw new IllegalStateException(FrontendUtils.buildTooOldString(tool, toolVersion.getFullVersion(), supported.getMajorVersion(), supported.getMinorVersion()));
    }

    protected static FrontendVersion getVersion(String tool, List<String> versionCommand) throws UnknownVersionException {
        String output;
        try {
            output = FrontendUtils.executeCommand(versionCommand);
        }
        catch (CommandExecutionException e) {
            throw new UnknownVersionException(tool, "Using command " + String.join((CharSequence)" ", versionCommand), e);
        }
        try {
            return new FrontendVersion(FrontendUtils.parseVersionString(output));
        }
        catch (IOException e) {
            throw new UnknownVersionException(tool, "Expected a version number as output but got '" + output + "' when using command " + String.join((CharSequence)" ", versionCommand), e);
        }
    }

    public static String executeCommand(List<String> command) throws CommandExecutionException {
        return FrontendUtils.executeCommand(command, UnaryOperator.identity());
    }

    public static String executeCommand(List<String> command, UnaryOperator<ProcessBuilder> configureProcessBuilder) throws CommandExecutionException {
        try {
            Process process = FrontendUtils.createProcessBuilder(command, configureProcessBuilder).start();
            CompletableFuture<Pair<String, String>> streamConsumer = FrontendUtils.consumeProcessStreams(process);
            int exitCode = process.waitFor();
            Pair<String, String> outputs = streamConsumer.get();
            process.destroy();
            if (exitCode != 0) {
                throw new CommandExecutionException(exitCode, outputs.getFirst(), outputs.getSecond());
            }
            return outputs.getFirst();
        }
        catch (ExecutionException e) {
            throw new CommandExecutionException(e.getCause());
        }
        catch (IOException | InterruptedException e) {
            throw new CommandExecutionException(e);
        }
    }

    public static CompletableFuture<Pair<String, String>> consumeProcessStreams(Process process) {
        CompletableFuture<String> stdOut = CompletableFuture.supplyAsync(() -> FrontendUtils.streamToString(process.getInputStream()), STREAM_EXECUTOR);
        CompletableFuture<String> stdErr = CompletableFuture.supplyAsync(() -> FrontendUtils.streamToString(process.getErrorStream()), STREAM_EXECUTOR);
        return CompletableFuture.allOf(stdOut, stdErr).thenApply(unused -> new Pair<String, String>(stdOut.getNow(""), stdErr.getNow("")));
    }

    public static FrontendVersion parseFrontendVersion(String versionString) throws IOException {
        return new FrontendVersion(FrontendUtils.parseVersionString(versionString));
    }

    public static File getVaadinHomeDirectory() {
        File home = FileUtils.getUserDirectory();
        if (!home.exists()) {
            throw new IllegalStateException("The user directory '" + home.getAbsolutePath() + "' doesn't exist");
        }
        if (!home.isDirectory()) {
            throw new IllegalStateException("The path '" + home.getAbsolutePath() + "' is not a directory");
        }
        File vaadinFolder = new File(home, ".vaadin");
        if (vaadinFolder.exists()) {
            if (vaadinFolder.isDirectory()) {
                return vaadinFolder;
            }
            throw new IllegalStateException("The path '" + vaadinFolder.getAbsolutePath() + "' is not a directory. This path is used to store vaadin related data. Please either remove the file or create a directory");
        }
        try {
            FileUtils.forceMkdir((File)vaadinFolder);
            return vaadinFolder;
        }
        catch (IOException exception) {
            throw new UncheckedIOException("Couldn't create '.vaadin' folder inside home directory '" + home.getAbsolutePath() + "'", exception);
        }
    }

    static String parseVersionString(String output) throws IOException {
        Optional<String> lastOuput = Stream.of(output.split("\n")).filter(line -> !line.matches("^[ ]*$")).reduce((first, second) -> second);
        return lastOuput.map(line -> line.replaceFirst("^v", "")).orElseThrow(() -> new IOException("No output"));
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(FrontendUtils.class);
    }

    public static String commandToString(String baseDir, List<String> command) {
        StringBuilder retval = new StringBuilder("\n");
        StringBuilder curLine = new StringBuilder();
        for (String fragment : command) {
            if (curLine.length() + fragment.length() > 55) {
                retval.append(curLine.toString());
                retval.append("\\ \n");
                curLine = new StringBuilder("    ");
            }
            curLine.append(fragment.replace(baseDir, "."));
            curLine.append(" ");
        }
        retval.append(curLine.toString());
        retval.append("\n");
        return retval.toString();
    }

    public static FrontendVersion getPackageVersionFromJson(JsonNode sourceJson, String pkg, String versionOrigin) {
        if (!sourceJson.has(pkg)) {
            return null;
        }
        try {
            String versionString = sourceJson.get(pkg).textValue();
            return new FrontendVersion(pkg, versionString);
        }
        catch (ClassCastException classCastException) {
            LoggerFactory.getLogger(FrontendVersion.class).warn("Ignoring error while parsing frontend dependency version for package '{}' in '{}'", (Object)pkg, (Object)versionOrigin);
        }
        catch (NumberFormatException nfe) {
            LoggerFactory.getLogger(FrontendVersion.class).warn("Ignoring error while parsing frontend dependency version in {}: {}", (Object)versionOrigin, (Object)nfe.getMessage());
        }
        return null;
    }

    public static void console(String format, Object message) {
        System.out.print(String.format(format, message));
    }

    public static void deleteNodeModules(File nodeModules) throws IOException {
        if (!nodeModules.exists()) {
            return;
        }
        if (!nodeModules.isDirectory() || !nodeModules.getName().equals("node_modules")) {
            throw new IOException(nodeModules.getAbsolutePath() + " does not look like a node_modules directory");
        }
        FrontendUtils.deleteDirectory(nodeModules);
    }

    public static void deleteDirectory(File directory) throws IOException {
        if (!directory.exists() || !directory.isDirectory()) {
            return;
        }
        if (!Files.isSymbolicLink(directory.toPath()) && !FrontendUtils.isJunction(directory.toPath())) {
            FrontendUtils.cleanDirectory(directory);
        }
        if (!directory.delete()) {
            String message = "Unable to delete directory " + directory + ".";
            throw new IOException(message);
        }
    }

    private static boolean isJunction(Path directory) throws IOException {
        boolean isWindows = System.getProperty("os.name").toLowerCase().contains("windows");
        BasicFileAttributes attrs = Files.readAttributes(directory, BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
        return isWindows && attrs.isDirectory() && attrs.isOther();
    }

    private static void cleanDirectory(File directory) throws IOException {
        if (!directory.exists()) {
            String message = directory + " does not exist";
            throw new IllegalArgumentException(message);
        }
        if (!directory.isDirectory()) {
            String message = directory + " is not a directory";
            throw new IllegalArgumentException(message);
        }
        File[] files = directory.listFiles();
        if (files == null) {
            throw new IOException("Failed to list contents of " + directory);
        }
        IOException exception = null;
        for (File file : files) {
            try {
                FrontendUtils.forceDelete(file);
            }
            catch (IOException ioe) {
                exception = ioe;
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    private static void forceDelete(File file) throws IOException {
        if (file.isDirectory()) {
            FrontendUtils.deleteDirectory(file);
        } else {
            boolean filePresent = file.exists();
            if (!file.delete()) {
                if (!filePresent) {
                    throw new FileNotFoundException("File does not exist: " + file);
                }
                String message = "Unable to delete file: " + file;
                throw new IOException(message);
            }
        }
    }

    public static String getFrontendServletPath(ServletContext servletContext) {
        String mapping = VaadinServlet.getFrontendMapping();
        if (mapping.endsWith("/*")) {
            mapping = mapping.replace("/*", "");
        }
        return mapping;
    }

    public static File getFlowGeneratedFolder(File frontendFolder) {
        return new File(FrontendUtils.getFrontendGeneratedFolder(frontendFolder), "flow");
    }

    public static File getFlowGeneratedImports(File frontendFolder) {
        return new File(FrontendUtils.getFlowGeneratedFolder(frontendFolder), IMPORTS_NAME);
    }

    public static File getFlowGeneratedWebComponentsImports(File frontendFolder) {
        return new File(FrontendUtils.getFlowGeneratedFolder(frontendFolder), IMPORTS_WEB_COMPONENT_NAME);
    }

    public static File getFlowGeneratedWebComponentsFolder(File frontendFolder) {
        return new File(FrontendUtils.getFlowGeneratedFolder(frontendFolder), "web-components");
    }

    public static boolean isReactRouterRequired(File frontendDirectory) {
        Objects.requireNonNull(frontendDirectory);
        boolean result = true;
        File indexTs = new File(frontendDirectory, INDEX_TS);
        if (indexTs.exists()) {
            try {
                String indexTsContent = IOUtils.toString((URI)indexTs.toURI(), (Charset)StandardCharsets.UTF_8);
                indexTsContent = StringUtil.removeComments(indexTsContent);
                result = !indexTsContent.contains("@vaadin/router");
            }
            catch (IOException e) {
                FrontendUtils.getLogger().error("Couldn't auto-detect React/Lit application, react-router will be used", (Throwable)e);
            }
        }
        if (FrontendUtils.getLogger().isDebugEnabled()) {
            FrontendUtils.getLogger().debug("Auto-detected client-side router to use: {}", (Object)(result ? "react-router" : "vaadin-router"));
        }
        return result;
    }

    public static boolean isHillaViewsUsed(File frontendDirectory) {
        Objects.requireNonNull(frontendDirectory);
        File viewsDirectory = new File(frontendDirectory, HILLA_VIEWS_PATH);
        if (viewsDirectory.exists()) {
            try {
                List<Path> views = FileIOUtils.getFilesByPattern(viewsDirectory.toPath(), "**/*.{js,jsx,ts,tsx}");
                for (Path view : views) {
                    String viewContent = IOUtils.toString((URI)view.toUri(), (Charset)StandardCharsets.UTF_8);
                    if ((viewContent = StringUtil.removeComments(viewContent)).isBlank()) continue;
                    return true;
                }
            }
            catch (IOException e) {
                FrontendUtils.getLogger().error("Couldn't scan Hilla views directory for hilla auto-detection", (Throwable)e);
            }
        }
        List<String> files = List.of(INDEX_TS, INDEX_TSX, ROUTES_TS);
        for (String fileName : files) {
            File routesFile = new File(frontendDirectory, fileName);
            if (!routesFile.exists()) continue;
            try {
                String routesTsContent = IOUtils.toString((URI)routesFile.toURI(), (Charset)StandardCharsets.UTF_8);
                return FrontendUtils.isRoutesContentUsingHillaViews(routesTsContent);
            }
            catch (IOException e) {
                FrontendUtils.getLogger().error("Couldn't read {} for hilla views auto-detection", (Object)routesFile.getName(), (Object)e);
            }
        }
        File routesFile = new File(frontendDirectory, ROUTES_TSX);
        if (routesFile.exists()) {
            try {
                String routesTsContent = IOUtils.toString((URI)routesFile.toURI(), (Charset)StandardCharsets.UTF_8);
                return FrontendUtils.isRoutesTsxContentUsingHillaViews(routesTsContent);
            }
            catch (IOException e) {
                FrontendUtils.getLogger().error("Couldn't read {} for hilla views auto-detection", (Object)routesFile.getName(), (Object)e);
            }
        }
        return false;
    }

    public static boolean isHillaUsed(File frontendDirectory) {
        return EndpointRequestUtil.isHillaAvailable() && FrontendUtils.isHillaViewsUsed(frontendDirectory);
    }

    public static boolean isHillaUsed(File frontendDirectory, ClassFinder classFinder) {
        return EndpointRequestUtil.isHillaAvailable(classFinder) && FrontendUtils.isHillaViewsUsed(frontendDirectory);
    }

    private static boolean isRoutesContentUsingHillaViews(String routesContent) {
        if (FrontendUtils.missingServerSideRoutes(routesContent = StringUtil.removeComments(routesContent))) {
            return true;
        }
        return FrontendUtils.mayHaveClientSideRoutes(routesContent);
    }

    private static boolean isRoutesTsxContentUsingHillaViews(String routesContent) {
        if (FrontendUtils.hasFileOrReactRoutesFunction(routesContent = StringUtil.removeComments(routesContent))) {
            return true;
        }
        return FrontendUtils.isRoutesContentUsingHillaViews(routesContent);
    }

    private static boolean missingServerSideRoutes(String routesContent) {
        return !SERVER_SIDE_ROUTES_PATTERN.matcher(routesContent).find();
    }

    private static boolean hasFileOrReactRoutesFunction(String routesContent) {
        return !routesContent.isBlank() && (routesContent.contains("withFileRoutes(") || routesContent.contains("withReactRoutes("));
    }

    private static boolean mayHaveClientSideRoutes(String routesContent) {
        Matcher matcher = CLIENT_SIDE_ROUTES_PATTERN.matcher(routesContent);
        while (matcher.find()) {
            for (int index = 1; index <= matcher.groupCount(); ++index) {
                String group = matcher.group(index);
                if (group != null && !group.isBlank() && group.startsWith(":") || group == null || group.isBlank()) continue;
                group = group.trim();
                return group.contains(",");
            }
        }
        return false;
    }

    public static boolean isReactModuleAvailable(Options options) {
        try {
            options.getClassFinder().loadClass("com.vaadin.flow.component.react.ReactAdapterComponent");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static List<String> getClientRoutes() {
        return MenuRegistry.getClientRoutes(false, VaadinService.getCurrent().getDeploymentConfiguration());
    }

    public static class CommandExecutionException
    extends Exception {
        public CommandExecutionException(int processExitCode) {
            super("Process execution failed with exit code " + processExitCode);
        }

        public CommandExecutionException(int processExitCode, String output, String errorOutput) {
            super("Process execution failed with exit code " + processExitCode + "\nOutput: " + output + "\nError output: " + errorOutput);
        }

        public CommandExecutionException(Throwable cause) {
            super("Process execution failed", cause);
        }
    }

    public static class UnknownVersionException
    extends Exception {
        public UnknownVersionException(String tool, String extraInfo) {
            super("Unable to detect version of " + tool + ". " + extraInfo);
        }

        public UnknownVersionException(String tool, String extraInfo, Exception cause) {
            super("Unable to detect version of " + tool + ". " + extraInfo, cause);
        }
    }
}

