/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileIOUtils {
    private FileIOUtils() {
    }

    private static Logger log() {
        return LoggerFactory.getLogger(FileIOUtils.class);
    }

    public static File getProjectFolderFromClasspath() {
        try {
            URL url = FileIOUtils.class.getClassLoader().getResource(".");
            if (url != null && url.getProtocol().equals("file")) {
                return FileIOUtils.getProjectFolderFromClasspath(url);
            }
        }
        catch (Exception e) {
            FileIOUtils.log().warn("Unable to determine project folder using classpath", (Throwable)e);
        }
        return null;
    }

    static File getProjectFolderFromClasspath(URL rootFolder) throws URISyntaxException {
        Path path = Path.of(rootFolder.toURI());
        if (path.endsWith(Path.of("target", "classes"))) {
            return path.getParent().getParent().toFile();
        }
        return null;
    }
}

