/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.internal;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.router.internal.AbstractNavigationStateRenderer;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.startup.ApplicationConfiguration;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ComponentTracker {
    private static final Map<Component, Location> createLocation = Collections.synchronizedMap(new WeakHashMap());
    private static final Map<Component, Location> attachLocation = Collections.synchronizedMap(new WeakHashMap());
    private static Boolean disabled = null;
    private static final String[] prefixesToSkip = new String[]{"com.vaadin.flow.component.", "com.vaadin.flow.di.", "com.vaadin.flow.dom.", "com.vaadin.flow.internal.", "com.vaadin.flow.spring.", "java.", "jdk.", "org.springframework.beans."};

    public static Location findCreate(Component component) {
        return createLocation.get(component);
    }

    public static void trackCreate(Component component) {
        if (ComponentTracker.isDisabled()) {
            return;
        }
        StackTraceElement[] stack = Thread.currentThread().getStackTrace();
        Location[] relevantLocations = ComponentTracker.findRelevantLocations(stack);
        Location location = ComponentTracker.findRelevantLocation(component.getClass(), relevantLocations, null);
        if (ComponentTracker.isNavigatorCreate(location)) {
            location = ComponentTracker.findRelevantLocation(null, relevantLocations, null);
        }
        createLocation.put(component, location);
    }

    public static Location findAttach(Component component) {
        return attachLocation.get(component);
    }

    public static void trackAttach(Component component) {
        if (ComponentTracker.isDisabled()) {
            return;
        }
        StackTraceElement[] stack = Thread.currentThread().getStackTrace();
        Location[] relevantLocations = ComponentTracker.findRelevantLocations(stack);
        Location location = ComponentTracker.findRelevantLocation(component.getClass(), relevantLocations, ComponentTracker.findCreate(component));
        if (ComponentTracker.isNavigatorCreate(location)) {
            location = createLocation.get(component);
        }
        attachLocation.put(component, location);
    }

    private static Location[] findRelevantLocations(StackTraceElement[] stack) {
        return (Location[])Stream.of(stack).filter(e -> {
            for (String prefixToSkip : prefixesToSkip) {
                if (!e.getClassName().startsWith(prefixToSkip)) continue;
                return false;
            }
            return true;
        }).map(ComponentTracker::toLocation).toArray(Location[]::new);
    }

    private static Location findRelevantLocation(Class<? extends Component> excludeClass, Location[] locations, Location preferredClass) {
        Optional<Location> preferredCandidate;
        List candidates = Arrays.stream(locations).filter(location -> excludeClass == null || !location.className().equals(excludeClass.getName())).filter(location -> {
            for (String prefixToSkip : prefixesToSkip) {
                if (!location.className().startsWith(prefixToSkip)) continue;
                return false;
            }
            return true;
        }).collect(Collectors.toList());
        if (preferredClass != null && (preferredCandidate = candidates.stream().filter(location -> location.className().equals(preferredClass.className())).findFirst()).isPresent()) {
            return preferredCandidate.get();
        }
        return candidates.isEmpty() ? null : (Location)candidates.get(0);
    }

    private static boolean isNavigatorCreate(Location location) {
        return location.className().equals(AbstractNavigationStateRenderer.class.getName());
    }

    private static boolean isDisabled() {
        if (disabled != null) {
            return disabled;
        }
        VaadinService service = VaadinService.getCurrent();
        if (service == null) {
            return true;
        }
        VaadinContext context = service.getContext();
        if (context == null) {
            return true;
        }
        ApplicationConfiguration applicationConfiguration = ApplicationConfiguration.get(context);
        if (applicationConfiguration == null) {
            return true;
        }
        disabled = applicationConfiguration.isProductionMode() || !applicationConfiguration.getBooleanProperty("devmode.componentTracker.enabled", true);
        return disabled;
    }

    private static Location toLocation(StackTraceElement stackTraceElement) {
        if (stackTraceElement == null) {
            return null;
        }
        String className = stackTraceElement.getClassName();
        String fileName = stackTraceElement.getFileName();
        String methodName = stackTraceElement.getMethodName();
        int lineNumber = stackTraceElement.getLineNumber();
        return new Location(className, fileName, methodName, lineNumber);
    }

    public static class Location
    implements Serializable {
        private final String className;
        private final String filename;
        private final String methodName;
        private final int lineNumber;

        public Location(String className, String filename, String methodName, int lineNumber) {
            this.className = className;
            this.filename = filename;
            this.methodName = methodName;
            this.lineNumber = lineNumber;
        }

        public String className() {
            return this.className;
        }

        public String filename() {
            return this.filename;
        }

        public String methodName() {
            return this.methodName;
        }

        public int lineNumber() {
            return this.lineNumber;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Location location = (Location)o;
            if (this.lineNumber != location.lineNumber) {
                return false;
            }
            if (!Objects.equals(this.className, location.className)) {
                return false;
            }
            if (!Objects.equals(this.filename, location.filename)) {
                return false;
            }
            return Objects.equals(this.methodName, location.methodName);
        }

        public int hashCode() {
            int result = this.className != null ? this.className.hashCode() : 0;
            result = 31 * result + (this.filename != null ? this.filename.hashCode() : 0);
            result = 31 * result + (this.methodName != null ? this.methodName.hashCode() : 0);
            result = 31 * result + this.lineNumber;
            return result;
        }

        public String toString() {
            return "Component '" + this.className + "' at '" + this.filename + "' (" + this.methodName + " LINE " + this.lineNumber + ")";
        }
    }
}

