/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.pro.licensechecker.BuildType;
import com.vaadin.pro.licensechecker.LicenseChecker;
import com.vaadin.pro.licensechecker.LocalOfflineKey;
import com.vaadin.pro.licensechecker.LocalProKey;
import com.vaadin.pro.licensechecker.Product;
import elemental.json.Json;
import elemental.json.JsonObject;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CvdlProducts {
    private static final String CVDL_PACKAGE_KEY = "cvdlName";

    public static Product getProductIfCvdl(File nodeModules, String npmModule) {
        File packageJsonFile = new File(new File(nodeModules, npmModule), "package.json");
        if (!packageJsonFile.exists()) {
            return null;
        }
        try {
            JsonObject packageJson = Json.parse((String)FileUtils.readFileToString((File)packageJsonFile, (Charset)StandardCharsets.UTF_8));
            if (packageJson.hasKey(CVDL_PACKAGE_KEY)) {
                return new Product(packageJson.getString(CVDL_PACKAGE_KEY), packageJson.getString("version"));
            }
            return null;
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to read package.json file " + packageJsonFile, e);
        }
    }

    public static boolean includeInFallbackBundle(String module, File nodeModules) {
        if (module.startsWith(".") || module.startsWith("Frontend/")) {
            return true;
        }
        String npmModule = CvdlProducts.getNpmModule(module);
        if (npmModule == null) {
            return true;
        }
        Product product = CvdlProducts.getProductIfCvdl(nodeModules, npmModule);
        if (product != null) {
            if (LocalProKey.get() == null && LocalOfflineKey.get() == null) {
                CvdlProducts.getLogger().debug("No pro key or offline key found. Dropping '{}' from the fallback bundle without asking for validation", (Object)module);
                return false;
            }
            try {
                LicenseChecker.checkLicense((String)product.getName(), (String)product.getVersion(), (BuildType)BuildType.PRODUCTION);
                return true;
            }
            catch (Exception e) {
                CvdlProducts.getLogger().debug("License check failed. Dropping '{}' from the fallback bundle", (Object)module, (Object)e);
                return false;
            }
        }
        return true;
    }

    private static String getNpmModule(String module) {
        String[] parts = module.split("/", -1);
        if (parts.length < 2) {
            return null;
        }
        if (parts[0].startsWith("@")) {
            return parts[0] + "/" + parts[1];
        }
        return parts[0];
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(CvdlProducts.class);
    }
}

