/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.server.frontend.FallibleCommand;
import com.vaadin.flow.server.frontend.JarContentsManager;
import com.vaadin.flow.server.frontend.TaskCopyLocalFrontendFiles;
import java.io.File;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskCopyFrontendFiles
implements FallibleCommand {
    private static final String WILDCARD_INCLUSION_APP_THEME_JAR = "**/themes/**/*";
    private final File targetDirectory;
    private Set<File> resourceLocations = null;

    TaskCopyFrontendFiles(File targetDirectory, Set<File> resourcesToScan) {
        Objects.requireNonNull(targetDirectory, "Parameter 'targetDirectory' must not be null");
        Objects.requireNonNull(resourcesToScan, "Parameter 'jarFilesToScan' must not be null");
        this.targetDirectory = targetDirectory;
        this.resourceLocations = resourcesToScan.stream().filter(File::exists).collect(Collectors.toSet());
    }

    @Override
    public void execute() {
        long start = System.nanoTime();
        this.log().info("Copying frontend resources from jar files ...");
        TaskCopyLocalFrontendFiles.createTargetFolder(this.targetDirectory);
        JarContentsManager jarContentsManager = new JarContentsManager();
        for (File location : this.resourceLocations) {
            if (location.isDirectory()) {
                TaskCopyLocalFrontendFiles.copyLocalResources(new File(location, "META-INF/frontend"), this.targetDirectory);
                TaskCopyLocalFrontendFiles.copyLocalResources(new File(location, "META-INF/resources/frontend"), this.targetDirectory);
                continue;
            }
            jarContentsManager.copyIncludedFilesFromJarTrimmingBasePath(location, "META-INF/frontend", this.targetDirectory, "**/*");
            jarContentsManager.copyIncludedFilesFromJarTrimmingBasePath(location, "META-INF/resources/frontend", this.targetDirectory, "**/*");
            jarContentsManager.copyIncludedFilesFromJarTrimmingBasePath(location, "META-INF/resources/", this.targetDirectory, WILDCARD_INCLUSION_APP_THEME_JAR);
        }
        long ms = (System.nanoTime() - start) / 1000000L;
        this.log().info("Visited {} resources. Took {} ms.", (Object)this.resourceLocations.size(), (Object)ms);
    }

    private Logger log() {
        return LoggerFactory.getLogger(this.getClass());
    }
}

