/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.di.DefaultInstantiator;
import com.vaadin.flow.di.Instantiator;
import com.vaadin.flow.di.InstantiatorFactory;
import com.vaadin.flow.di.Lookup;
import com.vaadin.flow.function.DeploymentConfiguration;
import com.vaadin.flow.i18n.I18NProvider;
import com.vaadin.flow.internal.CurrentInstance;
import com.vaadin.flow.internal.LocaleUtil;
import com.vaadin.flow.internal.UsageStatistics;
import com.vaadin.flow.router.RouteData;
import com.vaadin.flow.router.Router;
import com.vaadin.flow.router.internal.AbstractNavigationStateRenderer;
import com.vaadin.flow.server.BootstrapInitialPredicate;
import com.vaadin.flow.server.BootstrapListener;
import com.vaadin.flow.server.BootstrapPageResponse;
import com.vaadin.flow.server.BootstrapUrlPredicate;
import com.vaadin.flow.server.Command;
import com.vaadin.flow.server.DefaultSystemMessagesProvider;
import com.vaadin.flow.server.DependencyFilter;
import com.vaadin.flow.server.ErrorEvent;
import com.vaadin.flow.server.FutureAccess;
import com.vaadin.flow.server.HandlerHelper;
import com.vaadin.flow.server.HttpStatusCode;
import com.vaadin.flow.server.PwaRegistry;
import com.vaadin.flow.server.RequestHandler;
import com.vaadin.flow.server.RouteRegistry;
import com.vaadin.flow.server.ServiceDestroyEvent;
import com.vaadin.flow.server.ServiceDestroyListener;
import com.vaadin.flow.server.ServiceException;
import com.vaadin.flow.server.ServiceInitEvent;
import com.vaadin.flow.server.SessionDestroyEvent;
import com.vaadin.flow.server.SessionDestroyListener;
import com.vaadin.flow.server.SessionExpiredException;
import com.vaadin.flow.server.SessionExpiredHandler;
import com.vaadin.flow.server.SessionInitEvent;
import com.vaadin.flow.server.SessionInitListener;
import com.vaadin.flow.server.SystemMessages;
import com.vaadin.flow.server.SystemMessagesInfo;
import com.vaadin.flow.server.SystemMessagesProvider;
import com.vaadin.flow.server.UIInitEvent;
import com.vaadin.flow.server.UIInitListener;
import com.vaadin.flow.server.UnsupportedBrowserHandler;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinResponse;
import com.vaadin.flow.server.VaadinServletResponse;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.VaadinSessionState;
import com.vaadin.flow.server.Version;
import com.vaadin.flow.server.WebBrowser;
import com.vaadin.flow.server.WrappedSession;
import com.vaadin.flow.server.communication.AtmospherePushConnection;
import com.vaadin.flow.server.communication.HeartbeatHandler;
import com.vaadin.flow.server.communication.IndexHtmlRequestListener;
import com.vaadin.flow.server.communication.IndexHtmlResponse;
import com.vaadin.flow.server.communication.JavaScriptBootstrapHandler;
import com.vaadin.flow.server.communication.PwaHandler;
import com.vaadin.flow.server.communication.SessionRequestHandler;
import com.vaadin.flow.server.communication.StreamRequestHandler;
import com.vaadin.flow.server.communication.UidlRequestHandler;
import com.vaadin.flow.server.communication.WebComponentBootstrapHandler;
import com.vaadin.flow.server.communication.WebComponentProvider;
import com.vaadin.flow.shared.Registration;
import com.vaadin.flow.shared.communication.PushMode;
import elemental.json.Json;
import elemental.json.JsonException;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import elemental.json.impl.JsonUtil;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class VaadinService
implements Serializable {
    private static final String SEPARATOR = "\n=================================================================";
    public static final String INVALID_ATMOSPHERE_VERSION_WARNING = "\n=================================================================\nVaadin depends on Atmosphere {} but version {} was found.\nThis might cause compatibility problems if push is used.\n=================================================================";
    public static final String ATMOSPHERE_MISSING_ERROR = "\n=================================================================\nAtmosphere could not be loaded. When using push with Vaadin, the\nAtmosphere framework must be present on the classpath.\nIf using a dependency management system, please add a dependency\nto vaadin-push.\nIf managing dependencies manually, please make sure Atmosphere\n2.7.3.slf4jvaadin7 is included on the classpath.\nWill fall back to using " + PushMode.class.getSimpleName() + "." + PushMode.DISABLED.name() + ".\n=================================================================";
    static final String PRESERVE_UNBOUND_SESSION_ATTRIBUTE = VaadinService.class.getName() + ".reinitializing";
    private static final String REQUEST_START_TIME_ATTRIBUTE = "requestStartTime";
    private final DeploymentConfiguration deploymentConfiguration;
    private final Set<ServiceDestroyListener> serviceDestroyListeners = Collections.newSetFromMap(new ConcurrentHashMap());
    private final List<SessionInitListener> sessionInitListeners = new CopyOnWriteArrayList<SessionInitListener>();
    private final List<UIInitListener> uiInitListeners = new CopyOnWriteArrayList<UIInitListener>();
    private final List<SessionDestroyListener> sessionDestroyListeners = new CopyOnWriteArrayList<SessionDestroyListener>();
    private SystemMessagesProvider systemMessagesProvider = DefaultSystemMessagesProvider.get();
    private ClassLoader classLoader;
    private Iterable<RequestHandler> requestHandlers;
    private Iterable<BootstrapListener> bootstrapListeners;
    private transient Iterable<IndexHtmlRequestListener> indexHtmlRequestListeners;
    private Iterable<DependencyFilter> dependencyFilters;
    private boolean atmosphereAvailable = VaadinService.checkAtmosphereSupport();
    private BootstrapInitialPredicate bootstrapInitialPredicate;
    private BootstrapUrlPredicate bootstrapUrlPredicate;
    private boolean pushWarningEmitted = false;
    private boolean initialized = false;
    private Router router;
    private Instantiator instantiator;
    private VaadinContext vaadinContext;

    public VaadinService(DeploymentConfiguration deploymentConfiguration) {
        this.deploymentConfiguration = deploymentConfiguration;
    }

    protected VaadinService() {
        this.deploymentConfiguration = null;
        this.vaadinContext = null;
    }

    public void init() throws ServiceException {
        this.doSetClassLoader();
        this.instantiator = this.createInstantiator();
        this.router = new Router(this.getRouteRegistry());
        List<RequestHandler> handlers = this.createRequestHandlers();
        ServiceInitEvent event = new ServiceInitEvent(this);
        this.runWithServiceContext(() -> {
            this.instantiator.getServiceInitListeners().forEach(listener -> listener.serviceInit(event));
            event.getAddedRequestHandlers().forEach(handlers::add);
            Collections.reverse(handlers);
            this.requestHandlers = Collections.unmodifiableCollection(handlers);
            this.dependencyFilters = Collections.unmodifiableCollection(this.instantiator.getDependencyFilters(event.getAddedDependencyFilters()).collect(Collectors.toList()));
            this.bootstrapListeners = this.instantiator.getBootstrapListeners(event.getAddedBootstrapListeners()).collect(Collectors.toList());
            this.indexHtmlRequestListeners = this.instantiator.getIndexHtmlRequestListeners(event.getAddedIndexHtmlRequestListeners()).collect(Collectors.toList());
        });
        DeploymentConfiguration configuration = this.getDeploymentConfiguration();
        if (!configuration.isProductionMode()) {
            Logger logger = VaadinService.getLogger();
            logger.debug("The application has the following routes: ");
            List<RouteData> routeDataList = this.getRouteRegistry().getRegisteredRoutes();
            if (!routeDataList.isEmpty()) {
                this.addRouterUsageStatistics();
            }
            routeDataList.stream().map(Object::toString).forEach(arg_0 -> ((Logger)logger).debug(arg_0));
        }
        if (this.getDeploymentConfiguration().isPnpmEnabled()) {
            UsageStatistics.markAsUsed("flow/pnpm", null);
        }
        this.initialized = true;
    }

    private void addRouterUsageStatistics() {
        if (UsageStatistics.getEntries().anyMatch(e -> "routing/client".equals(e.getName()))) {
            UsageStatistics.removeEntry("routing/client");
            UsageStatistics.markAsUsed("routing/hybrid", Version.getFullVersion());
        } else if (UsageStatistics.getEntries().noneMatch(e -> "flow/BootstrapHandler".equals(e.getName()))) {
            UsageStatistics.markAsUsed("routing/server", Version.getFullVersion());
        }
    }

    protected abstract RouteRegistry getRouteRegistry();

    protected abstract PwaRegistry getPwaRegistry();

    public abstract String getContextRootRelativePath(VaadinRequest var1);

    protected List<RequestHandler> createRequestHandlers() throws ServiceException {
        ArrayList<RequestHandler> handlers = new ArrayList<RequestHandler>();
        handlers.add(new JavaScriptBootstrapHandler());
        handlers.add(new SessionRequestHandler());
        handlers.add(new HeartbeatHandler());
        handlers.add(new UidlRequestHandler());
        handlers.add(new UnsupportedBrowserHandler());
        handlers.add(new StreamRequestHandler());
        handlers.add(new PwaHandler(() -> this.getPwaRegistry()));
        handlers.add(new WebComponentProvider());
        handlers.add(new WebComponentBootstrapHandler());
        return handlers;
    }

    protected Instantiator createInstantiator() throws ServiceException {
        return this.loadInstantiators().orElseGet(() -> {
            DefaultInstantiator defaultInstantiator = new DefaultInstantiator(this);
            defaultInstantiator.init(this);
            return defaultInstantiator;
        });
    }

    protected Optional<Instantiator> loadInstantiators() throws ServiceException {
        Lookup lookup = this.getContext().getAttribute(Lookup.class);
        ArrayList<Instantiator> instantiators = null;
        if (lookup != null) {
            Collection<InstantiatorFactory> factories = lookup.lookupAll(InstantiatorFactory.class);
            instantiators = new ArrayList(factories.size());
            for (InstantiatorFactory factory : factories) {
                Instantiator instantiator = factory.createInstantitor(this);
                if (instantiator == null || !instantiator.init(this)) continue;
                instantiators.add(instantiator);
            }
        }
        if (instantiators == null) {
            instantiators = new ArrayList<Instantiator>();
        }
        StreamSupport.stream(ServiceLoader.load(Instantiator.class, this.getClassLoader()).spliterator(), false).filter(iterator -> iterator.init(this)).forEach(instantiators::add);
        if (instantiators.size() > 1) {
            throw new ServiceException("Cannot init VaadinService because there are multiple eligible instantiator implementations: " + instantiators);
        }
        return instantiators.stream().findFirst();
    }

    public Instantiator getInstantiator() {
        return this.instantiator;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        if (classLoader == null) {
            throw new IllegalArgumentException("Can not set class loader to null");
        }
        this.classLoader = classLoader;
    }

    public abstract String getMimeType(String var1);

    public DeploymentConfiguration getDeploymentConfiguration() {
        return this.deploymentConfiguration;
    }

    public void setSystemMessagesProvider(SystemMessagesProvider systemMessagesProvider) {
        if (systemMessagesProvider == null) {
            throw new IllegalArgumentException("SystemMessagesProvider can not be null.");
        }
        this.systemMessagesProvider = systemMessagesProvider;
    }

    public SystemMessagesProvider getSystemMessagesProvider() {
        return this.systemMessagesProvider;
    }

    public SystemMessages getSystemMessages(Locale locale, VaadinRequest request) {
        SystemMessagesInfo systemMessagesInfo = new SystemMessagesInfo(locale, request, this);
        return this.getSystemMessagesProvider().getSystemMessages(systemMessagesInfo);
    }

    public Registration addSessionInitListener(SessionInitListener listener) {
        return Registration.addAndRemove(this.sessionInitListeners, listener);
    }

    public Registration addUIInitListener(UIInitListener listener) {
        return Registration.addAndRemove(this.uiInitListeners, listener);
    }

    public Registration addSessionDestroyListener(SessionDestroyListener listener) {
        return Registration.addAndRemove(this.sessionDestroyListeners, listener);
    }

    @Deprecated
    public void modifyBootstrapPage(BootstrapPageResponse response) {
        this.bootstrapListeners.forEach(listener -> listener.modifyBootstrapPage(response));
    }

    public void modifyIndexHtmlResponse(IndexHtmlResponse response) {
        this.indexHtmlRequestListeners.forEach(listener -> listener.modifyIndexHtmlResponse(response));
    }

    public void fireSessionDestroy(VaadinSession vaadinSession) {
        VaadinSession session = vaadinSession;
        session.access(() -> {
            if (session.getState() == VaadinSessionState.CLOSED) {
                return;
            }
            if (session.getState() == VaadinSessionState.OPEN) {
                this.closeSession(session);
            }
            ArrayList<UI> uis = new ArrayList<UI>(session.getUIs());
            for (UI ui : uis) {
                ui.accessSynchronously(() -> {
                    if (!ui.isClosing()) {
                        ui.close();
                    }
                    session.removeUI(ui);
                });
            }
            SessionDestroyEvent event = new SessionDestroyEvent(this, session);
            for (SessionDestroyListener listener : this.sessionDestroyListeners) {
                try {
                    listener.sessionDestroy(event);
                }
                catch (Exception e) {
                    session.getErrorHandler().error(new ErrorEvent(e));
                }
            }
            session.setState(VaadinSessionState.CLOSED);
        });
    }

    public VaadinSession findVaadinSession(VaadinRequest request) throws SessionExpiredException {
        VaadinSession vaadinSession = this.findOrCreateVaadinSession(request);
        if (vaadinSession == null) {
            return null;
        }
        VaadinSession.setCurrent(vaadinSession);
        request.setAttribute(VaadinSession.class.getName(), vaadinSession);
        return vaadinSession;
    }

    private void setSessionLock(WrappedSession wrappedSession, Lock lock) {
        if (wrappedSession == null) {
            throw new IllegalArgumentException("Can't set a lock for a null session");
        }
        Object currentSessionLock = wrappedSession.getAttribute(this.getLockAttributeName());
        assert (currentSessionLock == null || currentSessionLock == lock) : "Changing the lock for a session is not allowed";
        wrappedSession.setAttribute(this.getLockAttributeName(), lock);
    }

    private String getLockAttributeName() {
        return this.getServiceName() + ".lock";
    }

    protected Lock getSessionLock(WrappedSession wrappedSession) {
        Object lock = wrappedSession.getAttribute(this.getLockAttributeName());
        if (lock instanceof ReentrantLock) {
            return (ReentrantLock)lock;
        }
        if (lock == null) {
            return null;
        }
        throw new RuntimeException("Something else than a ReentrantLock was stored in the " + this.getLockAttributeName() + " in the session");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected Lock lockSession(WrappedSession wrappedSession) {
        Lock lock = this.getSessionLock(wrappedSession);
        if (lock == null) {
            Class<VaadinService> clazz = VaadinService.class;
            // MONITORENTER : com.vaadin.flow.server.VaadinService.class
            lock = this.getSessionLock(wrappedSession);
            if (lock == null) {
                lock = new ReentrantLock();
                this.setSessionLock(wrappedSession, lock);
            }
            // MONITOREXIT : clazz
        }
        lock.lock();
        try {
            wrappedSession.getAttribute(this.getLockAttributeName());
            return lock;
        }
        catch (IllegalStateException e) {
            lock.unlock();
            throw e;
        }
    }

    protected void unlockSession(WrappedSession wrappedSession, Lock lock) {
        assert (((ReentrantLock)lock).isHeldByCurrentThread()) : "Trying to unlock the session but it has not been locked by this thread";
        lock.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VaadinSession findOrCreateVaadinSession(VaadinRequest request) throws SessionExpiredException {
        Lock lock;
        boolean requestCanCreateSession = this.requestCanCreateSession(request);
        WrappedSession wrappedSession = this.getWrappedSession(request, requestCanCreateSession);
        try {
            lock = this.lockSession(wrappedSession);
        }
        catch (IllegalStateException e) {
            throw new SessionExpiredException();
        }
        try {
            VaadinSession vaadinSession = this.doFindOrCreateVaadinSession(request, requestCanCreateSession);
            return vaadinSession;
        }
        finally {
            this.unlockSession(wrappedSession, lock);
        }
    }

    private VaadinSession doFindOrCreateVaadinSession(VaadinRequest request, boolean requestCanCreateSession) throws SessionExpiredException {
        assert (((ReentrantLock)this.getSessionLock(request.getWrappedSession())).isHeldByCurrentThread()) : "Session has not been locked by this thread";
        VaadinSession session = this.getExistingSession(request, requestCanCreateSession);
        if (session != null) {
            boolean restartApplication = VaadinService.hasParameter(request, "restartApplication");
            boolean closeApplication = VaadinService.hasParameter(request, "closeApplication");
            if (closeApplication) {
                this.closeSession(session, request.getWrappedSession(false));
                return null;
            }
            if (restartApplication) {
                this.closeSession(session, request.getWrappedSession(false));
                return this.createAndRegisterSession(request);
            }
            return session;
        }
        if (requestCanCreateSession) {
            return this.createAndRegisterSession(request);
        }
        throw new SessionExpiredException();
    }

    private static boolean hasParameter(VaadinRequest request, String parameterName) {
        return request.getParameter(parameterName) != null;
    }

    private VaadinSession createAndRegisterSession(VaadinRequest request) {
        assert (((ReentrantLock)this.getSessionLock(request.getWrappedSession())).isHeldByCurrentThread()) : "Session has not been locked by this thread";
        VaadinSession session = this.createVaadinSession(request);
        VaadinSession.setCurrent(session);
        this.storeSession(session, request.getWrappedSession());
        session.setBrowser(new WebBrowser(request));
        session.setConfiguration(this.getDeploymentConfiguration());
        if (this.getInstantiator().getI18NProvider() != null) {
            this.setLocale(request, session);
        }
        this.onVaadinSessionStarted(request, session);
        return session;
    }

    private void setLocale(VaadinRequest request, VaadinSession session) {
        I18NProvider provider = this.getInstantiator().getI18NProvider();
        List<Locale> providedLocales = provider.getProvidedLocales();
        if (providedLocales.size() == 1) {
            session.setLocale(providedLocales.get(0));
        } else {
            Optional<Locale> foundLocale = LocaleUtil.getExactLocaleMatch(request, providedLocales);
            if (!foundLocale.isPresent()) {
                foundLocale = LocaleUtil.getLocaleMatchByLanguage(request, providedLocales);
            }
            if (foundLocale.isPresent()) {
                session.setLocale(foundLocale.get());
            } else if (!providedLocales.isEmpty()) {
                session.setLocale(providedLocales.get(0));
            }
        }
    }

    protected VaadinSession createVaadinSession(VaadinRequest request) {
        return new VaadinSession(this);
    }

    private void onVaadinSessionStarted(VaadinRequest request, VaadinSession session) {
        SessionInitEvent event = new SessionInitEvent(this, session, request);
        for (SessionInitListener listener : this.sessionInitListeners) {
            try {
                listener.sessionInit(event);
            }
            catch (Exception e) {
                session.getErrorHandler().error(new ErrorEvent(e));
            }
        }
    }

    private void closeSession(VaadinSession vaadinSession, WrappedSession session) {
        if (vaadinSession == null) {
            return;
        }
        if (session != null) {
            this.removeSession(session);
        }
    }

    protected VaadinSession getExistingSession(VaadinRequest request, boolean allowSessionCreation) throws SessionExpiredException {
        WrappedSession session = this.getWrappedSession(request, allowSessionCreation);
        return this.loadSession(session);
    }

    private WrappedSession getWrappedSession(VaadinRequest request, boolean requestCanCreateSession) throws SessionExpiredException {
        WrappedSession session = request.getWrappedSession(requestCanCreateSession);
        if (session == null) {
            throw new SessionExpiredException();
        }
        return session;
    }

    protected abstract boolean requestCanCreateSession(VaadinRequest var1);

    public static VaadinService getCurrent() {
        return CurrentInstance.get(VaadinService.class);
    }

    public void setCurrentInstances(VaadinRequest request, VaadinResponse response) {
        VaadinService.setCurrent(this);
        CurrentInstance.set(VaadinRequest.class, request);
        CurrentInstance.set(VaadinResponse.class, response);
    }

    public static void setCurrent(VaadinService service) {
        CurrentInstance.set(VaadinService.class, service);
    }

    public static VaadinRequest getCurrentRequest() {
        return VaadinRequest.getCurrent();
    }

    public static VaadinResponse getCurrentResponse() {
        return VaadinResponse.getCurrent();
    }

    public abstract String getServiceName();

    public UI findUI(VaadinRequest request) {
        VaadinSession session = this.loadSession(request.getWrappedSession());
        String uiIdString = request.getParameter("v-uiId");
        UI ui = null;
        if (uiIdString != null && session != null) {
            int uiId = Integer.parseInt(uiIdString);
            ui = session.getUIById(uiId);
        }
        UI.setCurrent(ui);
        return ui;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reinitializeSession(VaadinRequest request) {
        WrappedSession oldSession = request.getWrappedSession();
        Set<String> attributeNames = oldSession.getAttributeNames();
        HashMap<String, Object> attrs = new HashMap<String, Object>(attributeNames.size() * 2);
        for (String name : attributeNames) {
            Object value = oldSession.getAttribute(name);
            if (value instanceof VaadinSession) {
                VaadinSession serviceSession = (VaadinSession)value;
                serviceSession.lock();
                try {
                    serviceSession.setAttribute(PRESERVE_UNBOUND_SESSION_ATTRIBUTE, Boolean.TRUE);
                }
                finally {
                    serviceSession.unlock();
                }
            }
            attrs.put(name, value);
        }
        oldSession.invalidate();
        WrappedSession newSession = request.getWrappedSession();
        for (Map.Entry entry : attrs.entrySet()) {
            String name = (String)entry.getKey();
            Object value = entry.getValue();
            newSession.setAttribute(name, value);
            if (!(value instanceof VaadinSession)) continue;
            VaadinSession serviceSession = (VaadinSession)value;
            VaadinService service = serviceSession.getService();
            service.setSessionLock(newSession, serviceSession.getLockInstance());
            service.storeSession(serviceSession, newSession);
            serviceSession.lock();
            try {
                serviceSession.setAttribute(PRESERVE_UNBOUND_SESSION_ATTRIBUTE, null);
            }
            finally {
                serviceSession.unlock();
            }
        }
    }

    public abstract String getMainDivId(VaadinSession var1, VaadinRequest var2);

    public void closeSession(VaadinSession session) {
        session.close();
    }

    void cleanupSession(VaadinSession session) {
        if (this.isSessionActive(session)) {
            this.closeInactiveUIs(session);
            this.removeClosedUIs(session);
        } else {
            if (session.getState() == VaadinSessionState.OPEN) {
                this.closeSession(session);
                if (session.getSession() != null) {
                    VaadinService.getLogger().debug("Closing inactive Vaadin session bound to HTTP session {}", (Object)session.getSession().getId());
                }
            }
            if (session.getSession() != null) {
                this.removeSession(session.getSession());
            }
            this.fireSessionDestroy(session);
        }
    }

    private void removeClosedUIs(VaadinSession session) {
        ArrayList<UI> uis = new ArrayList<UI>(session.getUIs());
        for (UI ui : uis) {
            if (!ui.isClosing()) continue;
            ui.accessSynchronously(() -> {
                VaadinService.getLogger().debug("Removing closed UI {}", (Object)ui.getUIId());
                session.removeUI(ui);
            });
        }
    }

    private void closeInactiveUIs(VaadinSession session) {
        String sessionId = session.getSession().getId();
        for (UI ui : session.getUIs()) {
            if (this.isUIActive(ui) || ui.isClosing()) continue;
            ui.accessSynchronously(() -> {
                VaadinService.getLogger().debug("Closing inactive UI #{} in session {}", (Object)ui.getUIId(), (Object)sessionId);
                ui.close();
                AbstractNavigationStateRenderer.purgeInactiveUIPreservedChainCache(ui);
            });
        }
    }

    private int getHeartbeatTimeout() {
        return (int)((double)this.getDeploymentConfiguration().getHeartbeatInterval() * 3.1);
    }

    private int getUidlRequestTimeout(VaadinSession session) {
        return this.getDeploymentConfiguration().isCloseIdleSessions() ? session.getSession().getMaxInactiveInterval() : -1;
    }

    public boolean isUIActive(UI ui) {
        if (ui.isClosing()) {
            return false;
        }
        Lock lockInstance = ui.getSession().getLockInstance();
        if (lockInstance instanceof ReentrantLock && ((ReentrantLock)lockInstance).hasQueuedThreads()) {
            return true;
        }
        long now = System.currentTimeMillis();
        int timeout = 1000 * this.getHeartbeatTimeout();
        return timeout < 0 || now - ui.getInternals().getLastHeartbeatTimestamp() < (long)timeout;
    }

    private boolean isSessionActive(VaadinSession session) {
        if (session.getState() != VaadinSessionState.OPEN || session.getSession() == null) {
            return false;
        }
        long now = System.currentTimeMillis();
        int timeout = 1000 * this.getUidlRequestTimeout(session);
        return timeout < 0 || now - session.getLastRequestTimestamp() < (long)timeout;
    }

    private static final Logger getLogger() {
        return LoggerFactory.getLogger((String)VaadinService.class.getName());
    }

    public void requestStart(VaadinRequest request, VaadinResponse response) {
        if (!this.initialized) {
            throw new IllegalStateException("Can not process requests before init() has been called");
        }
        this.setCurrentInstances(request, response);
        request.setAttribute(REQUEST_START_TIME_ATTRIBUTE, System.nanoTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestEnd(VaadinRequest request, VaadinResponse response, VaadinSession session) {
        block7: {
            try {
                if (session == null) break block7;
                assert (VaadinSession.getCurrent() == session);
                session.lock();
                try {
                    this.cleanupSession(session);
                    long duration = (System.nanoTime() - (Long)request.getAttribute(REQUEST_START_TIME_ATTRIBUTE)) / 1000000L;
                    session.setLastRequestDuration(duration);
                }
                finally {
                    session.unlock();
                }
            }
            finally {
                CurrentInstance.clearAll();
            }
        }
    }

    public Iterable<RequestHandler> getRequestHandlers() {
        return this.requestHandlers;
    }

    public Iterable<DependencyFilter> getDependencyFilters() {
        return this.dependencyFilters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRequest(VaadinRequest request, VaadinResponse response) throws ServiceException {
        this.requestStart(request, response);
        VaadinSession vaadinSession = null;
        try {
            vaadinSession = this.findVaadinSession(request);
            if (vaadinSession == null) {
                return;
            }
            for (RequestHandler handler : this.getRequestHandlers()) {
                if (!handler.handleRequest(vaadinSession, request, response)) continue;
                return;
            }
            response.sendError(HttpStatusCode.NOT_FOUND.getCode(), "Request was not handled by any registered handler.");
        }
        catch (SessionExpiredException e) {
            this.handleSessionExpired(request, response);
        }
        catch (Exception e) {
            this.handleExceptionDuringRequest(request, response, vaadinSession, e);
        }
        finally {
            this.requestEnd(request, response, vaadinSession);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleExceptionDuringRequest(VaadinRequest request, VaadinResponse response, VaadinSession vaadinSession, Exception t) throws ServiceException {
        block9: {
            if (vaadinSession != null) {
                vaadinSession.lock();
            }
            try {
                if (vaadinSession != null) {
                    vaadinSession.getErrorHandler().error(new ErrorEvent(t));
                }
                if (HandlerHelper.isRequestType(request, HandlerHelper.RequestType.UIDL)) {
                    SystemMessages ci = this.getSystemMessages(HandlerHelper.findLocale(vaadinSession, request), request);
                    try {
                        this.writeUncachedStringResponse(response, "application/json; charset=UTF-8", VaadinService.createCriticalNotificationJSON(ci.getInternalErrorCaption(), ci.getInternalErrorMessage(), null, ci.getInternalErrorURL()));
                    }
                    catch (IOException e) {
                        VaadinService.getLogger().warn("Failed to write critical notification response to the client", (Throwable)e);
                    }
                    break block9;
                }
                throw new ServiceException(t);
            }
            finally {
                if (vaadinSession != null) {
                    vaadinSession.unlock();
                }
            }
        }
    }

    public void writeStringResponse(VaadinResponse response, String contentType, String responseString) throws IOException {
        response.setContentType(contentType);
        OutputStream out = response.getOutputStream();
        PrintWriter outWriter = new PrintWriter(new BufferedWriter(new OutputStreamWriter(out, StandardCharsets.UTF_8)));
        outWriter.print(responseString);
        outWriter.close();
    }

    public void writeUncachedStringResponse(VaadinResponse response, String contentType, String responseString) throws IOException {
        response.setNoCacheHeaders();
        this.writeStringResponse(response, contentType, responseString);
    }

    protected void handleSessionExpired(VaadinRequest request, VaadinResponse response) throws ServiceException {
        for (RequestHandler handler : this.getRequestHandlers()) {
            if (!(handler instanceof SessionExpiredHandler)) continue;
            try {
                if (!((SessionExpiredHandler)handler).handleSessionExpired(request, response)) continue;
                return;
            }
            catch (IOException e) {
                throw new ServiceException("Handling of session expired failed", e);
            }
        }
        try {
            SystemMessages systemMessages = this.getSystemMessages(HandlerHelper.findLocale(null, request), request);
            String sessionExpiredURL = systemMessages.getSessionExpiredURL();
            if (sessionExpiredURL != null && response instanceof VaadinServletResponse) {
                ((VaadinServletResponse)response).sendRedirect(sessionExpiredURL);
            } else {
                response.setHeader("Cache-Control", "no-cache");
                response.setHeader("Content-Type", "text/plain");
                response.sendError(HttpStatusCode.FORBIDDEN.getCode(), "Session expired");
            }
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
    }

    public static String createCriticalNotificationJSON(String caption, String message, String details, String url) {
        return VaadinService.createCriticalNotificationJSON(caption, message, details, url, null);
    }

    public static String createCriticalNotificationJSON(String caption, String message, String details, String url, String querySelector) {
        try {
            JsonObject appError = Json.createObject();
            VaadinService.putValueOrJsonNull(appError, "caption", caption);
            VaadinService.putValueOrJsonNull(appError, "url", url);
            VaadinService.putValueOrJsonNull(appError, "message", message);
            VaadinService.putValueOrJsonNull(appError, "details", details);
            VaadinService.putValueOrJsonNull(appError, "querySelector", querySelector);
            JsonObject meta = Json.createObject();
            meta.put("appError", (JsonValue)appError);
            JsonObject json = Json.createObject();
            json.put("changes", (JsonValue)Json.createObject());
            json.put("resources", (JsonValue)Json.createObject());
            json.put("locales", (JsonValue)Json.createObject());
            json.put("meta", (JsonValue)meta);
            json.put("syncId", -1.0);
            return VaadinService.wrapJsonForClient(json);
        }
        catch (JsonException e) {
            VaadinService.getLogger().warn("Error creating critical notification JSON message", (Throwable)e);
            return VaadinService.wrapJsonForClient(Json.createObject());
        }
    }

    private static String wrapJsonForClient(JsonObject json) {
        return "for(;;);[" + JsonUtil.stringify((JsonValue)json) + "]";
    }

    public static String createSessionExpiredJSON(boolean async) {
        JsonObject json = Json.createObject();
        JsonObject meta = Json.createObject();
        json.put("meta", (JsonValue)meta);
        if (async) {
            meta.put("async", true);
        }
        meta.put("sessionExpired", true);
        return VaadinService.wrapJsonForClient(json);
    }

    public static String createUINotFoundJSON(boolean async) {
        return VaadinService.createSessionExpiredJSON(async);
    }

    private static void putValueOrJsonNull(JsonObject json, String key, String value) {
        if (value == null) {
            json.put(key, (JsonValue)Json.createNull());
        } else {
            json.put(key, value);
        }
    }

    public boolean ensurePushAvailable() {
        if (this.atmosphereAvailable) {
            return true;
        }
        if (!this.pushWarningEmitted) {
            this.pushWarningEmitted = true;
            VaadinService.getLogger().warn(ATMOSPHERE_MISSING_ERROR);
        }
        return false;
    }

    private static boolean checkAtmosphereSupport() {
        String rawVersion = AtmospherePushConnection.getAtmosphereVersion();
        if (rawVersion == null) {
            return false;
        }
        if (!"2.7.3.slf4jvaadin7".equals(rawVersion)) {
            VaadinService.getLogger().warn(INVALID_ATMOSPHERE_VERSION_WARNING, new Object[]{"2.7.3.slf4jvaadin7", rawVersion});
        }
        return true;
    }

    protected boolean isAtmosphereAvailable() {
        return this.atmosphereAvailable;
    }

    public static void verifyNoOtherSessionLocked(VaadinSession session) {
        if (VaadinService.isOtherSessionLocked(session)) {
            throw new IllegalStateException("Can't access session while another session is locked by the same thread. This restriction is intended to help avoid deadlocks.");
        }
    }

    public static boolean isOtherSessionLocked(VaadinSession session) {
        VaadinSession otherSession = VaadinSession.getCurrent();
        if (otherSession == null || otherSession == session) {
            return false;
        }
        return otherSession.hasLock();
    }

    public static boolean isCsrfTokenValid(UI ui, String requestToken) {
        String uiToken;
        return !ui.getSession().getService().getDeploymentConfiguration().isXsrfProtectionEnabled() || (uiToken = ui.getCsrfToken()) != null && MessageDigest.isEqual(uiToken.getBytes(StandardCharsets.UTF_8), requestToken.getBytes(StandardCharsets.UTF_8));
    }

    public Future<Void> accessSession(VaadinSession session, Command command) {
        FutureAccess future = new FutureAccess(session, command);
        session.getPendingAccessQueue().add(future);
        this.ensureAccessQueuePurged(session);
        return future;
    }

    public void ensureAccessQueuePurged(VaadinSession session) {
        try {
            if (session.getLockInstance().tryLock(0L, TimeUnit.SECONDS)) {
                session.unlock();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runPendingAccessTasks(VaadinSession session) {
        session.checkHasLock();
        if (session.getPendingAccessQueue().isEmpty()) {
            return;
        }
        Map<Class<?>, CurrentInstance> oldInstances = CurrentInstance.getInstances();
        try {
            FutureAccess pendingAccess;
            while ((pendingAccess = session.getPendingAccessQueue().poll()) != null) {
                if (pendingAccess.isCancelled()) continue;
                CurrentInstance.clearAll();
                CurrentInstance.setCurrent(session);
                pendingAccess.run();
                try {
                    pendingAccess.get();
                }
                catch (CancellationException cancellationException) {
                }
                catch (Exception exception) {
                    pendingAccess.handleError(exception);
                }
            }
        }
        finally {
            CurrentInstance.clearAll();
            CurrentInstance.restoreInstances(oldInstances);
        }
    }

    public Registration addServiceDestroyListener(ServiceDestroyListener listener) {
        return Registration.addAndRemove(this.serviceDestroyListeners, listener);
    }

    public void destroy() {
        ServiceDestroyEvent event = new ServiceDestroyEvent(this);
        this.serviceDestroyListeners.forEach(listener -> listener.serviceDestroy(event));
    }

    protected void setDefaultClassLoader() {
        this.setClassLoader(Thread.currentThread().getContextClassLoader());
    }

    protected void storeSession(VaadinSession session, WrappedSession wrappedSession) {
        assert (VaadinSession.hasLock(this, wrappedSession));
        this.writeToHttpSession(wrappedSession, session);
        session.refreshTransients(wrappedSession, this);
    }

    protected void writeToHttpSession(WrappedSession wrappedSession, VaadinSession session) {
        wrappedSession.setAttribute(this.getSessionAttributeName(), session);
    }

    protected VaadinSession loadSession(WrappedSession wrappedSession) {
        assert (VaadinSession.hasLock(this, wrappedSession));
        VaadinSession vaadinSession = this.readFromHttpSession(wrappedSession);
        if (vaadinSession == null) {
            return null;
        }
        vaadinSession.refreshTransients(wrappedSession, this);
        return vaadinSession;
    }

    protected VaadinSession readFromHttpSession(WrappedSession wrappedSession) {
        VaadinSession session = (VaadinSession)wrappedSession.getAttribute(this.getSessionAttributeName());
        return session;
    }

    public void removeSession(WrappedSession wrappedSession) {
        assert (VaadinSession.hasLock(this, wrappedSession));
        this.removeFromHttpSession(wrappedSession);
    }

    protected void removeFromHttpSession(WrappedSession wrappedSession) {
        VaadinSession vaadinSession = this.readFromHttpSession(wrappedSession);
        if (vaadinSession != null) {
            vaadinSession.sessionClosedExplicitly = true;
        }
        wrappedSession.removeAttribute(this.getSessionAttributeName());
    }

    protected String getSessionAttributeName() {
        return VaadinSession.class.getName() + "." + this.getServiceName();
    }

    public Router getRouter() {
        return this.router;
    }

    public void fireUIInitListeners(UI ui) {
        UIInitEvent initEvent = new UIInitEvent(ui, this);
        this.uiInitListeners.forEach(listener -> listener.uiInit(initEvent));
    }

    public abstract URL getStaticResource(String var1);

    public abstract URL getResource(String var1);

    public abstract InputStream getResourceAsStream(String var1);

    public boolean isResourceAvailable(String url) {
        return this.getResource(url) != null;
    }

    public abstract String resolveResource(String var1);

    protected abstract VaadinContext constructVaadinContext();

    public VaadinContext getContext() {
        if (this.vaadinContext == null) {
            this.vaadinContext = this.constructVaadinContext();
        }
        return this.vaadinContext;
    }

    private void runWithServiceContext(Runnable runnable) {
        VaadinService.setCurrent(this);
        try {
            runnable.run();
        }
        finally {
            VaadinService.setCurrent(null);
        }
    }

    public BootstrapInitialPredicate getBootstrapInitialPredicate() {
        if (this.bootstrapInitialPredicate == null) {
            this.bootstrapInitialPredicate = request -> this.getDeploymentConfiguration().isEagerServerLoad();
        }
        return this.bootstrapInitialPredicate;
    }

    public void setBootstrapInitialPredicate(BootstrapInitialPredicate bootstrapInitialPredicate) {
        this.bootstrapInitialPredicate = bootstrapInitialPredicate;
    }

    public BootstrapUrlPredicate getBootstrapUrlPredicate() {
        if (this.bootstrapUrlPredicate == null) {
            this.bootstrapUrlPredicate = request -> true;
        }
        return this.bootstrapUrlPredicate;
    }

    public void setBootstrapUrlPredicate(BootstrapUrlPredicate bootstrapUrlPredicate) {
        this.bootstrapUrlPredicate = bootstrapUrlPredicate;
    }

    public static String getCsrfTokenAttributeName() {
        return VaadinSession.class.getName() + ".csrfToken";
    }

    private void doSetClassLoader() {
        String classLoaderName;
        String string = classLoaderName = this.getDeploymentConfiguration() == null ? null : this.getDeploymentConfiguration().getClassLoaderName();
        if (classLoaderName != null) {
            try {
                Class<?> classLoaderClass = this.getClass().getClassLoader().loadClass(classLoaderName);
                Constructor<?> c = classLoaderClass.getConstructor(ClassLoader.class);
                this.setClassLoader((ClassLoader)c.newInstance(this.getClass().getClassLoader()));
            }
            catch (Exception e) {
                throw new RuntimeException("Could not find specified class loader: " + classLoaderName, e);
            }
        }
        if (this.getClassLoader() == null) {
            this.setDefaultClassLoader();
        }
    }
}

