/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.server.frontend.FallibleCommand;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskCopyLocalFrontendFiles
implements FallibleCommand {
    private final File flowResourcesFolder;
    private final File localResourcesFolder;

    TaskCopyLocalFrontendFiles(File flowResourcesFolder, File localResourcesFolder) {
        this.flowResourcesFolder = flowResourcesFolder;
        this.localResourcesFolder = localResourcesFolder;
    }

    @Override
    public void execute() {
        TaskCopyLocalFrontendFiles.createTargetFolder(this.flowResourcesFolder);
        if (this.localResourcesFolder != null && this.localResourcesFolder.isDirectory()) {
            TaskCopyLocalFrontendFiles.log().info("Copying project local frontend resources.");
            TaskCopyLocalFrontendFiles.copyLocalResources(this.localResourcesFolder, this.flowResourcesFolder);
            TaskCopyLocalFrontendFiles.log().info("Copying frontend directory completed.");
        } else {
            TaskCopyLocalFrontendFiles.log().debug("Found no local frontend resources for the project");
        }
    }

    static void copyLocalResources(File source, File target) {
        if (!source.isDirectory() || !target.isDirectory()) {
            return;
        }
        try {
            FileUtils.copyDirectory((File)source, (File)target);
            try (Stream<Path> fileStream = Files.walk(Paths.get(target.getPath(), new String[0]), new FileVisitOption[0]);){
                fileStream.filter(file -> !Files.isWritable(file)).forEach(filePath -> filePath.toFile().setWritable(true));
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(String.format("Failed to copy project frontend resources from '%s' to '%s'", source, target), e);
        }
    }

    static void createTargetFolder(File target) {
        try {
            FileUtils.forceMkdir((File)Objects.requireNonNull(target));
        }
        catch (IOException e) {
            throw new UncheckedIOException(String.format("Failed to create directory '%s'", target), e);
        }
    }

    private static Logger log() {
        return LoggerFactory.getLogger(TaskCopyLocalFrontendFiles.class);
    }
}

