/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal;

import com.vaadin.flow.server.VaadinRequest;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Optional;

public final class LocaleUtil {
    private LocaleUtil() {
    }

    public static Optional<Locale> getExactLocaleMatch(VaadinRequest request, List<Locale> providedLocales) {
        Locale foundLocale = null;
        Enumeration<Locale> locales = request.getLocales();
        while (locales.hasMoreElements()) {
            Locale locale = locales.nextElement();
            if (!providedLocales.contains(locale)) continue;
            foundLocale = locale;
            break;
        }
        return Optional.ofNullable(foundLocale);
    }

    public static Optional<Locale> getLocaleMatchByLanguage(VaadinRequest request, List<Locale> providedLocales) {
        Locale foundLocale = null;
        Enumeration<Locale> locales = request.getLocales();
        while (locales.hasMoreElements()) {
            Locale locale = locales.nextElement();
            Optional<Locale> matching = providedLocales.stream().filter(providedLocale -> providedLocale.getLanguage().equals(locale.getLanguage())).findFirst();
            if (!matching.isPresent()) continue;
            foundLocale = matching.get();
            break;
        }
        return Optional.ofNullable(foundLocale);
    }
}

