/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.polymertemplate;

import com.vaadin.flow.component.dependency.HtmlImport;
import com.vaadin.flow.component.polymertemplate.JsoupUtils;
import com.vaadin.flow.component.polymertemplate.PolymerTemplate;
import com.vaadin.flow.component.polymertemplate.TemplateParser;
import com.vaadin.flow.internal.AnnotationReader;
import com.vaadin.flow.internal.ReflectionCache;
import com.vaadin.flow.server.DependencyFilter;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.startup.FakeBrowser;
import com.vaadin.flow.shared.ui.Dependency;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultTemplateParser
implements TemplateParser {
    private static final ReflectionCache<PolymerTemplate<?>, AtomicBoolean> LOG_CACHE = new ReflectionCache(clazz -> new AtomicBoolean());
    private static final TemplateParser INSTANCE = new DefaultTemplateParser();

    private DefaultTemplateParser() {
    }

    public static TemplateParser getInstance() {
        return INSTANCE;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public TemplateParser.TemplateData getTemplateContent(Class<? extends PolymerTemplate<?>> clazz, String tag, VaadinService service) {
        boolean logEnabled = LOG_CACHE.get(clazz).compareAndSet(false, true);
        FakeBrowser browser = FakeBrowser.getEs6();
        List<Object> dependencies = AnnotationReader.getAnnotationsFor(clazz, HtmlImport.class).stream().map(htmlImport -> new Dependency(Dependency.Type.HTML_IMPORT, htmlImport.value(), htmlImport.loadMode())).collect(Collectors.toList());
        if (!dependencies.isEmpty()) {
            throw new UnsupportedOperationException("@HtmlImport annotations, Bower and compatibility mode are no longer supported by Flow since version 2.11. Please use npm/pnpm package managers and @NpmPackage/@jsmodule annotations. Detected usage in class: " + clazz.getName());
        }
        DependencyFilter.FilterContext filterContext = new DependencyFilter.FilterContext(service, browser);
        for (DependencyFilter filter : service.getDependencyFilters()) {
            dependencies = filter.filter(new ArrayList<Dependency>(dependencies), filterContext);
        }
        Iterator<DependencyFilter> iterator = dependencies.iterator();
        while (true) {
            if (!iterator.hasNext()) {
                throw new IllegalStateException(String.format("Couldn't find the definition of the element with tag '%s' in any template file declared using @'%s' annotations. Check the availability of the template files in your WAR file or provide alternative implementation of the method getTemplateContent() which should return an element representing the content of the template file", tag, HtmlImport.class.getSimpleName()));
            }
            Dependency dependency = (Dependency)((Object)iterator.next());
            if (dependency.getType() != Dependency.Type.HTML_IMPORT) continue;
            String url = dependency.getUrl();
            try {
                InputStream content = service.getResourceAsStream(url, browser, null);
                Throwable throwable = null;
                try {
                    if (content == null) {
                        throw new IllegalStateException(String.format("Can't find resource '%s' via the servlet context", url));
                    }
                    Element templateElement = DefaultTemplateParser.parseHtmlImport(content, url, tag);
                    if (logEnabled && templateElement != null) {
                        this.getLogger().debug("Found a template file containing template definition for the tag '{}' by the path '{}'", (Object)tag, (Object)url);
                    }
                    if (templateElement == null) continue;
                    TemplateParser.TemplateData templateData = new TemplateParser.TemplateData(url, templateElement);
                    return templateData;
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (content == null) continue;
                    if (throwable != null) {
                        try {
                            content.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        continue;
                    }
                    content.close();
                }
            }
            catch (IOException exception) {
                if (!logEnabled) continue;
                this.getLogger().warn("Couldn't close template input stream", (Throwable)exception);
                continue;
            }
            break;
        }
    }

    private static Element parseHtmlImport(InputStream content, String path, String tag) {
        assert (content != null);
        try {
            Document parsedDocument = Jsoup.parse((InputStream)content, (String)StandardCharsets.UTF_8.name(), (String)"");
            Optional<Element> optionalDomModule = JsoupUtils.getDomModule((Element)parsedDocument, tag);
            if (!optionalDomModule.isPresent()) {
                return null;
            }
            Element domModule = optionalDomModule.get();
            JsoupUtils.removeCommentsRecursively((Node)domModule);
            return domModule;
        }
        catch (IOException exception) {
            throw new RuntimeException(String.format("Can't parse the template declared using '%s' path", path), exception);
        }
    }

    private Logger getLogger() {
        return LoggerFactory.getLogger((String)DefaultTemplateParser.class.getName());
    }
}

