/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal;

import elemental.json.Json;
import elemental.json.JsonArray;
import elemental.json.JsonNumber;
import elemental.json.JsonObject;
import elemental.json.JsonType;
import elemental.json.JsonValue;
import java.util.AbstractList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.DoubleStream;
import java.util.stream.Stream;

public final class JsonUtils {
    private static final Set<Collector.Characteristics> arrayCollectorCharacteristics = Collections.unmodifiableSet(EnumSet.of(Collector.Characteristics.IDENTITY_FINISH));

    private JsonUtils() {
    }

    public static boolean jsonEquals(JsonValue a, JsonValue b) {
        assert (a != null);
        assert (b != null);
        if (a == b) {
            return true;
        }
        JsonType type = a.getType();
        if (type != b.getType()) {
            return false;
        }
        switch (type) {
            case NULL: {
                return true;
            }
            case BOOLEAN: {
                return a.asBoolean() == b.asBoolean();
            }
            case NUMBER: {
                return Double.doubleToRawLongBits(a.asNumber()) == Double.doubleToRawLongBits(b.asNumber());
            }
            case STRING: {
                return a.asString().equals(b.asString());
            }
            case OBJECT: {
                return JsonUtils.jsonObjectEquals((JsonObject)a, (JsonObject)b);
            }
            case ARRAY: {
                return JsonUtils.jsonArrayEquals((JsonArray)a, (JsonArray)b);
            }
        }
        throw new IllegalArgumentException("Unsupported JsonType: " + type);
    }

    private static boolean jsonObjectEquals(JsonObject a, JsonObject b) {
        assert (a != null);
        assert (b != null);
        if (a == b) {
            return true;
        }
        String[] keys = a.keys();
        if (keys.length != b.keys().length) {
            return false;
        }
        for (String key : keys) {
            JsonValue value = b.get(key);
            if (value != null && JsonUtils.jsonEquals(a.get(key), value)) continue;
            return false;
        }
        return true;
    }

    private static boolean jsonArrayEquals(JsonArray a, JsonArray b) {
        assert (a != null);
        assert (b != null);
        if (a == b) {
            return true;
        }
        if (a.length() != b.length()) {
            return false;
        }
        for (int i = 0; i < a.length(); ++i) {
            if (JsonUtils.jsonEquals(a.get(i), b.get(i))) continue;
            return false;
        }
        return true;
    }

    public static <T extends JsonValue> Stream<T> stream(final JsonArray array) {
        if (array == null) {
            return Stream.empty();
        }
        return new AbstractList<T>(){

            @Override
            public T get(int index) {
                return array.get(index);
            }

            @Override
            public int size() {
                return array.length();
            }
        }.stream();
    }

    public static Stream<JsonObject> objectStream(JsonArray array) {
        return JsonUtils.stream(array);
    }

    public static DoubleStream numberStream(JsonArray array) {
        return JsonUtils.stream(array).mapToDouble(JsonNumber::getNumber);
    }

    public static Collector<JsonValue, JsonArray, JsonArray> asArray() {
        return new JsonArrayCollector();
    }

    public static JsonArray createArray(JsonValue ... values) {
        return Stream.of(values).collect(JsonUtils.asArray());
    }

    public static <T> JsonObject createObject(Map<String, T> map, Function<T, JsonValue> itemToJson) {
        JsonObject object = Json.createObject();
        map.forEach((key, value) -> object.put(key, (JsonValue)itemToJson.apply(value)));
        return object;
    }

    private static final class JsonArrayCollector
    implements Collector<JsonValue, JsonArray, JsonArray> {
        private JsonArrayCollector() {
        }

        @Override
        public Supplier<JsonArray> supplier() {
            return Json::createArray;
        }

        @Override
        public BiConsumer<JsonArray, JsonValue> accumulator() {
            return (array, value) -> array.set(array.length(), value);
        }

        @Override
        public BinaryOperator<JsonArray> combiner() {
            return (left, right) -> {
                for (int i = 0; i < right.length(); ++i) {
                    left.set(left.length(), right.get(i));
                }
                return left;
            };
        }

        @Override
        public Function<JsonArray, JsonArray> finisher() {
            return Function.identity();
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return arrayCollectorCharacteristics;
        }
    }
}

