/**
 * NOTICE: this is an auto-generated file
 *
 * This file has been generated by the `flow:prepare-frontend` maven goal.
 * This file will be overwritten on every run. Any custom changes should be made to webpack.config.js
 */
const fs = require('fs');
const CopyWebpackPlugin = require('copy-webpack-plugin');
const CompressionPlugin = require('compression-webpack-plugin');
const ExtraWatchWebpackPlugin = require('extra-watch-webpack-plugin');
const TerserPlugin = require("terser-webpack-plugin");

// Flow plugins
const StatsPlugin = require('@vaadin/stats-plugin');
const ThemeLiveReloadPlugin = require('@vaadin/theme-live-reload-plugin');
const { ApplicationThemePlugin, processThemeResources, extractThemeName, findParentThemes } = require('@vaadin/application-theme-plugin');

const path = require('path');
const baseDir = path.resolve(__dirname);
// the folder of app resources (main.js and flow templates)

// this matches /themes/my-theme/ and is used to check css url handling and file path build.
const themePartRegex = /(\\|\/)themes\1[\s\S]*?\1/;

const frontendFolder = '[to-be-generated-by-flow]';

const fileNameOfTheFlowGeneratedMainEntryPoint = '[to-be-generated-by-flow]';
const mavenOutputFolderForFlowBundledFiles = '[to-be-generated-by-flow]';

const devmodeGizmoJS = '[to-be-generated-by-flow]';

// public path for resources, must match Flow VAADIN_BUILD
const build = 'build';
// public path for resources, must match the request used in flow to get the /build/stats.json file
const config = 'config';
// folder for outputting index.js bundle, etc.
const buildFolder = `${mavenOutputFolderForFlowBundledFiles}/${build}`;
// folder for outputting stats.json
const confFolder = `${mavenOutputFolderForFlowBundledFiles}/${config}`;
// file which is used by flow to read templates for server `@Id` binding
const statsFile = `${confFolder}/stats.json`;

// Folders in the project which can contain static assets.
const projectStaticAssetsFolders = [
  path.resolve(__dirname, 'src', 'main', 'resources', 'META-INF', 'resources'),
  path.resolve(__dirname, 'src', 'main', 'resources', 'static'),
  frontendFolder
];

const projectStaticAssetsOutputFolder = '[to-be-generated-by-flow]';

// Folders in the project which can contain application themes
const themeProjectFolders = projectStaticAssetsFolders.map((folder) =>
  path.resolve(folder, 'themes')
);


// Target flow-fronted auto generated to be the actual target folder
const flowFrontendFolder = '[to-be-generated-by-flow]';

// make sure that build folder exists before outputting anything
const { mkdirp } = require('mkdirp');

const devMode = process.argv.find(v => v.indexOf('webpack-dev-server') >= 0);

!devMode && mkdirp(buildFolder);
mkdirp(confFolder);

let stats;

const transpile = !devMode || process.argv.find(v => v.indexOf('--transpile-es5') >= 0);

// Open a connection with the Java dev-mode handler in order to finish
// webpack-dev-mode when it exits or crashes.
const watchDogPort = devMode && process.env.watchDogPort;
let client;
if (watchDogPort) {
  const runWatchDog = () => {
    client = new require('net').Socket();
    client.setEncoding('utf8');
    client.on('error', function () {
      console.log("Watchdog connection error. Terminating webpack process...");
      client.destroy();
      process.exit(0);
    });
    client.on('close', function () {
      client.destroy();
      runWatchDog();
    });

    client.connect(watchDogPort, 'localhost');
  }

  runWatchDog();
}

const flowFrontendThemesFolder = path.resolve(flowFrontendFolder, 'themes');
const frontendGeneratedFolder = path.resolve(frontendFolder, "generated");
const themeOptions = {
  devMode: devMode,
  // The following matches ./frontend/generated/theme.js
  // and for theme in JAR that is copied to target/frontend/themes/
  themeResourceFolder: flowFrontendThemesFolder,
  themeProjectFolders: themeProjectFolders,
  projectStaticAssetsOutputFolder: projectStaticAssetsOutputFolder,
  frontendGeneratedFolder: frontendGeneratedFolder
};
let themeName = undefined;
let themeWatchFolders = undefined;
if (devMode) {
  // Current theme name is being extracted from theme.js located in
  // frontend/generated folder
  themeName = extractThemeName(frontendGeneratedFolder);
  const parentThemePaths = findParentThemes(themeName, themeOptions);
  const currentThemeFolders = [...projectStaticAssetsFolders
    .map((folder) => path.resolve(folder, "themes", themeName)),
    path.resolve(flowFrontendThemesFolder, themeName)];
  // Watch the components folders for component styles update in both
  // current theme and parent themes. Other folders or CSS files except
  // 'styles.css' should be referenced from `styles.css` anyway, so no need
  // to watch them.
  themeWatchFolders = [...currentThemeFolders, ...parentThemePaths]
    .map((themeFolder) => path.resolve(themeFolder, "components"));
}

const processThemeResourcesCallback = (logger) => processThemeResources(themeOptions, logger);

exports = {
  frontendFolder: `${frontendFolder}`,
  buildFolder: `${buildFolder}`,
  confFolder: `${confFolder}`
};

module.exports = {
  mode: 'production',
  context: frontendFolder,
  entry: {
    bundle: fileNameOfTheFlowGeneratedMainEntryPoint,
    ...(devMode && { gizmo: devmodeGizmoJS })
  },

  output: {
    filename: `${build}/vaadin-[name]-[contenthash].cache.js`,
    path: mavenOutputFolderForFlowBundledFiles,
    publicPath: 'VAADIN/',
  },

  resolve: {
    // Search for import 'x/y' inside these folders, used at least for importing an application theme
    modules: [
      'node_modules',
      flowFrontendFolder,
      ...projectStaticAssetsFolders,
    ],
    extensions: ['.ts', '.js'],
    alias: {
      Frontend: frontendFolder
    }
  },

  devServer: {
    hot: false, // disable HMR
    // webpack-dev-server serves ./ ,  webpack-generated,  and java webapp
    static: [mavenOutputFolderForFlowBundledFiles, path.resolve(__dirname, 'src', 'main', 'webapp')],
    devMiddleware: {
      publicPath: '/VAADIN'
    },
    setupMiddlewares: function(middlewares, devServer) {
      devServer.app.get(`/stats.json`, function(req, res) {
        res.json(stats);
      });
      devServer.app.get(`/stats.hash`, function(req, res) {
        res.json(stats.hash.toString());
      });
      devServer.app.get(`/assetsByChunkName`, function(req, res) {
        res.json(stats.assetsByChunkName);
      });
      devServer.app.get(`/stop`, function(req, res) {
        // eslint-disable-next-line no-console
        console.log("Stopped 'webpack-dev-server'");
        process.exit(0);
      });
      return middlewares;
    }
  },

  optimization: {
    minimizer: [new TerserPlugin({ extractComments: false })],
  },
  module: {
    rules: [
      ...(transpile ? [{
        test: /\.[jt]sx?$/,
        exclude: /node_modules/,
        use: [
          {
            loader: 'babel-loader',
            options: {
              plugins: [
                // workaround for Safari 10 scope issue (https://bugs.webkit.org/show_bug.cgi?id=159270)
                "@babel/plugin-transform-block-scoping",
              ],
              presets: [
                [
                  '@babel/preset-env',
                  {
                    useBuiltIns: false,
                    targets: {
                      browsers: 'last 1 Chrome major versions'
                    },
                    modules: false,
                  }
                ]
              ],
            }
          },
        ]
      }
      ] : []),
      {
        test: /\.tsx?$/,
        use: ['ts-loader']
      },
      {
        test: /\.css$/i,
        use: [
          {
            loader: 'css-loader',
            options: {
              url: {
                filter: (url, resourcePath) => {
                  // css urls may contain query string or fragment identifiers
                  // that should removed before resolving real path
                  // e.g
                  //  ../webfonts/fa-solid-900.svg#fontawesome
                  //  ../webfonts/fa-brands-400.eot?#iefix
                  if (url.includes('?'))
                    url = url.substring(0, url.indexOf('?'));
                  if (url.includes('#'))
                    url = url.substring(0, url.indexOf('#'));

                  // Only translate files from node_modules
                  const resolve = resourcePath.match(/(\\|\/)node_modules\1/)
                      && fs.existsSync(path.resolve(path.dirname(resourcePath), url));
                  const themeResource = resourcePath.match(themePartRegex) && url.match(/^themes\/[\s\S]*?\//);
                  return resolve || themeResource;
                }
              },
              esModule: false,
              // use theme-loader to also handle any imports in css files
              importLoaders: 1
            },
          },
          {
            // theme-loader will change any url starting with './' to start with 'VAADIN/static' instead
            // NOTE! this loader should be here so it's run before css-loader as loaders are applied Right-To-Left
            loader: '@vaadin/theme-loader',
            options: {
              devMode: devMode
            }
          }
        ],
      },
      {
        // File-loader only copies files used as imports in .js files or handled by css-loader
        test: /\.(png|gif|jpg|jpeg|svg|eot|woff|woff2|otf|ttf)$/,
        type: 'asset/resource',
        generator: {
          filename(pathData) {
            const resourcePath = pathData.filename;
            const prefix = 'static/';

            if (resourcePath.includes('node_modules')) {
              const match = /([\\/])node_modules\1(?!.*node_modules)(\S+)/.exec(resourcePath);
              if (match && match[2]) {
                return prefix + match[2].replace(/\\/g, '/');
              }
            }

            if (resourcePath.match(/(^|[\\/])frontend[\\/]/)) {
              const match = /(?:^|[\\/])frontend([\\/])(?!.*frontend)(\S+)/.exec(resourcePath);
              if (match && match[2]) {
                  return prefix + match[2].replace(/\\/g, "/");
              }
            }
            return prefix +'[path][name][ext]';
          }
        },
      },
    ]
  },
  performance: {
    maxEntrypointSize: 2097152, // 2MB
    maxAssetSize: 2097152 // 2MB
  },
  plugins: [
    // Generate compressed bundles when not devMode
    ...(devMode ? [] : [new CompressionPlugin()]),

    new ApplicationThemePlugin(themeOptions),

    ...(devMode && themeName ? [new ExtraWatchWebpackPlugin({
      files: [],
      dirs: themeWatchFolders
    }), new ThemeLiveReloadPlugin(processThemeResourcesCallback)] : []),

    new StatsPlugin({
      devMode: devMode,
      statsFile: statsFile,
      setResults: function (statsFile) {
        stats = statsFile;
      }
    }),

    // Generates the stats file for flow `@Id` binding.
    function (compiler) {
        compiler.hooks.done.tapAsync('FlowIdPlugin', (compilation, done) => {
          // trigger live reload via server
          if (client) {
            client.write('reload\n');
          }
          done();
        });
    },

    // Copy webcomponents polyfills. They are not bundled because they
    // have its own loader based on browser quirks.
    new CopyWebpackPlugin({
      patterns: [{
        from: `${baseDir}/node_modules/@webcomponents/webcomponentsjs`,
        to: `${build}/webcomponentsjs/`,
        globOptions: {
          ignore: ['*.md', '*.json']
        }
      }]
    }),
  ]
};
