/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server;

import com.vaadin.flow.di.Lookup;
import com.vaadin.flow.di.ResourceProvider;
import com.vaadin.flow.server.BootstrapHandler;
import com.vaadin.flow.server.PWA;
import com.vaadin.flow.server.PwaConfiguration;
import com.vaadin.flow.server.PwaIcon;
import com.vaadin.flow.server.VaadinServletContext;
import com.vaadin.flow.server.startup.ApplicationRouteRegistry;
import elemental.json.Json;
import elemental.json.JsonArray;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import javax.servlet.ServletContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PwaRegistry
implements Serializable {
    private static final String META_INF_RESOURCES = "/META-INF/resources";
    private static final String HEADLESS_PROPERTY = "java.awt.headless";
    private static final String APPLE_STARTUP_IMAGE = "apple-touch-startup-image";
    private static final String APPLE_IMAGE_MEDIA = "screen and (device-width: %dpx) and (device-height: %dpx) and (-webkit-device-pixel-ratio: %d) and (orientation: %s)";
    private static final String ORIENTATION_PORTRAIT = "portrait";
    private static final String ORIENTATION_LANDSCAPE = "landscape";
    public static final String WORKBOX_FOLDER = "VAADIN/static/server/workbox/";
    private static final String WORKBOX_CACHE_FORMAT = "{ url: '%s', revision: '%s' }";
    private String offlineHtml = "";
    private String manifestJson = "";
    private String serviceWorkerJs = "";
    private String installPrompt = "";
    private long offlineHash;
    private List<PwaIcon> icons = new ArrayList<PwaIcon>();
    private final PwaConfiguration pwaConfiguration;
    private URL baseImageUrl;
    private BufferedImage baseImage;

    private PwaRegistry(PWA pwa, ServletContext servletContext) throws IOException {
        if (System.getProperty(HEADLESS_PROPERTY) == null) {
            System.setProperty(HEADLESS_PROPERTY, Boolean.TRUE.toString());
        }
        this.pwaConfiguration = pwa == null ? new PwaConfiguration() : new PwaConfiguration(pwa, servletContext);
        this.initializeResources(servletContext);
    }

    BufferedImage getBaseImage() {
        if (this.baseImage == null && this.baseImageUrl != null) {
            try {
                this.baseImage = this.getBaseImage(this.baseImageUrl);
            }
            catch (IOException ex) {
                PwaRegistry.getLogger().error("Image is not found or can't be loaded: {}", (Object)this.baseImageUrl);
            }
            finally {
                this.baseImageUrl = null;
            }
        }
        return this.baseImage;
    }

    private void initializeResources(ServletContext servletContext) throws IOException {
        if (!this.pwaConfiguration.isEnabled()) {
            return;
        }
        long start = System.currentTimeMillis();
        URL logo = this.getResourceUrl(servletContext, this.pwaConfiguration.relIconPath());
        this.baseImageUrl = logo != null ? logo : BootstrapHandler.class.getResource("default-logo.png");
        URL offlinePage = this.getResourceUrl(servletContext, this.pwaConfiguration.relOfflinePath());
        this.baseImage = this.getBaseImage(logo);
        this.icons = this.initializeIcons(servletContext);
        this.offlineHtml = this.initializeOfflinePage(this.pwaConfiguration, offlinePage);
        this.offlineHash = this.offlineHtml.hashCode();
        this.manifestJson = this.initializeManifest().toJson();
        this.serviceWorkerJs = this.initializeServiceWorker(servletContext);
        this.installPrompt = this.initializeInstallPrompt(this.pwaConfiguration);
        PwaRegistry.getLogger().debug("{} initialization took {}ms", (Object)this.getClass().getSimpleName(), (Object)(System.currentTimeMillis() - start));
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(PwaRegistry.class);
    }

    private URL getResourceUrl(ServletContext context, String path) throws MalformedURLException {
        URL resourceUrl = context.getResource(path);
        if (resourceUrl == null) {
            String cpPath = path.startsWith("/") ? META_INF_RESOURCES + path : "/META-INF/resources/" + path;
            resourceUrl = PwaRegistry.class.getResource(cpPath);
        }
        return resourceUrl;
    }

    private List<PwaIcon> initializeIcons(ServletContext servletContext) {
        VaadinServletContext vaadinContext = new VaadinServletContext(servletContext);
        Optional<ResourceProvider> optionalResourceProvider = Optional.ofNullable(vaadinContext.getAttribute(Lookup.class)).map(lookup -> lookup.lookup(ResourceProvider.class));
        for (PwaIcon icon : PwaRegistry.getIconTemplates(this.pwaConfiguration.getIconPath())) {
            icon.setRegistry(this);
            String iconPath = "META-INF/VAADIN/webapp/pwa-icons/" + icon.getRelHref().substring(1);
            optionalResourceProvider.ifPresent(provider -> PwaRegistry.tryLoadGeneratedIcon(provider.getApplicationResource(vaadinContext, iconPath), icon, iconPath));
            if (!icon.isAvailable()) continue;
            this.icons.add(icon);
        }
        return this.icons;
    }

    private static void tryLoadGeneratedIcon(URL iconResource, PwaIcon icon, String iconPath) {
        if (iconResource != null) {
            try (InputStream data = iconResource.openStream();){
                icon.setImage(data);
                PwaRegistry.getLogger().trace("Loading generated PWA image from {}", (Object)iconPath);
            }
            catch (IOException ex) {
                PwaRegistry.getLogger().debug("Cannot load generated PWA image from {}. Icon will be regenerated at runtime.", (Object)iconPath, (Object)ex);
            }
        }
    }

    private JsonObject initializeManifest() {
        JsonObject manifestData = Json.createObject();
        manifestData.put("name", this.pwaConfiguration.getAppName());
        manifestData.put("short_name", this.pwaConfiguration.getShortName());
        if (!this.pwaConfiguration.getDescription().isEmpty()) {
            manifestData.put("description", this.pwaConfiguration.getDescription());
        }
        manifestData.put("display", this.pwaConfiguration.getDisplay());
        manifestData.put("background_color", this.pwaConfiguration.getBackgroundColor());
        manifestData.put("theme_color", this.pwaConfiguration.getThemeColor());
        manifestData.put("start_url", this.pwaConfiguration.getStartUrl());
        manifestData.put("scope", this.pwaConfiguration.getRootUrl());
        JsonArray iconList = Json.createArray();
        int iconIndex = 0;
        for (PwaIcon icon : this.getManifestIcons()) {
            JsonObject iconData = Json.createObject();
            iconData.put("src", icon.getHref());
            iconData.put("sizes", icon.getSizes());
            iconData.put("type", icon.getType());
            iconList.set(iconIndex++, (JsonValue)iconData);
        }
        manifestData.put("icons", (JsonValue)iconList);
        return manifestData;
    }

    private String initializeServiceWorker(ServletContext servletContext) {
        StringBuilder stringBuilder = new StringBuilder();
        List filesToCahe = this.getIcons().stream().filter(PwaIcon::shouldBeCached).map(PwaIcon::getCacheFormat).collect(Collectors.toList());
        filesToCahe.add(this.offlinePageCache());
        filesToCahe.add(this.manifestCache());
        for (String resource : this.pwaConfiguration.getOfflineResources()) {
            filesToCahe.add(String.format(WORKBOX_CACHE_FORMAT, resource.replaceAll("'", ""), servletContext.hashCode()));
        }
        String workBoxAbsolutePath = servletContext.getContextPath() + "/" + WORKBOX_FOLDER;
        stringBuilder.append("importScripts('").append(workBoxAbsolutePath).append("workbox-sw.js").append("');\n\n");
        stringBuilder.append("workbox.setConfig({\n").append("  modulePathPrefix: '").append(workBoxAbsolutePath).append("'\n").append("});\n");
        stringBuilder.append("workbox.precaching.precacheAndRoute([\n");
        stringBuilder.append(String.join((CharSequence)",\n", filesToCahe));
        stringBuilder.append("\n]);\n");
        stringBuilder.append("self.addEventListener('fetch', function(event) {\n").append("  var request = event.request;\n").append("  if (request.mode === 'navigate') {\n").append("    event.respondWith(\n      fetch(request)\n").append("        .catch(function() {\n").append(String.format("          return caches.match('%s');%n", this.getPwaConfiguration().getOfflinePath())).append("        })\n    );\n  }\n });");
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PwaRegistry getInstance(ServletContext servletContext) {
        Object attribute;
        assert (servletContext != null);
        ServletContext servletContext2 = servletContext;
        synchronized (servletContext2) {
            attribute = servletContext.getAttribute(PwaRegistry.class.getName());
            if (attribute == null) {
                ApplicationRouteRegistry reg = ApplicationRouteRegistry.getInstance(new VaadinServletContext(servletContext));
                PWA pwa = reg.getPwaConfigurationClass() != null ? reg.getPwaConfigurationClass().getAnnotation(PWA.class) : null;
                try {
                    attribute = new PwaRegistry(pwa, servletContext);
                    servletContext.setAttribute(PwaRegistry.class.getName(), attribute);
                }
                catch (IOException ioe) {
                    throw new UncheckedIOException("Failed to initialize the PWA registry", ioe);
                }
            }
        }
        if (attribute instanceof PwaRegistry) {
            return (PwaRegistry)attribute;
        }
        throw new IllegalStateException("Unknown servlet context attribute value: " + attribute);
    }

    private String initializeOfflinePage(PwaConfiguration config, URL resource) throws IOException {
        List iconList = this.getIcons().stream().filter(PwaIcon::shouldBeCached).collect(Collectors.toList());
        String iconHead = iconList.stream().map(icon -> icon.asElement().toString()).collect(Collectors.joining("\n"));
        PwaIcon largest = iconList.stream().min((icon1, icon2) -> icon2.getWidth() - icon1.getWidth()).orElse(null);
        URLConnection connection = resource != null ? resource.openConnection() : BootstrapHandler.class.getResource("default-offline-page.html").openConnection();
        String offlinePage = this.getOfflinePageFromContext(connection);
        return offlinePage.replace("%%%PROJECT_NAME%%%", config.getAppName()).replace("%%%BACKGROUND_COLOR%%%", config.getBackgroundColor()).replace("%%%LOGO_PATH%%%", largest != null ? this.pwaConfiguration.getRootUrl() + largest.getHref() : "").replace("%%%META_ICONS%%%", iconHead);
    }

    private String initializeInstallPrompt(PwaConfiguration pwaConfiguration) {
        PwaIcon largest = this.getIcons().stream().filter(PwaIcon::shouldBeCached).min((icon1, icon2) -> icon2.getWidth() - icon1.getWidth()).orElse(null);
        return BootstrapHandler.readResource("default-pwa-prompt.html").replace("%%%INSTALL%%%", "Install").replace("%%%LOGO_PATH%%%", largest == null ? "" : pwaConfiguration.getRootUrl() + largest.getHref()).replace("%%%PROJECT_NAME%%%", pwaConfiguration.getAppName());
    }

    /*
     * Exception decompiling
     */
    private String getOfflinePageFromContext(URLConnection connection) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private BufferedImage getBaseImage(URL logo) throws IOException {
        URLConnection logoResource = logo != null ? logo.openConnection() : BootstrapHandler.class.getResource("default-logo.png").openConnection();
        return ImageIO.read(logoResource.getInputStream());
    }

    public String getOfflineHtml() {
        return this.offlineHtml;
    }

    public String getManifestJson() {
        return this.manifestJson;
    }

    public String getServiceWorkerJs() {
        return this.serviceWorkerJs;
    }

    public String offlinePageCache() {
        return String.format(WORKBOX_CACHE_FORMAT, this.pwaConfiguration.getOfflinePath(), this.offlineHash);
    }

    private String manifestCache() {
        return String.format(WORKBOX_CACHE_FORMAT, this.pwaConfiguration.getManifestPath(), this.manifestJson.hashCode());
    }

    public String getInstallPrompt() {
        return this.installPrompt;
    }

    public List<PwaIcon> getHeaderIcons() {
        return this.getIcons(PwaIcon.Domain.HEADER);
    }

    public List<PwaIcon> getManifestIcons() {
        return this.getIcons(PwaIcon.Domain.MANIFEST);
    }

    public List<PwaIcon> getIcons() {
        return new ArrayList<PwaIcon>(this.icons);
    }

    private List<PwaIcon> getIcons(PwaIcon.Domain domain) {
        return this.icons.stream().filter(icon -> icon.getDomain().equals((Object)domain)).collect(Collectors.toList());
    }

    public PwaConfiguration getPwaConfiguration() {
        return this.pwaConfiguration;
    }

    public static List<PwaIcon> getIconTemplates(String baseName) {
        ArrayList<PwaIcon> icons = new ArrayList<PwaIcon>();
        icons.add(new PwaIcon(144, 144, baseName, PwaIcon.Domain.MANIFEST, true));
        icons.add(new PwaIcon(192, 192, baseName, PwaIcon.Domain.MANIFEST, true));
        icons.add(new PwaIcon(512, 512, baseName, PwaIcon.Domain.MANIFEST, true));
        icons.add(new PwaIcon(16, 16, baseName, PwaIcon.Domain.HEADER, true, "shortcut icon", ""));
        icons.add(new PwaIcon(32, 32, baseName));
        icons.add(new PwaIcon(96, 96, baseName));
        icons.add(new PwaIcon(180, 180, baseName, PwaIcon.Domain.HEADER, false, "apple-touch-icon", ""));
        icons.add(new PwaIcon(2048, 2732, baseName, PwaIcon.Domain.HEADER, false, APPLE_STARTUP_IMAGE, String.format(APPLE_IMAGE_MEDIA, 1024, 1366, 2, ORIENTATION_PORTRAIT)));
        icons.add(new PwaIcon(2732, 2048, baseName, PwaIcon.Domain.HEADER, false, APPLE_STARTUP_IMAGE, String.format(APPLE_IMAGE_MEDIA, 1024, 1366, 2, ORIENTATION_LANDSCAPE)));
        icons.add(new PwaIcon(1668, 2388, baseName, PwaIcon.Domain.HEADER, false, APPLE_STARTUP_IMAGE, String.format(APPLE_IMAGE_MEDIA, 834, 1194, 2, ORIENTATION_PORTRAIT)));
        icons.add(new PwaIcon(2388, 1668, baseName, PwaIcon.Domain.HEADER, false, APPLE_STARTUP_IMAGE, String.format(APPLE_IMAGE_MEDIA, 834, 1194, 2, ORIENTATION_LANDSCAPE)));
        icons.add(new PwaIcon(1668, 2224, baseName, PwaIcon.Domain.HEADER, false, APPLE_STARTUP_IMAGE, String.format(APPLE_IMAGE_MEDIA, 834, 1112, 2, ORIENTATION_PORTRAIT)));
        icons.add(new PwaIcon(2224, 1668, baseName, PwaIcon.Domain.HEADER, false, APPLE_STARTUP_IMAGE, String.format(APPLE_IMAGE_MEDIA, 834, 1112, 2, ORIENTATION_LANDSCAPE)));
        icons.add(new PwaIcon(1620, 2160, baseName, PwaIcon.Domain.HEADER, false, APPLE_STARTUP_IMAGE, String.format(APPLE_IMAGE_MEDIA, 768, 1024, 2, ORIENTATION_PORTRAIT)));
        icons.add(new PwaIcon(2160, 1620, baseName, PwaIcon.Domain.HEADER, false, APPLE_STARTUP_IMAGE, String.format(APPLE_IMAGE_MEDIA, 768, 1024, 2, ORIENTATION_LANDSCAPE)));
        icons.add(new PwaIcon(1536, 2048, baseName, PwaIcon.Domain.HEADER, false, APPLE_STARTUP_IMAGE, String.format(APPLE_IMAGE_MEDIA, 768, 1024, 2, ORIENTATION_PORTRAIT)));
        icons.add(new PwaIcon(2048, 1536, baseName, PwaIcon.Domain.HEADER, false, APPLE_STARTUP_IMAGE, String.format(APPLE_IMAGE_MEDIA, 768, 1024, 2, ORIENTATION_LANDSCAPE)));
        icons.add(new PwaIcon(1284, 2778, baseName, PwaIcon.Domain.HEADER, false, APPLE_STARTUP_IMAGE, String.format(APPLE_IMAGE_MEDIA, 428, 926, 3, ORIENTATION_PORTRAIT)));
        icons.add(new PwaIcon(2778, 1284, baseName, PwaIcon.Domain.HEADER, false, APPLE_STARTUP_IMAGE, String.format(APPLE_IMAGE_MEDIA, 428, 926, 3, ORIENTATION_LANDSCAPE)));
        icons.add(new PwaIcon(1170, 2532, baseName, PwaIcon.Domain.HEADER, false, APPLE_STARTUP_IMAGE, String.format(APPLE_IMAGE_MEDIA, 390, 844, 3, ORIENTATION_PORTRAIT)));
        icons.add(new PwaIcon(2532, 1170, baseName, PwaIcon.Domain.HEADER, false, APPLE_STARTUP_IMAGE, String.format(APPLE_IMAGE_MEDIA, 390, 844, 3, ORIENTATION_LANDSCAPE)));
        icons.add(new PwaIcon(1125, 2436, baseName, PwaIcon.Domain.HEADER, false, APPLE_STARTUP_IMAGE, String.format(APPLE_IMAGE_MEDIA, 375, 812, 3, ORIENTATION_PORTRAIT)));
        icons.add(new PwaIcon(2436, 1125, baseName, PwaIcon.Domain.HEADER, false, APPLE_STARTUP_IMAGE, String.format(APPLE_IMAGE_MEDIA, 375, 812, 3, ORIENTATION_LANDSCAPE)));
        icons.add(new PwaIcon(1242, 2688, baseName, PwaIcon.Domain.HEADER, false, APPLE_STARTUP_IMAGE, String.format(APPLE_IMAGE_MEDIA, 414, 896, 3, ORIENTATION_PORTRAIT)));
        icons.add(new PwaIcon(2688, 1242, baseName, PwaIcon.Domain.HEADER, false, APPLE_STARTUP_IMAGE, String.format(APPLE_IMAGE_MEDIA, 414, 896, 3, ORIENTATION_LANDSCAPE)));
        icons.add(new PwaIcon(828, 1792, baseName, PwaIcon.Domain.HEADER, false, APPLE_STARTUP_IMAGE, String.format(APPLE_IMAGE_MEDIA, 414, 896, 2, ORIENTATION_PORTRAIT)));
        icons.add(new PwaIcon(1792, 828, baseName, PwaIcon.Domain.HEADER, false, APPLE_STARTUP_IMAGE, String.format(APPLE_IMAGE_MEDIA, 414, 896, 2, ORIENTATION_LANDSCAPE)));
        icons.add(new PwaIcon(1242, 2208, baseName, PwaIcon.Domain.HEADER, false, APPLE_STARTUP_IMAGE, String.format(APPLE_IMAGE_MEDIA, 414, 736, 3, ORIENTATION_PORTRAIT)));
        icons.add(new PwaIcon(2208, 1242, baseName, PwaIcon.Domain.HEADER, false, APPLE_STARTUP_IMAGE, String.format(APPLE_IMAGE_MEDIA, 414, 736, 3, ORIENTATION_LANDSCAPE)));
        icons.add(new PwaIcon(750, 1334, baseName, PwaIcon.Domain.HEADER, false, APPLE_STARTUP_IMAGE, String.format(APPLE_IMAGE_MEDIA, 375, 667, 2, ORIENTATION_PORTRAIT)));
        icons.add(new PwaIcon(1334, 750, baseName, PwaIcon.Domain.HEADER, false, APPLE_STARTUP_IMAGE, String.format(APPLE_IMAGE_MEDIA, 375, 667, 2, ORIENTATION_LANDSCAPE)));
        icons.add(new PwaIcon(640, 1136, baseName, PwaIcon.Domain.HEADER, false, APPLE_STARTUP_IMAGE, String.format(APPLE_IMAGE_MEDIA, 320, 568, 2, ORIENTATION_PORTRAIT)));
        icons.add(new PwaIcon(1136, 640, baseName, PwaIcon.Domain.HEADER, false, APPLE_STARTUP_IMAGE, String.format(APPLE_IMAGE_MEDIA, 320, 568, 2, ORIENTATION_LANDSCAPE)));
        return icons;
    }
}

