/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.webcomponent;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.page.Push;
import com.vaadin.flow.component.webcomponent.WebComponentConfiguration;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.internal.AnnotationReader;
import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.nodefeature.ElementData;
import com.vaadin.flow.internal.nodefeature.TextNodeMap;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.osgi.OSGiAccess;
import com.vaadin.flow.server.webcomponent.EmbeddedApplicationAnnotations;
import com.vaadin.flow.server.webcomponent.OSGiWebComponentConfigurationRegistry;
import com.vaadin.flow.theme.Theme;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;

@EmbeddedApplicationAnnotations(value={Theme.class, Push.class})
public class WebComponentConfigurationRegistry
implements Serializable {
    private final ReentrantLock configurationLock = new ReentrantLock(true);
    private boolean configurationsSet = false;
    private HashMap<String, WebComponentConfiguration<? extends Component>> configurationMap = new HashMap();
    private HashMap<Class<? extends Annotation>, Annotation> embeddedAppAnnotations;
    private ArrayList<Element> bootstrapElements;

    protected WebComponentConfigurationRegistry() {
    }

    public Optional<WebComponentConfiguration<? extends Component>> getConfiguration(String tag) {
        this.lock();
        try {
            Optional<WebComponentConfiguration<? extends Component>> optional = Optional.ofNullable(this.configurationMap.get(tag));
            return optional;
        }
        finally {
            this.unlock();
        }
    }

    public <T extends Component> Set<WebComponentConfiguration<T>> getConfigurationsByComponentType(Class<T> componentClass) {
        this.lock();
        try {
            Set<WebComponentConfiguration<T>> set = Collections.unmodifiableSet(this.configurationMap.values().stream().filter(config -> componentClass.equals(config.getComponentClass())).map(b -> b).collect(Collectors.toSet()));
            return set;
        }
        finally {
            this.unlock();
        }
    }

    protected void updateRegistry(Set<WebComponentConfiguration<? extends Component>> configurations) {
        this.lock();
        try {
            this.updateConfiguration(configurations);
            this.configurationMap = new HashMap<String, WebComponentConfiguration>(configurations.stream().collect(Collectors.toMap(WebComponentConfiguration::getTag, config -> config)));
        }
        finally {
            this.unlock();
        }
    }

    public boolean setConfigurations(Set<WebComponentConfiguration<? extends Component>> configurations) {
        this.lock();
        try {
            if (this.configurationsSet) {
                boolean bl = false;
                return bl;
            }
            this.configurationsSet = true;
            this.updateRegistry(configurations);
            boolean bl = true;
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    public boolean hasConfigurations() {
        this.lock();
        try {
            boolean bl = this.configurationMap.size() > 0;
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    public <T extends Annotation> Optional<T> getEmbeddedApplicationAnnotation(Class<T> type) {
        this.lock();
        try {
            if (this.embeddedAppAnnotations == null) {
                Optional optional = Optional.empty();
                return optional;
            }
            Optional<T> optional = Optional.ofNullable(type.cast(this.embeddedAppAnnotations.get(type)));
            return optional;
        }
        finally {
            this.unlock();
        }
    }

    public Set<WebComponentConfiguration<? extends Component>> getConfigurations() {
        this.lock();
        try {
            Set<WebComponentConfiguration<? extends Component>> set = Collections.unmodifiableSet(new HashSet<WebComponentConfiguration<? extends Component>>(this.configurationMap.values()));
            return set;
        }
        finally {
            this.unlock();
        }
    }

    public void setShadowDomElements(List<Element> elements) {
        this.lock();
        try {
            this.bootstrapElements = new ArrayList<Element>(elements);
        }
        finally {
            this.unlock();
        }
    }

    public List<Element> getShadowDomElements() {
        this.lock();
        try {
            if (this.bootstrapElements != null) {
                List<Element> list = Collections.unmodifiableList(this.bootstrapElements.stream().map(WebComponentConfigurationRegistry::copyElementTree).collect(Collectors.toList()));
                return list;
            }
            List<Element> list = Collections.emptyList();
            return list;
        }
        finally {
            this.unlock();
        }
    }

    public static WebComponentConfigurationRegistry getInstance(VaadinContext context) {
        assert (context != null);
        WebComponentConfigurationRegistry attribute = context.getAttribute(WebComponentConfigurationRegistry.class, WebComponentConfigurationRegistry::createRegistry);
        if (attribute == null) {
            throw new IllegalStateException("Null WebComponentConfigurationRegistry obtained from VaadinContext of type " + context.getClass().getName());
        }
        return attribute;
    }

    private void updateConfiguration(Set<WebComponentConfiguration<? extends Component>> webComponentConfigurations) {
        this.assertLockHeld();
        Optional<Class[]> annotationTypes = AnnotationReader.getAnnotationValueFor(WebComponentConfigurationRegistry.class, EmbeddedApplicationAnnotations.class, EmbeddedApplicationAnnotations::value);
        HashMap map = new HashMap();
        webComponentConfigurations.forEach(config -> this.addEmbeddedApplicationAnnotation((WebComponentConfiguration<? extends Component>)config, (Class[])annotationTypes.get(), map));
        this.embeddedAppAnnotations = map;
    }

    private void addEmbeddedApplicationAnnotation(WebComponentConfiguration<? extends Component> configuration, Class<? extends Annotation>[] types, Map<Class<? extends Annotation>, Annotation> map) {
        for (Class<? extends Annotation> type : types) {
            Annotation annotation = map.get(type);
            Annotation configAnnotation = configuration.getExporterClass().getAnnotation(type);
            if (configAnnotation == null) continue;
            if (annotation != null && !annotation.equals(configAnnotation)) {
                throw new IllegalStateException(String.format("Different annotations of type '%s' are declared by the web component exporters: %s, %s", type.getName(), annotation.toString(), configAnnotation.toString()));
            }
            map.put(type, configAnnotation);
        }
    }

    private static WebComponentConfigurationRegistry createRegistry() {
        if (OSGiAccess.getInstance().getOsgiServletContext() == null) {
            return new WebComponentConfigurationRegistry();
        }
        Object attribute = OSGiAccess.getInstance().getOsgiServletContext().getAttribute(WebComponentConfigurationRegistry.class.getName());
        if (attribute instanceof OSGiWebComponentConfigurationRegistry) {
            return (WebComponentConfigurationRegistry)attribute;
        }
        return new OSGiWebComponentConfigurationRegistry();
    }

    private void lock() {
        this.configurationLock.lock();
    }

    private void unlock() {
        this.configurationLock.unlock();
    }

    private void assertLockHeld() {
        assert (this.configurationLock.isHeldByCurrentThread());
    }

    private static Element copyElementTree(Element rootElement) {
        if (rootElement.getNode().hasFeature(TextNodeMap.class)) {
            return Element.createText(rootElement.getText());
        }
        StateNode copyNode = new StateNode(rootElement.getNode());
        ElementData originalData = rootElement.getNode().getFeature(ElementData.class);
        ElementData copyData = copyNode.getFeature(ElementData.class);
        copyData.setTag(originalData.getTag());
        copyData.setPayload(originalData.getPayload());
        copyData.setVisible(originalData.isVisible());
        Element copyElement = Element.get(copyNode);
        rootElement.getAttributeNames().forEach(name -> copyElement.setAttribute((String)name, rootElement.getAttribute((String)name)));
        rootElement.getChildren().forEach(child -> {
            Element cfr_ignored_0 = (Element)copyElement.appendChild(WebComponentConfigurationRegistry.copyElementTree(child));
        });
        return copyElement;
    }
}

