/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class FallbackChunk
implements Serializable {
    private final Set<String> modules;
    private final Set<CssImportData> cssImports;

    public FallbackChunk(Collection<String> modules, Collection<CssImportData> css) {
        this.modules = new HashSet<String>(Objects.requireNonNull(modules));
        this.cssImports = new HashSet<CssImportData>(Objects.requireNonNull(css));
    }

    public Set<String> getModules() {
        return Collections.unmodifiableSet(this.modules);
    }

    public Set<CssImportData> getCssImports() {
        return Collections.unmodifiableSet(this.cssImports);
    }

    public static class CssImportData
    implements Serializable {
        private final String value;
        private final String id;
        private final String include;
        private final String themeFor;

        public CssImportData(String value, String id, String include, String themeFor) {
            this.value = Objects.requireNonNull(value);
            this.id = id;
            this.include = include;
            this.themeFor = themeFor;
        }

        public String getValue() {
            return this.value;
        }

        public String getId() {
            return this.id;
        }

        public String getInclude() {
            return this.include;
        }

        public String getThemeFor() {
            return this.themeFor;
        }

        public int hashCode() {
            return Objects.hash(this.value, this.id, this.include, this.themeFor);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj.getClass().equals(CssImportData.class)) {
                CssImportData that = (CssImportData)obj;
                return Objects.equals(this.value, that.value) && Objects.equals(this.id, that.id) && Objects.equals(this.include, that.include) && Objects.equals(this.themeFor, that.themeFor);
            }
            return false;
        }
    }
}

