/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server;

import com.vaadin.flow.router.InvalidLocationException;
import com.vaadin.flow.server.ErrorEvent;
import com.vaadin.flow.server.ErrorHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class DefaultErrorHandler
implements ErrorHandler {
    @Override
    public void error(ErrorEvent event) {
        Throwable throwable = DefaultErrorHandler.findRelevantThrowable(event.getThrowable());
        Marker marker = MarkerFactory.getMarker((String)"INVALID_LOCATION");
        if (throwable instanceof InvalidLocationException) {
            if (DefaultErrorHandler.getLogger().isWarnEnabled(marker)) {
                DefaultErrorHandler.getLogger().warn(marker, "", throwable);
            }
        } else {
            DefaultErrorHandler.getLogger().error("", throwable);
        }
    }

    public static Throwable findRelevantThrowable(Throwable t) {
        return t;
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger((String)DefaultErrorHandler.class.getName());
    }
}

