/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.internal.UIInternals;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.internal.ExecutionContext;
import com.vaadin.flow.internal.NodeOwner;
import com.vaadin.flow.internal.NullOwner;
import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.change.NodeChange;
import com.vaadin.flow.internal.nodefeature.NodeFeature;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class StateTree
implements NodeOwner {
    private Set<StateNode> dirtyNodes = new LinkedHashSet<StateNode>();
    private final Map<Integer, StateNode> idToNode = new HashMap<Integer, StateNode>();
    private int nextId = 1;
    private Set<StateNode> pendingExecutionNodes = new HashSet<StateNode>();
    private int nextBeforeClientResponseIndex = 1;
    private final StateNode rootNode;
    private final UIInternals uiInternals;
    private boolean isRootAttached = true;

    @SafeVarargs
    public StateTree(UIInternals uiInternals, Class<? extends NodeFeature> ... features) {
        this.uiInternals = uiInternals;
        this.rootNode = new RootNode((Class[])features);
    }

    public StateNode getRootNode() {
        return this.rootNode;
    }

    @Override
    public int register(StateNode node) {
        int nodeId;
        assert (node.getOwner() == this);
        int id = node.getId();
        if (id > 0 && !this.idToNode.containsKey(id)) {
            assert (id < this.nextId);
            nodeId = id;
        } else {
            nodeId = this.nextId++;
        }
        this.idToNode.put(nodeId, node);
        if (node.hasBeforeClientResponseEntries()) {
            this.pendingExecutionNodes.add(node);
        }
        return nodeId;
    }

    @Override
    public void unregister(StateNode node) {
        assert (node.getOwner() == this);
        Integer id = node.getId();
        StateNode removedNode = this.idToNode.remove(id);
        if (removedNode != node) {
            if (removedNode != null) {
                this.idToNode.put(removedNode.getId(), removedNode);
            }
            throw new IllegalStateException("Unregistered node was not found based on its id. The tree is most likely corrupted.");
        }
        this.pendingExecutionNodes.remove(node);
    }

    @Override
    public boolean hasNode(StateNode node) {
        assert (node.getOwner() == this);
        return this.idToNode.containsKey(node.getId());
    }

    public StateNode getNodeById(int id) {
        return this.idToNode.get(id);
    }

    public void collectChanges(Consumer<NodeChange> collector) {
        LinkedHashSet<StateNode> allDirtyNodes = new LinkedHashSet<StateNode>();
        boolean evaluateNewDirtyNodes = true;
        while (evaluateNewDirtyNodes) {
            Set<StateNode> dirtyNodesSet = this.doCollectDirtyNodes(true);
            dirtyNodesSet.forEach(StateNode::updateActiveState);
            evaluateNewDirtyNodes = allDirtyNodes.addAll(dirtyNodesSet);
        }
        allDirtyNodes.forEach(node -> node.collectChanges(collector));
    }

    @Override
    public void markAsDirty(StateNode node) {
        assert (node.getOwner() == this);
        this.checkHasLock();
        this.dirtyNodes.add(node);
    }

    public Set<StateNode> collectDirtyNodes() {
        return this.doCollectDirtyNodes(false);
    }

    public boolean hasDirtyNodes() {
        return !this.dirtyNodes.isEmpty();
    }

    public UI getUI() {
        return this.uiInternals.getUI();
    }

    public ExecutionRegistration beforeClientResponse(StateNode context, SerializableConsumer<ExecutionContext> execution) {
        this.checkHasLock();
        assert (context != null) : "The 'context' parameter can not be null";
        assert (execution != null) : "The 'execution' parameter can not be null";
        if (context.isAttached()) {
            this.pendingExecutionNodes.add(context);
        }
        BeforeClientResponseEntry entry = new BeforeClientResponseEntry(this.nextBeforeClientResponseIndex, context, execution);
        ++this.nextBeforeClientResponseIndex;
        return context.addBeforeClientResponseEntry(entry);
    }

    public void runExecutionsBeforeClientResponse() {
        List<BeforeClientResponseEntry> callbacks;
        while (!(callbacks = this.flushCallbacks()).isEmpty()) {
            callbacks.stream().filter(entry -> ((BeforeClientResponseEntry)entry).canExecute(this.getUI())).forEach(entry -> {
                ExecutionContext context = new ExecutionContext(this.getUI(), entry.getStateNode().isClientSideInitialized());
                entry.getExecution().accept(context);
            });
        }
        return;
    }

    private List<BeforeClientResponseEntry> flushCallbacks() {
        if (!this.hasCallbacks()) {
            return Collections.emptyList();
        }
        List<BeforeClientResponseEntry> flushed = this.pendingExecutionNodes.stream().map(StateNode::dumpBeforeClientResponseEntries).flatMap(Collection::stream).sorted(BeforeClientResponseEntry.COMPARING_INDEX).collect(Collectors.toList());
        this.pendingExecutionNodes = new HashSet<StateNode>();
        return flushed;
    }

    private boolean hasCallbacks() {
        return !this.pendingExecutionNodes.isEmpty();
    }

    public boolean isDirty() {
        return this.hasDirtyNodes() || this.hasCallbacks();
    }

    private void checkHasLock() {
        VaadinSession session = this.uiInternals.getSession();
        if (session != null) {
            session.checkHasLock();
        }
    }

    private Set<StateNode> doCollectDirtyNodes(boolean reset) {
        if (reset) {
            Set<StateNode> collectedNodes = this.dirtyNodes;
            this.dirtyNodes = new LinkedHashSet<StateNode>();
            return collectedNodes;
        }
        return Collections.unmodifiableSet(this.dirtyNodes);
    }

    public void prepareForResync() {
        this.rootNode.prepareForResync();
    }

    @FunctionalInterface
    public static interface ExecutionRegistration
    extends Registration {
        @Override
        public void remove();
    }

    public static final class BeforeClientResponseEntry
    implements Serializable {
        private static final Comparator<BeforeClientResponseEntry> COMPARING_INDEX = Comparator.comparingInt(BeforeClientResponseEntry::getIndex);
        private final SerializableConsumer<ExecutionContext> execution;
        private final StateNode stateNode;
        private final int index;
        private final NodeOwner originalOwner;

        private BeforeClientResponseEntry(int index, StateNode stateNode, SerializableConsumer<ExecutionContext> execution) {
            this.index = index;
            this.stateNode = stateNode;
            this.execution = execution;
            this.originalOwner = stateNode.getOwner();
        }

        private int getIndex() {
            return this.index;
        }

        private boolean canExecute(UI ui) {
            if (this.originalOwner instanceof NullOwner) {
                return true;
            }
            return ui.getInternals().getStateTree() == this.originalOwner;
        }

        public StateNode getStateNode() {
            return this.stateNode;
        }

        public SerializableConsumer<ExecutionContext> getExecution() {
            return this.execution;
        }
    }

    private final class RootNode
    extends StateNode {
        private RootNode(Class<? extends NodeFeature>[] features) {
            super(features);
            this.setTree(StateTree.this);
            this.onAttach();
        }

        @Override
        public void setParent(StateNode parent) {
            if (parent != null) {
                throw new IllegalStateException("Can't set the parent of the tree root");
            }
            super.setParent(null);
            StateTree.this.isRootAttached = false;
        }

        @Override
        public boolean isAttached() {
            return StateTree.this.isRootAttached;
        }
    }
}

