/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.startup;

import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.WebBrowser;
import com.vaadin.flow.server.startup.BundleDependencyFilter;
import com.vaadin.flow.server.startup.FakeBrowser;
import elemental.json.Json;
import elemental.json.JsonArray;
import elemental.json.JsonObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BundleFilterFactory
implements Serializable {
    static final String MAIN_BUNDLE_NAME_PREFIX = "vaadin-flow-bundle";
    static final String FLOW_BUNDLE_MANIFEST = "frontend://vaadin-flow-bundle-manifest.json";

    public Stream<BundleDependencyFilter> createFilters(VaadinService service) {
        if (!service.getDeploymentConfiguration().useCompiledFrontendResources()) {
            return Stream.empty();
        }
        return Stream.of(this.createBundleFilterForBrowser(FakeBrowser.getEs6(), service), this.createBundleFilterForBrowser(FakeBrowser.getEs5(), service)).flatMap(maybeFilter -> maybeFilter.map(Stream::of).orElseGet(Stream::empty));
    }

    private Optional<BundleDependencyFilter> createBundleFilterForBrowser(WebBrowser browser, VaadinService service) {
        return this.readBundleManifest(browser, service).flatMap(bundleData -> this.createDependencyFilter(browser, (JsonObject)bundleData, service));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Optional<JsonObject> readBundleManifest(WebBrowser browser, VaadinService service) {
        try (InputStream bundleManifestStream = service.getResourceAsStream(FLOW_BUNDLE_MANIFEST, browser, null);){
            if (bundleManifestStream == null) {
                throw new IllegalArgumentException(String.format("Failed to find the bundle manifest file '%s' in the servlet context for '%s' browsers. If you are running a dev-mode servlet container in maven e.g. `jetty:run` change it to `jetty:run-exploded`. If you are not compiling frontend resources, include the 'vaadin-maven-plugin' in your build script. Otherwise, you can skip this error either by disabling production mode, or by setting the servlet parameter '%s=true'.", FLOW_BUNDLE_MANIFEST, browser.isEs6Supported() ? "ES6" : "ES5", "original.frontend.resources"));
            }
            Optional<JsonObject> optional = Optional.of(Json.parse((String)IOUtils.toString((InputStream)bundleManifestStream, (Charset)StandardCharsets.UTF_8)));
            return optional;
        }
        catch (IOException e) {
            throw new UncheckedIOException(String.format("Failed to read bundle manifest file at context path '%s'", FLOW_BUNDLE_MANIFEST), e);
        }
    }

    private Optional<BundleDependencyFilter> createDependencyFilter(WebBrowser browser, JsonObject bundlesToUrlsContained, VaadinService service) {
        HashMap<String, Set<String>> importToBundle = new HashMap<String, Set<String>>();
        String mainBundle = null;
        for (String bundlePath : bundlesToUrlsContained.keys()) {
            String frontendBundlePath = "frontend://" + bundlePath;
            if (!service.isResourceAvailable(frontendBundlePath, browser, null)) {
                throw new IllegalArgumentException(String.format("Failed to find bundle '%s', specified in manifest '%s'. Remove file reference from the manifest to disable bundle usage or add the bundle to the path specified.", frontendBundlePath, FLOW_BUNDLE_MANIFEST));
            }
            if (bundlePath.startsWith(MAIN_BUNDLE_NAME_PREFIX)) {
                if (mainBundle == null) {
                    mainBundle = bundlePath;
                } else {
                    throw new IllegalArgumentException(String.format("Flow bundle manifest '%s' contains multiple bundle files with name that starts with '%s'. This prefix is reserved for Flow purposes and you should not use it to name your fragments.", FLOW_BUNDLE_MANIFEST, MAIN_BUNDLE_NAME_PREFIX));
                }
            }
            JsonArray bundledFiles = bundlesToUrlsContained.getArray(bundlePath);
            for (int i = 0; i < bundledFiles.length(); ++i) {
                importToBundle.computeIfAbsent(bundledFiles.getString(i), key -> new HashSet()).add(bundlePath);
            }
        }
        if (importToBundle.isEmpty()) {
            BundleFilterFactory.getLogger().info("Bundling disabled: Flow bundle manifest '{}' contains no bundle data", (Object)FLOW_BUNDLE_MANIFEST);
            return Optional.empty();
        }
        if (mainBundle == null) {
            throw new IllegalArgumentException(String.format("Flow bundle manifest '%s' contains no main bundle: the single file prefixed with '%s' and having common code for all the fragments", FLOW_BUNDLE_MANIFEST, MAIN_BUNDLE_NAME_PREFIX));
        }
        return Optional.of(new BundleDependencyFilter(browser, mainBundle, importToBundle));
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger((String)BundleFilterFactory.class.getName());
    }
}

