/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server;

import com.vaadin.flow.server.PWA;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.servlet.ServletContext;

public class PwaConfiguration
implements Serializable {
    public static final String DEFAULT_PATH = "manifest.webmanifest";
    public static final String DEFAULT_ICON = "icons/icon.png";
    public static final String DEFAULT_NAME = "Vaadin Flow Application";
    public static final String DEFAULT_THEME_COLOR = "#ffffff";
    public static final String DEFAULT_BACKGROUND_COLOR = "#f2f2f2";
    public static final String DEFAULT_DISPLAY = "standalone";
    public static final String DEFAULT_OFFLINE_PATH = "offline.html";
    private final String appName;
    private final String shortName;
    private final String description;
    private final String backgroundColor;
    private final String themeColor;
    private final String iconPath;
    private final String manifestPath;
    private final String offlinePath;
    private final String serviceWorkerPath = "sw.js";
    private final String display;
    private final String rootUrl;
    private final String startPath;
    private final boolean enabled;
    private final List<String> offlineResources;
    private final boolean enableInstallPrompt;

    public PwaConfiguration() {
        this(false, "/", DEFAULT_NAME, "Flow PWA", "", DEFAULT_BACKGROUND_COLOR, DEFAULT_THEME_COLOR, DEFAULT_ICON, DEFAULT_PATH, DEFAULT_OFFLINE_PATH, DEFAULT_DISPLAY, "", new String[0], false);
    }

    protected PwaConfiguration(PWA pwa, ServletContext servletContext) {
        this(true, PwaConfiguration.rootUrlPath(servletContext), pwa.name(), pwa.shortName().substring(0, Math.min(pwa.shortName().length(), 12)), pwa.description(), pwa.backgroundColor(), pwa.themeColor(), PwaConfiguration.checkPath(pwa.iconPath()), PwaConfiguration.checkPath(pwa.manifestPath()), PwaConfiguration.checkPath(pwa.offlinePath()), pwa.display(), pwa.startPath().replaceAll("^/+", ""), pwa.offlineResources(), pwa.enableInstallPrompt());
    }

    public PwaConfiguration(boolean enabled, String rootUrl, String name, String shortName, String description, String backgroundColor, String themeColor, String iconPath, String manifestPath, String offlinePath, String display, String startPath, String[] offlineResources, boolean enableInstallPrompt) {
        this.rootUrl = rootUrl;
        this.appName = name;
        this.shortName = shortName.substring(0, Math.min(shortName.length(), 12));
        this.description = description;
        this.backgroundColor = backgroundColor;
        this.themeColor = themeColor;
        this.iconPath = iconPath;
        this.manifestPath = manifestPath;
        this.offlinePath = offlinePath;
        this.display = display;
        this.startPath = startPath;
        this.enabled = enabled;
        this.offlineResources = Arrays.asList(offlineResources);
        this.enableInstallPrompt = enableInstallPrompt;
    }

    private static String rootUrlPath(ServletContext servletContext) {
        return PwaConfiguration.hasContextPath(servletContext) ? servletContext.getContextPath() + "/" : "/";
    }

    private static boolean hasContextPath(ServletContext servletContext) {
        return servletContext != null && servletContext.getContextPath() != null && !servletContext.getContextPath().isEmpty();
    }

    private static String checkPath(String path) {
        return path.replaceAll("^[./]+", "");
    }

    public String getAppName() {
        return this.appName;
    }

    public String getShortName() {
        return this.shortName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getBackgroundColor() {
        return this.backgroundColor;
    }

    public String getThemeColor() {
        return this.themeColor;
    }

    public String getIconPath() {
        return this.iconPath;
    }

    public String relIconPath() {
        return "/" + this.iconPath;
    }

    public String getManifestPath() {
        return this.manifestPath;
    }

    public String relManifestPath() {
        return "/" + this.manifestPath;
    }

    public String getOfflinePath() {
        return this.offlinePath;
    }

    public String relOfflinePath() {
        return "/" + this.offlinePath;
    }

    public String getServiceWorkerPath() {
        return "sw.js";
    }

    public String relServiceWorkerPath() {
        return "/sw.js";
    }

    public List<String> getOfflineResources() {
        return Collections.unmodifiableList(this.offlineResources);
    }

    public String getDisplay() {
        return this.display;
    }

    public String getStartUrl() {
        return this.rootUrl + this.startPath;
    }

    public String getRootUrl() {
        return this.rootUrl;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isInstallPromptEnabled() {
        return this.enableInstallPrompt;
    }
}

