/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal.nodefeature;

import com.vaadin.flow.component.ClientCallable;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.dom.DisabledUpdateMode;
import com.vaadin.flow.internal.JsonCodec;
import com.vaadin.flow.internal.ReflectTools;
import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.nodefeature.AbstractServerHandlers;
import java.lang.reflect.Method;
import java.util.Locale;

public class ClientCallableHandlers
extends AbstractServerHandlers<Component> {
    public ClientCallableHandlers(StateNode node) {
        super(node);
    }

    @Override
    protected Class<? extends ClientCallable> getHandlerAnnotation() {
        return ClientCallable.class;
    }

    @Override
    protected void ensureSupportedParameterTypes(Method method) {
    }

    @Override
    protected void ensureSupportedReturnType(Method method) {
        Class<?> returnType = method.getReturnType();
        if (returnType.isPrimitive()) {
            returnType = ReflectTools.convertPrimitiveType(returnType);
        }
        if (!Void.TYPE.equals(returnType) && !JsonCodec.canEncodeWithTypeInfo(returnType)) {
            String msg = String.format(Locale.ENGLISH, "Only return types that can be used as Element.executeJs parameters are supported. Component '%s' has method '%s' annotated with '%s' whose return type is \"%s\"", method.getDeclaringClass().getName(), method.getName(), this.getHandlerAnnotation().getName(), method.getReturnType().getSimpleName());
            throw new IllegalStateException(msg);
        }
    }

    @Override
    protected DisabledUpdateMode getUpdateMode(Method method) {
        return method.getAnnotation(this.getHandlerAnnotation()).value();
    }
}

