/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal;

import com.vaadin.flow.server.BootstrapHandler;
import com.vaadin.flow.server.HandlerHelper;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinSession;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;

public final class BootstrapHandlerHelper
implements Serializable {
    private BootstrapHandlerHelper() {
    }

    public static String getServiceUrl(VaadinRequest vaadinRequest) {
        String pathInfo = vaadinRequest.getPathInfo();
        if (pathInfo == null) {
            return ".";
        }
        return HandlerHelper.getCancelingRelativePath(pathInfo);
    }

    public static String getPushURL(VaadinSession vaadinSession, VaadinRequest vaadinRequest) {
        String serviceUrl = BootstrapHandlerHelper.getServiceUrl(vaadinRequest);
        String pushURL = vaadinSession.getConfiguration().getPushURL();
        if (pushURL == null) {
            pushURL = serviceUrl;
        } else {
            try {
                URI uri = new URI(serviceUrl);
                pushURL = uri.resolve(new URI(pushURL)).toASCIIString();
            }
            catch (URISyntaxException exception) {
                throw new IllegalStateException(String.format("Can't resolve pushURL '%s' based on the service URL '%s'", pushURL, serviceUrl), exception);
            }
        }
        String contextPath = vaadinRequest.getService().getContextRootRelativePath(vaadinRequest);
        BootstrapHandler.BootstrapUriResolver resolver = new BootstrapHandler.BootstrapUriResolver(contextPath, vaadinSession);
        return resolver.resolveVaadinUri(pushURL);
    }
}

