/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend.scanner;

import com.vaadin.flow.component.WebComponentExporter;
import com.vaadin.flow.component.WebComponentExporterFactory;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.internal.ReflectTools;
import com.vaadin.flow.router.HasErrorParameter;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.router.RouterLayout;
import com.vaadin.flow.server.PWA;
import com.vaadin.flow.server.PwaConfiguration;
import com.vaadin.flow.server.UIInitListener;
import com.vaadin.flow.server.VaadinServiceInitListener;
import com.vaadin.flow.server.frontend.scanner.AbstractDependenciesScanner;
import com.vaadin.flow.server.frontend.scanner.ClassFinder;
import com.vaadin.flow.server.frontend.scanner.CssData;
import com.vaadin.flow.server.frontend.scanner.EndPointData;
import com.vaadin.flow.server.frontend.scanner.FrontendAnnotatedClassVisitor;
import com.vaadin.flow.server.frontend.scanner.FrontendClassVisitor;
import com.vaadin.flow.server.frontend.scanner.ThemeData;
import com.vaadin.flow.server.frontend.scanner.ThemeWrapper;
import com.vaadin.flow.theme.AbstractTheme;
import com.vaadin.flow.theme.NoTheme;
import com.vaadin.flow.theme.ThemeDefinition;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.bytebuddy.jar.asm.ClassReader;
import net.bytebuddy.jar.asm.ClassVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FrontendDependencies
extends AbstractDependenciesScanner {
    protected static final String ERROR_INVALID_PWA_ANNOTATION = "There can only be one @PWA annotation per application and it must be set on the application's parent layout, or in a view annotated with @Route";
    private final HashMap<String, EndPointData> endPoints = new HashMap();
    private ThemeDefinition themeDefinition;
    private AbstractTheme themeInstance;
    private final HashMap<String, String> packages = new HashMap();
    private final Set<String> visited = new HashSet<String>();
    private PwaConfiguration pwaConfiguration;

    public FrontendDependencies(ClassFinder finder) {
        this(finder, true);
    }

    public FrontendDependencies(ClassFinder finder, boolean generateEmbeddableWebComponents) {
        super(finder);
        FrontendDependencies.log().info("Scanning classes to find frontend configurations and dependencies...");
        long start = System.nanoTime();
        try {
            this.computeEndpoints();
            if (generateEmbeddableWebComponents) {
                this.computeExporterEndpoints(WebComponentExporter.class);
                this.computeExporterEndpoints(WebComponentExporterFactory.class);
            }
            this.computeApplicationTheme();
            this.computePackages();
            this.computePwaConfiguration();
            long ms = (System.nanoTime() - start) / 1000000L;
            FrontendDependencies.log().info("Visited {} classes. Took {} ms.", (Object)this.visited.size(), (Object)ms);
        }
        catch (IOException | ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new IllegalStateException("Unable to compute frontend dependencies", e);
        }
    }

    @Override
    public Map<String, String> getPackages() {
        return this.packages;
    }

    @Override
    public PwaConfiguration getPwaConfiguration() {
        return this.pwaConfiguration;
    }

    @Override
    public List<String> getModules() {
        LinkedHashSet<String> all = new LinkedHashSet<String>();
        for (EndPointData data : this.endPoints.values()) {
            all.addAll(data.getThemeModules());
        }
        for (EndPointData data : this.endPoints.values()) {
            all.addAll(data.getModules());
        }
        return new ArrayList<String>(all);
    }

    @Override
    public Set<String> getScripts() {
        LinkedHashSet<String> all = new LinkedHashSet<String>();
        for (EndPointData data : this.endPoints.values()) {
            all.addAll(data.getScripts());
        }
        return all;
    }

    @Override
    public Set<CssData> getCss() {
        LinkedHashSet<CssData> all = new LinkedHashSet<CssData>();
        for (EndPointData data : this.endPoints.values()) {
            all.addAll(data.getCss());
        }
        return all;
    }

    @Override
    public Set<String> getClasses() {
        return this.visited;
    }

    public Collection<EndPointData> getEndPoints() {
        return this.endPoints.values();
    }

    @Override
    public ThemeDefinition getThemeDefinition() {
        return this.themeDefinition;
    }

    @Override
    public AbstractTheme getTheme() {
        return this.themeInstance;
    }

    private void computeEndpoints() throws ClassNotFoundException, IOException {
        Class routeClass = this.getFinder().loadClass(Route.class.getName());
        for (Class<?> clazz : this.getFinder().getAnnotatedClasses(routeClass)) {
            this.collectEndpoints(clazz);
        }
        for (Class<Object> clazz : this.getFinder().getSubTypesOf(this.getFinder().loadClass(UIInitListener.class.getName()))) {
            this.collectEndpoints(clazz);
        }
        for (Class<Object> clazz : this.getFinder().getSubTypesOf(this.getFinder().loadClass(VaadinServiceInitListener.class.getName()))) {
            this.collectEndpoints(clazz);
        }
        for (Class<Object> clazz : this.getFinder().getSubTypesOf(this.getFinder().loadClass(HasErrorParameter.class.getName()))) {
            this.collectEndpoints(clazz);
        }
    }

    private void collectEndpoints(Class<?> entry) throws IOException {
        String className = entry.getName();
        EndPointData data = new EndPointData(entry);
        this.endPoints.put(className, this.visitClass(className, data, false));
    }

    private void computeApplicationTheme() throws ClassNotFoundException, InstantiationException, IllegalAccessException, IOException {
        for (EndPointData endPoint : this.endPoints.values()) {
            if (endPoint.getLayout() != null) {
                this.visitClass(endPoint.getLayout(), endPoint, false);
            }
            if (endPoint.getTheme() == null) continue;
            this.visitClass(endPoint.getTheme().getThemeClass(), endPoint, true);
        }
        Set themes = this.endPoints.values().stream().filter(data -> data.getTheme().getThemeClass() != null || data.getTheme().getThemeName() != null && !data.getTheme().getThemeName().isEmpty() || !data.getTheme().getVariant().isEmpty() || data.getTheme().isNotheme()).map(EndPointData::getTheme).collect(Collectors.toSet());
        if (themes.size() > 1) {
            String names = this.endPoints.values().stream().filter(data -> data.getTheme().getThemeClass() != null || data.getTheme().getThemeName() != null || data.getTheme().isNotheme()).map(data -> "found '" + (data.getTheme().isNotheme() ? NoTheme.class.getName() : data.getTheme().getThemeName()) + "' in '" + data.getName() + "'").collect(Collectors.joining("\n      "));
            throw new IllegalStateException("\n Multiple Theme configuration is not supported:\n      " + names);
        }
        Class<AbstractTheme> theme = null;
        String variant = "";
        String themeName = "";
        if (themes.isEmpty()) {
            theme = this.getDefaultTheme();
        } else {
            ThemeData themeData = (ThemeData)themes.iterator().next();
            if (!themeData.isNotheme()) {
                String themeClass = themeData.getThemeClass();
                if (!themeData.getThemeName().isEmpty() && themeClass != null && this.getDefaultTheme() != null && !this.getDefaultTheme().isAssignableFrom(this.getFinder().loadClass(themeClass))) {
                    throw new IllegalStateException("Theme name and theme class can not both be specified. Theme name uses Lumo and can not be used in combination with custom theme class that doesn't extend Lumo.");
                }
                variant = themeData.getVariant();
                if (themeClass != null) {
                    theme = this.getFinder().loadClass(themeClass);
                } else {
                    theme = this.getDefaultTheme();
                    if (theme == null) {
                        throw new IllegalStateException("Lumo dependency needs to be available on the classpath when using a theme name.");
                    }
                }
                themeName = themeData.getThemeName();
            }
        }
        if (theme != null) {
            this.themeDefinition = new ThemeDefinition(theme, variant, themeName);
            this.themeInstance = new ThemeWrapper(theme);
        }
    }

    private Class<? extends AbstractTheme> getDefaultTheme() throws IOException {
        Class<? extends AbstractTheme> defaultTheme = this.getLumoTheme();
        if (defaultTheme != null) {
            Optional<EndPointData> endPointData = this.endPoints.values().stream().findFirst();
            if (endPointData.isPresent()) {
                this.visitClass(defaultTheme.getName(), endPointData.get(), true);
            }
            return defaultTheme;
        }
        return null;
    }

    private void computePackages() throws ClassNotFoundException, IOException {
        FrontendAnnotatedClassVisitor npmPackageVisitor = new FrontendAnnotatedClassVisitor(this.getFinder(), NpmPackage.class.getName());
        for (Class<?> component : this.getFinder().getAnnotatedClasses(NpmPackage.class.getName())) {
            npmPackageVisitor.visitClass(component.getName());
        }
        Set dependencies = npmPackageVisitor.getValues("value");
        for (String dependency : dependencies) {
            Set versions = npmPackageVisitor.getValuesForKey("value", dependency, "version");
            String version = (String)versions.iterator().next();
            if (versions.size() > 1) {
                String foundVersions = versions.toString();
                FrontendDependencies.log().warn("Multiple npm versions for {} found:  {}. First version found '{}' will be considered.", new Object[]{dependency, foundVersions, version});
            }
            this.packages.put(dependency, version);
        }
    }

    private void computePwaConfiguration() throws ClassNotFoundException {
        FrontendAnnotatedClassVisitor pwaVisitor = new FrontendAnnotatedClassVisitor(this.getFinder(), PWA.class.getName());
        Class routeAnnotationClass = this.getFinder().loadClass(Route.class.getName());
        Class routeLayoutClass = this.getFinder().loadClass(RouterLayout.class.getName());
        Class webComponentExporter = this.getFinder().loadClass(WebComponentExporter.class.getName());
        for (Class<?> hopefullyCorrectPWAHolder : this.getFinder().getAnnotatedClasses(PWA.class.getName())) {
            if (!(hopefullyCorrectPWAHolder.isAnnotationPresent(routeAnnotationClass) || routeLayoutClass.isAssignableFrom(hopefullyCorrectPWAHolder) || webComponentExporter.isAssignableFrom(hopefullyCorrectPWAHolder))) {
                throw new IllegalStateException("There can only be one @PWA annotation per application and it must be set on the application's parent layout, or in a view annotated with @Route but was found on " + hopefullyCorrectPWAHolder.getName());
            }
            pwaVisitor.visitClass(hopefullyCorrectPWAHolder.getName());
        }
        Set dependencies = pwaVisitor.getValues("name");
        if (dependencies.size() > 1) {
            throw new IllegalStateException("There can only be one @PWA annotation per application and it must be set on the application's parent layout, or in a view annotated with @Route Found " + dependencies.size() + " implementations: " + dependencies);
        }
        if (dependencies.isEmpty()) {
            this.pwaConfiguration = new PwaConfiguration();
            return;
        }
        String name = (String)pwaVisitor.getValue("name");
        String shortName = (String)pwaVisitor.getValue("shortName");
        String description = (String)pwaVisitor.getValue("description");
        String backgroundColor = (String)pwaVisitor.getValue("backgroundColor");
        String themeColor = (String)pwaVisitor.getValue("themeColor");
        String iconPath = (String)pwaVisitor.getValue("iconPath");
        String manifestPath = (String)pwaVisitor.getValue("manifestPath");
        String offlinePath = (String)pwaVisitor.getValue("offlinePath");
        String display = (String)pwaVisitor.getValue("display");
        String startPath = (String)pwaVisitor.getValue("startPath");
        List offlineResources = (List)pwaVisitor.getValue("offlineResources");
        boolean enableInstallPrompt = (Boolean)pwaVisitor.getValue("enableInstallPrompt");
        this.pwaConfiguration = new PwaConfiguration(true, "/", name, shortName, description, backgroundColor, themeColor, iconPath, manifestPath, offlinePath, display, startPath, offlineResources.toArray(new String[0]), enableInstallPrompt);
    }

    private static Logger log() {
        return LoggerFactory.getLogger((String)"dev-updater");
    }

    private void computeExporterEndpoints(Class<?> clazz) throws ClassNotFoundException, IOException {
        Class routeClass = this.getFinder().loadClass(Route.class.getName());
        Class exporterClass = this.getFinder().loadClass(clazz.getName());
        Set exporterClasses = this.getFinder().getSubTypesOf(exporterClass);
        if (exporterClasses.isEmpty()) {
            return;
        }
        HashMap<String, EndPointData> exportedPoints = new HashMap<String, EndPointData>();
        for (Class exporter : exporterClasses) {
            Class<?> componentClass;
            String exporterClassName = exporter.getName();
            EndPointData exporterData = new EndPointData(exporter);
            exportedPoints.put(exporterClassName, this.visitClass(exporterClassName, exporterData, false));
            if (Modifier.isAbstract(exporter.getModifiers()) || (componentClass = ReflectTools.getGenericInterfaceType(exporter, exporterClass)) == null || componentClass.isAnnotationPresent(routeClass)) continue;
            String componentClassName = componentClass.getName();
            EndPointData configurationData = new EndPointData(componentClass);
            exportedPoints.put(componentClassName, this.visitClass(componentClassName, configurationData, false));
        }
        this.endPoints.putAll(exportedPoints);
    }

    private EndPointData visitClass(String className, EndPointData endPoint, boolean themeScope) throws IOException {
        if (!this.isVisitable(className) || !themeScope && endPoint.getClasses().contains(className)) {
            return endPoint;
        }
        endPoint.getClasses().add(className);
        URL url = this.getUrl(className);
        if (url == null) {
            return endPoint;
        }
        FrontendClassVisitor visitor = new FrontendClassVisitor(className, endPoint, themeScope);
        try (InputStream is = url.openStream();){
            ClassReader cr = new ClassReader(is);
            cr.accept((ClassVisitor)visitor, 8);
        }
        catch (Exception e) {
            FrontendDependencies.log().error("Visiting class {} failed with {}.\nThis might be a broken class in the project.", (Object)className, (Object)e.getMessage());
            throw e;
        }
        this.visited.add(className);
        for (String clazz : visitor.getChildren()) {
            if (this.visited.contains(clazz)) continue;
            this.visitClass(clazz, endPoint, themeScope);
        }
        return endPoint;
    }

    private boolean isVisitable(String className) {
        return className != null && !className.matches("(^$|.*(slf4j).*|^(java|sun|elemental|javax|org.(apache|atmosphere|jsoup|jboss|w3c|spring|joda|hibernate|glassfish|hsqldb)|com.(helger|spring|gwt|lowagie|fasterxml)|net.(sf|bytebuddy)).*|.*(Exception)$)");
    }

    private URL getUrl(String className) {
        return this.getFinder().getResource(className.replace(".", "/") + ".class");
    }

    public String toString() {
        return this.endPoints.toString();
    }
}

