/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.dom.impl;

import com.helger.css.ECSSVersion;
import com.helger.css.ICSSWriterSettings;
import com.helger.css.decl.CSSDeclaration;
import com.helger.css.decl.CSSDeclarationList;
import com.helger.css.reader.CSSReaderDeclarationList;
import com.helger.css.reader.errorhandler.CSSParseError;
import com.helger.css.reader.errorhandler.CollectingCSSParseErrorHandler;
import com.helger.css.reader.errorhandler.ICSSParseErrorHandler;
import com.helger.css.writer.CSSWriterSettings;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.Style;
import com.vaadin.flow.dom.StyleUtil;
import com.vaadin.flow.dom.impl.CustomAttribute;
import java.util.LinkedHashMap;
import java.util.stream.Collectors;

public class StyleAttributeHandler
extends CustomAttribute {
    private static final String ERROR_PARSING_STYLE = "Error parsing style '%s': %s";

    @Override
    public boolean hasAttribute(Element element) {
        return element.getStyle().getNames().findAny().isPresent();
    }

    @Override
    public String getAttribute(Element element) {
        if (!this.hasAttribute(element)) {
            return null;
        }
        Style style = element.getStyle();
        return style.getNames().map(styleName -> StyleUtil.stylePropertyToAttribute(styleName) + ":" + style.get((String)styleName)).collect(Collectors.joining(";"));
    }

    @Override
    public void setAttribute(Element element, String attributeValue) {
        Style style = element.getStyle();
        style.clear();
        StyleAttributeHandler.parseStyles(attributeValue).forEach(style::set);
    }

    public static LinkedHashMap<String, String> parseStyles(String styleString) {
        CollectingCSSParseErrorHandler errorCollector = new CollectingCSSParseErrorHandler();
        CSSDeclarationList parsed = CSSReaderDeclarationList.readFromString((String)styleString, (ECSSVersion)ECSSVersion.LATEST, (ICSSParseErrorHandler)errorCollector);
        if (errorCollector.hasParseErrors()) {
            throw new IllegalArgumentException(String.format(ERROR_PARSING_STYLE, styleString, ((CSSParseError)errorCollector.getAllParseErrors().get(0)).getErrorMessage()));
        }
        if (parsed == null) {
            throw new IllegalArgumentException(String.format(ERROR_PARSING_STYLE, styleString, "No styles found"));
        }
        LinkedHashMap<String, String> parsedStyles = new LinkedHashMap<String, String>();
        for (CSSDeclaration declaration : parsed.getAllDeclarations()) {
            String key = declaration.getProperty();
            String value = declaration.getExpression().getAsCSSString((ICSSWriterSettings)new CSSWriterSettings(ECSSVersion.LATEST).setOptimizedOutput(true), 0);
            parsedStyles.put(StyleUtil.styleAttributeToProperty(key), value);
        }
        return parsedStyles;
    }

    @Override
    public void removeAttribute(Element element) {
        element.getStyle().clear();
    }
}

