/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal.nodefeature;

import com.vaadin.flow.dom.DisabledUpdateMode;
import com.vaadin.flow.function.SerializableBiConsumer;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.nodefeature.ReturnChannelRegistration;
import com.vaadin.flow.internal.nodefeature.ServerSideFeature;
import elemental.json.JsonArray;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ReturnChannelMap
extends ServerSideFeature {
    private int nextId = 0;
    private Map<Integer, ChannelImpl> channels = new HashMap<Integer, ChannelImpl>();

    public ReturnChannelMap(StateNode node) {
        super(node);
    }

    public ReturnChannelRegistration registerChannel(SerializableConsumer<JsonArray> handler) {
        assert (handler != null);
        return this.registerChannel((arguments, channel) -> handler.accept((JsonArray)arguments));
    }

    public ReturnChannelRegistration registerChannel(SerializableBiConsumer<JsonArray, ReturnChannelRegistration> handler) {
        assert (handler != null);
        ChannelImpl channel = new ChannelImpl(this.nextId++, handler);
        this.channels.put(channel.getChannelId(), channel);
        return channel;
    }

    public ReturnChannelRegistration get(int channelId) {
        return this.channels.get(channelId);
    }

    private class ChannelImpl
    implements ReturnChannelRegistration {
        private final int channelId;
        private final SerializableBiConsumer<JsonArray, ReturnChannelRegistration> handler;
        private DisabledUpdateMode disabledUpdateMode = DisabledUpdateMode.ONLY_WHEN_ENABLED;

        public ChannelImpl(int channelId, SerializableBiConsumer<JsonArray, ReturnChannelRegistration> handler) {
            this.channelId = channelId;
            this.handler = handler;
        }

        @Override
        public void remove() {
            ReturnChannelMap.this.channels.remove(this.channelId);
        }

        @Override
        public int getStateNodeId() {
            return ReturnChannelMap.this.getNode().getId();
        }

        @Override
        public int getChannelId() {
            return this.channelId;
        }

        @Override
        public void invoke(JsonArray arguments) {
            this.handler.accept(arguments, this);
        }

        @Override
        public DisabledUpdateMode getDisabledUpdateMode() {
            return this.disabledUpdateMode;
        }

        @Override
        public ReturnChannelRegistration setDisabledUpdateMode(DisabledUpdateMode disabledUpdateMode) {
            this.disabledUpdateMode = Objects.requireNonNull(disabledUpdateMode);
            return this;
        }
    }
}

