/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal;

import com.vaadin.flow.internal.DebugWindowData;
import com.vaadin.flow.server.Version;
import elemental.json.Json;
import elemental.json.JsonObject;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.slf4j.LoggerFactory;

public class ServerInfo
implements DebugWindowData {
    private final String flowVersion = Version.getFullVersion();
    private final String vaadinVersion = this.fetchVaadinVersion();
    private final String javaVersion = this.fetchJavaVersion();
    private final String osVersion = this.fetchOperatingSystem();

    private String fetchJavaVersion() {
        String vendor = System.getProperty("java.vendor");
        String version = System.getProperty("java.version");
        return vendor + " " + version;
    }

    private String fetchOperatingSystem() {
        String arch = System.getProperty("os.arch");
        String name = System.getProperty("os.name");
        String version = System.getProperty("os.version");
        return arch + " " + name + " " + version;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String fetchVaadinVersion() {
        try (InputStream vaadinVersionsStream = this.getClass().getClassLoader().getResourceAsStream("vaadin-core-versions.json");){
            if (vaadinVersionsStream != null) {
                JsonObject vaadinVersions = Json.parse((String)IOUtils.toString((InputStream)vaadinVersionsStream, (Charset)StandardCharsets.UTF_8));
                String string = vaadinVersions.get("platform").asString();
                return string;
            }
            LoggerFactory.getLogger(this.getClass()).info("Unable to determine version information. No {} found", (Object)"vaadin-core-versions.json");
            return "?";
        }
        catch (Exception e) {
            LoggerFactory.getLogger(this.getClass()).error("Unable to determine version information", (Throwable)e);
        }
        return "?";
    }

    public String getFlowVersion() {
        return this.flowVersion;
    }

    public String getVaadinVersion() {
        return this.vaadinVersion;
    }

    public String getJavaVersion() {
        return this.javaVersion;
    }

    public String getOsVersion() {
        return this.osVersion;
    }

    @Override
    public String toJson() {
        return String.format("{\"flowVersion\": \"%s\", \"vaadinVersion\": \"%s\", \"javaVersion\": \"%s\", \"osVersion\": \"%s\"}", this.flowVersion, this.vaadinVersion, this.javaVersion, this.osVersion);
    }
}

