/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.internal;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HtmlImportParser {
    private HtmlImportParser() {
    }

    private static String resolveUri(String relative, String base) {
        if (relative.startsWith("/")) {
            return relative;
        }
        try {
            URI uri = new URI(base);
            return HtmlImportParser.relativize(relative, uri);
        }
        catch (URISyntaxException exception) {
            HtmlImportParser.getLogger().debug("Couldn't make URI for {}. The path {} will be used as is.", new Object[]{base, relative, exception});
            return relative;
        }
    }

    private static String relativize(String relative, URI base) throws URISyntaxException {
        URI newUri;
        if (base.getPath().isEmpty()) {
            String uriString = base.toString();
            int index = uriString.lastIndexOf(47);
            newUri = new URI(uriString.substring(0, index + 1) + relative);
        } else {
            newUri = base.resolve(relative);
        }
        return HtmlImportParser.toNormalizedURI(newUri);
    }

    static String toNormalizedURI(URI uri) {
        URI normalized = uri.normalize();
        if ("frontend".equals(normalized.getScheme()) || "base".equals(normalized.getScheme()) || "context".equals(normalized.getScheme())) {
            if (".".equals(normalized.getAuthority()) && normalized.getHost() == null) {
                return normalized.toString().replace("//./", "//");
            }
            if (normalized.getPath().startsWith("/../")) {
                return normalized.toString().replace(normalized.getHost() + "/../", "");
            }
        }
        return normalized.toString();
    }

    private static Stream<String> parseHtmlImports(InputStream content, String path) {
        assert (content != null);
        try {
            Document parsedDocument = Jsoup.parse((InputStream)content, (String)StandardCharsets.UTF_8.name(), (String)"");
            return parsedDocument.getElementsByTag("link").stream().filter(link -> link.hasAttr("rel") && link.hasAttr("href")).filter(link -> "import".equals(link.attr("rel"))).map(link -> link.attr("href"));
        }
        catch (IOException exception) {
            HtmlImportParser.getLogger().info("Can't parse the template declared using '{}' path", (Object)path, (Object)exception);
            return Stream.empty();
        }
    }

    public static void parseImports(String resourcePath, Function<String, InputStream> getResourceAsStream, Function<String, String> resolveResource, Consumer<String> importHandler) {
        try (InputStream content = getResourceAsStream.apply(resourcePath);){
            if (content == null) {
                HtmlImportParser.getLogger().trace("Can't find resource '{}' to parse for imports via the servlet context", (Object)resourcePath);
            } else {
                String resolvedPath = resolveResource.apply(resourcePath);
                HtmlImportParser.parseHtmlImports(content, resolvedPath).map(uri -> HtmlImportParser.resolveUri(uri, resourcePath)).forEach(importHandler);
            }
        }
        catch (IOException exception) {
            HtmlImportParser.getLogger().debug("Couldn't close template input stream", (Throwable)exception);
        }
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(HtmlImportParser.class);
    }
}

