/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.react;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.dom.DomListenerRegistration;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.PropertyChangeListener;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.internal.JacksonCodec;
import com.vaadin.flow.internal.JacksonUtils;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import tools.jackson.core.type.TypeReference;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.BaseJsonNode;

public abstract class ReactAdapterComponent
extends Component {
    private Map<String, Element> contentMap;

    protected <T> DomListenerRegistration addStateChangeListener(String stateName, Class<T> typeClass, SerializableConsumer<T> listener) {
        return this.addJsonReaderStateChangeListener(stateName, (SerializableFunction & Serializable)jsonValue -> ReactAdapterComponent.readFromJson(jsonValue, typeClass), listener);
    }

    protected <T> DomListenerRegistration addStateChangeListener(String stateName, TypeReference<T> typeReference, SerializableConsumer<T> listener) {
        return this.addJsonReaderStateChangeListener(stateName, (SerializableFunction & Serializable)jsonValue -> ReactAdapterComponent.readFromJson(jsonValue, typeReference), listener);
    }

    protected void setState(String stateName, Object value) {
        this.getElement().setPropertyJson(stateName, ReactAdapterComponent.writeToJson(value));
    }

    protected <T> T getState(String stateName, Class<T> typeClass) {
        return ReactAdapterComponent.readFromJson(this.getPropertyJson(stateName), typeClass);
    }

    protected <T> T getState(String stateName, TypeReference<T> typeReference) {
        return ReactAdapterComponent.readFromJson(this.getPropertyJson(stateName), typeReference);
    }

    protected static <T> T readFromJson(JsonNode jsonValue, Class<T> typeClass) {
        return (T)JacksonUtils.readValue((JsonNode)jsonValue, typeClass);
    }

    protected static <T> T readFromJson(JsonNode jsonValue, TypeReference<T> typeReference) {
        return (T)JacksonUtils.readValue((JsonNode)jsonValue, typeReference);
    }

    protected static BaseJsonNode writeToJson(Object object) {
        return JacksonUtils.writeValue((Object)object);
    }

    protected Element getContentElement(String name) {
        if (this.contentMap == null) {
            this.contentMap = new HashMap<String, Element>();
        }
        if (!this.contentMap.containsKey(name)) {
            Element element = new Element("flow-content-container");
            this.contentMap.put(name, element);
            this.getElement().getStateProvider().appendVirtualChild(this.getElement().getNode(), element, "@name", name);
            return element;
        }
        return this.contentMap.get(name);
    }

    private JsonNode getPropertyJson(String propertyName) {
        Serializable rawValue = this.getElement().getPropertyRaw(propertyName);
        if (rawValue == null) {
            return JacksonUtils.nullNode();
        }
        if (rawValue instanceof JsonNode) {
            JsonNode jsonNode = (JsonNode)rawValue;
            return jsonNode;
        }
        if (rawValue instanceof String) {
            String stringValue = (String)((Object)rawValue);
            return JacksonUtils.createNode((Object)stringValue);
        }
        if (rawValue instanceof Double) {
            Double doubleValue = (Double)rawValue;
            return JacksonUtils.createNode((Object)doubleValue);
        }
        if (rawValue instanceof Boolean) {
            Boolean booleanValue = (Boolean)rawValue;
            return JacksonUtils.createNode((Object)booleanValue);
        }
        return JacksonUtils.createNode((Object)rawValue.toString());
    }

    private <T> DomListenerRegistration addJsonReaderStateChangeListener(String stateName, SerializableFunction<JsonNode, T> jsonReader, SerializableConsumer<T> listener) {
        return this.getElement().addPropertyChangeListener(stateName, stateName + "-changed", (PropertyChangeListener & Serializable)event -> {
            JsonNode newStateJson = JacksonCodec.encodeWithoutTypeInfo((Object)event.getValue());
            Object newState = jsonReader.apply((Object)newStateJson);
            listener.accept(newState);
        });
    }
}

