/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.polymer2lit;

import com.vaadin.flow.server.frontend.FrontendTools;
import com.vaadin.flow.server.frontend.FrontendUtils;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import org.apache.commons.io.IOUtils;

public class FrontendConverter
implements AutoCloseable {
    private static final String CONVERTER_EXECUTABLE_PATH = "/META-INF/frontend/generated/convert.js";
    private final FrontendTools frontendTools;
    private final Path tempDirPath;
    private final Path converterTempPath;

    public FrontendConverter(FrontendTools frontendTools) throws IOException {
        this.frontendTools = frontendTools;
        this.tempDirPath = Files.createTempDirectory("converter", new FileAttribute[0]);
        this.converterTempPath = this.tempDirPath.resolve("converter.js");
        Files.copy(this.getClass().getResourceAsStream(CONVERTER_EXECUTABLE_PATH), this.converterTempPath, new CopyOption[0]);
    }

    @Override
    public void close() throws IOException {
        Files.deleteIfExists(this.converterTempPath);
        Files.deleteIfExists(this.tempDirPath);
    }

    public boolean convertFile(Path filePath, boolean useLit1, boolean disableOptionalChaining) throws IOException, InterruptedException, FrontendUtils.CommandExecutionException {
        if (!this.readFile(filePath).contains("PolymerElement")) {
            return false;
        }
        ArrayList<String> command = new ArrayList<String>();
        command.add(this.frontendTools.getNodeExecutable());
        command.add(this.converterTempPath.toFile().getAbsolutePath());
        command.add(filePath.toFile().getAbsolutePath());
        if (useLit1) {
            command.add("-1");
        }
        if (disableOptionalChaining) {
            command.add("-disable-optional-chaining");
        }
        FrontendUtils.executeCommand(command);
        return true;
    }

    private String readFile(Path filePath) throws IOException {
        try (FileInputStream stream = new FileInputStream(filePath.toFile());){
            String string = IOUtils.toString((InputStream)stream, (Charset)StandardCharsets.UTF_8);
            return string;
        }
    }
}

