/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.plugin.base;

import com.vaadin.flow.internal.FrontendUtils;
import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.flow.plugin.base.CleanOptions;
import com.vaadin.flow.plugin.base.PluginAdapterBase;
import com.vaadin.flow.server.frontend.FrontendBuildUtils;
import com.vaadin.flow.server.frontend.scanner.ClassFinder;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import org.apache.commons.io.FileUtils;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.ObjectNode;

public class CleanFrontendUtil {
    public static final String VAADIN = "vaadin";
    public static final String DEPENDENCIES = "dependencies";
    public static final String DEV_DEPENDENCIES = "devDependencies";
    public static final String OVERRIDES = "overrides";
    public static final String PNPM = "pnpm";

    public static void runCleaning(PluginAdapterBase adapter, CleanOptions options) throws CleanFrontendException {
        File frontendGeneratedFolder;
        File pnpmfile;
        if (FrontendBuildUtils.isHillaUsed((File)adapter.frontendDirectory(), (ClassFinder)adapter.getClassFinder())) {
            options.withRemovePackageLock(false).withRemoveNodeModules(false);
        }
        if (options.isRemoveNodeModules()) {
            CleanFrontendUtil.removeNodeModules(adapter);
        }
        if (options.isRemovePackageLock()) {
            File lockFile = new File(adapter.npmFolder(), "pnpm-lock.yaml");
            if (!lockFile.exists()) {
                lockFile = new File(adapter.npmFolder(), "bun.lockb");
            }
            if (!lockFile.exists()) {
                lockFile = new File(adapter.npmFolder(), "bun.lock");
            }
            if (!lockFile.exists()) {
                lockFile = new File(adapter.npmFolder(), "package-lock.json");
            }
            if (lockFile.exists()) {
                lockFile.delete();
            }
        }
        if (options.isRemovePnpmFile() && (pnpmfile = new File(adapter.npmFolder(), ".pnpmfile.cjs")).exists()) {
            pnpmfile.delete();
        }
        if (adapter.generatedTsFolder().exists() && options.isRemoveGeneratedTSFolder()) {
            try {
                FileUtils.deleteDirectory((File)adapter.generatedTsFolder());
            }
            catch (IOException exception) {
                throw new CleanFrontendException("Failed to remove folder'" + adapter.generatedTsFolder().getAbsolutePath() + "'", exception);
            }
        }
        if ((frontendGeneratedFolder = new File(adapter.frontendDirectory(), "generated/")).exists() && options.isRemoveFrontendGeneratedFolder()) {
            try {
                FileUtils.deleteDirectory((File)frontendGeneratedFolder);
            }
            catch (IOException exception) {
                throw new CleanFrontendException("Failed to remove folder'" + frontendGeneratedFolder.getAbsolutePath() + "'", exception);
            }
        }
        try {
            File packageJsonFile = new File(adapter.npmFolder(), "package.json");
            if (packageJsonFile.exists() && options.isCleanPackageJson()) {
                ObjectNode packageJson = JacksonUtils.readTree((String)FileUtils.readFileToString((File)packageJsonFile, (String)StandardCharsets.UTF_8.name()));
                CleanFrontendUtil.cleanupPackage(adapter, packageJson);
                FileUtils.write((File)packageJsonFile, (CharSequence)(packageJson.toPrettyString() + "\n"), (String)StandardCharsets.UTF_8.name());
            }
        }
        catch (IOException e) {
            throw new CleanFrontendException("Failed to clean 'package.json' file", e);
        }
        if (options.isRemoveDevBundle()) {
            CleanFrontendUtil.removeDevBundle(adapter);
        }
    }

    private static void removeDevBundle(PluginAdapterBase adapter) {
        CleanFrontendUtil.removeDevBundle(adapter, "src/main/bundles/");
        CleanFrontendUtil.removeDevBundle(adapter, "src/main/dev-bundle/");
    }

    private static void removeDevBundle(PluginAdapterBase adapter, String bundleLocation) {
        File bundleDir = new File(adapter.npmFolder(), bundleLocation);
        try {
            if (bundleDir.exists()) {
                FileUtils.deleteDirectory((File)bundleDir);
            }
        }
        catch (IOException exception) {
            adapter.logDebug("Exception removing dev-bundle", exception);
            adapter.logError("Failed to remove '" + bundleDir.getAbsolutePath() + "'. Please remove it manually.");
        }
    }

    private static void removeNodeModules(PluginAdapterBase adapter) {
        File nodeModules = new File(adapter.npmFolder(), "node_modules");
        try {
            FrontendUtils.deleteNodeModules((File)nodeModules);
        }
        catch (IOException exception) {
            adapter.logDebug("Exception removing node_modules", exception);
            adapter.logError("Failed to remove '" + nodeModules.getAbsolutePath() + "'. Please remove it manually.");
        }
    }

    private static void cleanupPackage(PluginAdapterBase adapter, ObjectNode packageJson) {
        ObjectNode pnpmOverridesSection;
        ObjectNode dependencies = (ObjectNode)packageJson.get(DEPENDENCIES);
        ObjectNode devDependencies = (ObjectNode)packageJson.get(DEV_DEPENDENCIES);
        ObjectNode overridesSection = (ObjectNode)packageJson.get(OVERRIDES);
        ObjectNode objectNode = pnpmOverridesSection = packageJson.has(PNPM) ? (ObjectNode)packageJson.get(PNPM).get(OVERRIDES) : null;
        if (packageJson.has(VAADIN)) {
            ObjectNode vaadin = (ObjectNode)packageJson.get(VAADIN);
            ObjectNode vaadinDependencies = (ObjectNode)vaadin.get(DEPENDENCIES);
            ObjectNode vaadinDevDependencies = (ObjectNode)vaadin.get(DEV_DEPENDENCIES);
            CleanFrontendUtil.cleanObject(dependencies, vaadinDependencies);
            CleanFrontendUtil.cleanObject(devDependencies, vaadinDevDependencies);
            CleanFrontendUtil.cleanObject(overridesSection, vaadinDependencies, false);
            CleanFrontendUtil.cleanObject(pnpmOverridesSection, vaadinDependencies, false);
            packageJson.remove(VAADIN);
        }
        CleanFrontendUtil.cleanFrameworkBuildDependenices(adapter, dependencies);
        CleanFrontendUtil.cleanFrameworkBuildDependenices(adapter, devDependencies);
        packageJson.remove("hash");
    }

    private static void cleanObject(ObjectNode target, ObjectNode reference) {
        CleanFrontendUtil.cleanObject(target, reference, true);
    }

    private static void cleanObject(ObjectNode target, ObjectNode reference, boolean requireVersionsMatch) {
        if (target == null) {
            return;
        }
        HashSet<String> removeKeys = new HashSet<String>();
        for (String key : JacksonUtils.getKeys((JsonNode)target)) {
            if (!reference.has(key) || requireVersionsMatch && !CleanFrontendUtil.versionsMatch(target, reference, key)) continue;
            removeKeys.add(key);
        }
        for (String key : removeKeys) {
            target.remove(key);
        }
    }

    private static boolean versionsMatch(ObjectNode target, ObjectNode reference, String key) {
        return target.get(key).textValue().equals(reference.get(key).textValue());
    }

    private static void cleanFrameworkBuildDependenices(PluginAdapterBase adapter, ObjectNode dependencyObject) {
        if (dependencyObject == null) {
            return;
        }
        String buildTargetFolder = "./" + adapter.buildFolder();
        HashSet<String> removeKeys = new HashSet<String>();
        for (String key : JacksonUtils.getKeys((JsonNode)dependencyObject)) {
            if (!dependencyObject.get(key).textValue().startsWith(buildTargetFolder)) continue;
            removeKeys.add(key);
        }
        for (String key : removeKeys) {
            dependencyObject.remove(key);
        }
    }

    public static class CleanFrontendException
    extends Exception {
        public CleanFrontendException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

