/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.scanner;

import com.vaadin.flow.server.frontend.scanner.ClassFinder;
import io.github.classgraph.AnnotationInfo;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ClassInfoList;
import io.github.classgraph.ScanResult;
import java.lang.annotation.Annotation;
import java.lang.annotation.Repeatable;
import java.lang.reflect.AnnotatedElement;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import nonapi.io.github.classgraph.utils.VersionFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReflectionsClassFinder
implements ClassFinder {
    public static final String DISABLE_DEFAULT_PACKAGE_FILTER = "vaadin.classfinder.disableDefaultPackageFilter";
    private static final String[] DEFAULT_REJECTED_PACKAGES = new String[]{"antlr", "cglib", "ch.quos.logback", "commons-codec", "commons-fileupload", "commons-io", "commons-logging", "com.fasterxml", "tools.jackson", "com.google", "com.h2database", "com.helger", "com.vaadin.external.atmosphere", "com.vaadin.webjar", "junit", "net.bytebuddy", "org.apache", "org.aspectj", "org.bouncycastle", "org.dom4j", "org.easymock", "org.eclipse.persistence", "org.hamcrest", "org.hibernate", "org.javassist", "org.jboss", "org.jsoup", "org.seleniumhq", "org.slf4j", "org.atmosphere", "org.springframework", "org.webjars.bowergithub", "org.yaml", "java.*", "javax.*", "javafx.*", "com.sun.*", "oracle.deploy", "oracle.javafx", "oracle.jrockit", "oracle.jvm", "oracle.net", "oracle.nio", "oracle.tools", "oracle.util", "oracle.webservices", "oracle.xmlns", "com.intellij.*", "org.jetbrains", "com.vaadin.external.gwt", "javassist.*", "io.methvin", "com.github.javaparser", "oshi.*", "io.micrometer", "jakarta.*", "com.nimbusds", "elemental.util", "org.reflections", "org.aopalliance", "org.objectweb"};
    private static final Logger LOGGER = LoggerFactory.getLogger(ReflectionsClassFinder.class);
    private final transient ClassLoader classLoader;
    private final transient Map<String, Set<String>> annotatedClassCache;
    private final transient Map<String, Set<String>> subtypeCache;
    private final transient Set<String> scannedPackages;

    public ReflectionsClassFinder(URL ... urls) {
        this(new URLClassLoader(urls, Thread.currentThread().getContextClassLoader()), urls);
    }

    public ReflectionsClassFinder(ClassLoader classLoader, URL ... urls) {
        int classCount;
        this.classLoader = classLoader;
        long startTime = System.currentTimeMillis();
        if (urls == null || urls.length == 0) {
            this.scannedPackages = Collections.emptySet();
            this.annotatedClassCache = Collections.emptyMap();
            this.subtypeCache = Collections.emptyMap();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("ClassFinder initialized with empty scan URLs: 0 classes scanned");
            }
            return;
        }
        ClassGraph classGraph = new ClassGraph().overrideClasspath((Object[])urls).addClassLoader(classLoader).enableClassInfo().enableAnnotationInfo().ignoreClassVisibility().filterClasspathElements(path -> !path.endsWith("module-info.class"));
        this.applyScannerPackageFilters(classGraph);
        if (VersionFinder.JAVA_MAJOR_VERSION < 24) {
            classGraph.enableMemoryMapping();
        }
        try (ScanResult scanResult = classGraph.scan();){
            ClassInfoList allClasses = scanResult.getAllClasses();
            classCount = allClasses.size();
            this.scannedPackages = allClasses.stream().map(classInfo -> ReflectionsClassFinder.extractPackageName(classInfo.getName())).filter(pkg -> !pkg.isEmpty()).collect(Collectors.toSet());
            this.annotatedClassCache = this.buildAnnotatedClassCache(allClasses);
            this.subtypeCache = this.buildSubtypeCache(allClasses);
        }
        long duration = System.currentTimeMillis() - startTime;
        LOGGER.info("ClassFinder initialized: {} urls, {} classes scanned, {} annotation types cached, {} subtype relationships cached, took {}ms", new Object[]{urls.length, classCount, this.annotatedClassCache.size(), this.subtypeCache.size(), duration});
    }

    public Set<Class<?>> getAnnotatedClasses(Class<? extends Annotation> clazz) {
        LinkedHashSet classes = new LinkedHashSet();
        Set classNames = this.annotatedClassCache.getOrDefault(clazz.getName(), Collections.emptySet());
        for (String className : classNames) {
            try {
                classes.add(this.classLoader.loadClass(className));
            }
            catch (Throwable e) {
                LOGGER.debug("Can't load class {}", (Object)className, (Object)e);
            }
        }
        classes.addAll(this.getAnnotatedByRepeatedAnnotation(clazz));
        return this.sortedByClassName(classes);
    }

    private Set<Class<?>> getAnnotatedByRepeatedAnnotation(AnnotatedElement annotationClass) {
        Repeatable repeatableAnnotation = annotationClass.getAnnotation(Repeatable.class);
        if (repeatableAnnotation != null) {
            LinkedHashSet classes = new LinkedHashSet();
            Set classNames = this.annotatedClassCache.getOrDefault(repeatableAnnotation.value().getName(), Collections.emptySet());
            for (String className : classNames) {
                try {
                    classes.add(this.classLoader.loadClass(className));
                }
                catch (Throwable e) {
                    LOGGER.debug("Can't load class {}", (Object)className, (Object)e);
                }
            }
            return classes;
        }
        return Collections.emptySet();
    }

    public URL getResource(String name) {
        return this.classLoader.getResource(name);
    }

    public boolean shouldInspectClass(String className) {
        String packageName = ReflectionsClassFinder.extractPackageName(className);
        if (this.scannedPackages.contains(packageName)) {
            return this.classLoader.getResource(className.replace('.', '/') + ".class") != null;
        }
        return false;
    }

    private static String extractPackageName(String className) {
        int dot = className.lastIndexOf(46);
        if (dot != -1) {
            return className.substring(0, dot);
        }
        return "";
    }

    public <T> Class<T> loadClass(String name) throws ClassNotFoundException {
        return this.classLoader.loadClass(name);
    }

    public <T> Set<Class<? extends T>> getSubTypesOf(Class<T> type) {
        Set subtypeNames = this.subtypeCache.getOrDefault(type.getName(), Collections.emptySet());
        LinkedHashSet<Class<T>> classes = new LinkedHashSet<Class<T>>();
        for (String className : subtypeNames) {
            try {
                Class<?> clazz = this.classLoader.loadClass(className);
                classes.add(clazz);
            }
            catch (Throwable e) {
                LOGGER.debug("Can't load class {}", (Object)className, (Object)e);
            }
        }
        return this.sortedByClassName(classes);
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    private <T> Set<Class<? extends T>> sortedByClassName(Set<Class<? extends T>> source) {
        return source.stream().sorted(Comparator.comparing(Class::getName)).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private Map<String, Set<String>> buildAnnotatedClassCache(ClassInfoList allClasses) {
        HashMap<String, Set<String>> cache = new HashMap<String, Set<String>>();
        for (ClassInfo classInfo : allClasses) {
            for (AnnotationInfo annotationInfo : classInfo.getAnnotationInfo()) {
                String annotationName = annotationInfo.getName();
                cache.computeIfAbsent(annotationName, k -> new LinkedHashSet()).add(classInfo.getName());
            }
        }
        return cache;
    }

    private Map<String, Set<String>> buildSubtypeCache(ClassInfoList allClasses) {
        HashMap<String, Set<String>> cache = new HashMap<String, Set<String>>();
        for (ClassInfo classInfo : allClasses) {
            String className = classInfo.getName();
            ClassInfoList superclasses = classInfo.getSuperclasses();
            for (ClassInfo superclass : superclasses) {
                cache.computeIfAbsent(superclass.getName(), k -> new LinkedHashSet()).add(className);
            }
            ClassInfoList interfaces = classInfo.getInterfaces();
            for (ClassInfo iface : interfaces) {
                cache.computeIfAbsent(iface.getName(), k -> new LinkedHashSet()).add(className);
            }
        }
        return cache;
    }

    private void applyScannerPackageFilters(ClassGraph classGraph) {
        if (!Boolean.getBoolean(DISABLE_DEFAULT_PACKAGE_FILTER)) {
            classGraph.rejectPackages(DEFAULT_REJECTED_PACKAGES);
        }
    }
}

