/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.plugin.base;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.vaadin.flow.di.Lookup;
import com.vaadin.flow.function.SerializableSupplier;
import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.flow.plugin.base.PluginAdapterBase;
import com.vaadin.flow.plugin.base.PluginAdapterBuild;
import com.vaadin.flow.server.ExecutionFailedException;
import com.vaadin.flow.server.frontend.FileIOUtils;
import com.vaadin.flow.server.frontend.FrontendTools;
import com.vaadin.flow.server.frontend.FrontendToolsSettings;
import com.vaadin.flow.server.frontend.FrontendUtils;
import com.vaadin.flow.server.frontend.NodeTasks;
import com.vaadin.flow.server.frontend.Options;
import com.vaadin.flow.server.frontend.ProdBundleUtils;
import com.vaadin.flow.server.frontend.scanner.ClassFinder;
import com.vaadin.flow.server.frontend.scanner.FrontendDependenciesScanner;
import com.vaadin.flow.server.scanner.ReflectionsClassFinder;
import com.vaadin.flow.utils.FlowFileUtils;
import com.vaadin.pro.licensechecker.BuildType;
import com.vaadin.pro.licensechecker.LicenseChecker;
import com.vaadin.pro.licensechecker.LicenseException;
import com.vaadin.pro.licensechecker.LocalSubscriptionKey;
import com.vaadin.pro.licensechecker.MissingLicenseKeyException;
import com.vaadin.pro.licensechecker.Product;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zeroturnaround.exec.InvalidExitValueException;
import org.zeroturnaround.exec.ProcessExecutor;

public class BuildFrontendUtil {
    private BuildFrontendUtil() {
    }

    public static ClassFinder getClassFinder(List<String> classpathElements) {
        URL[] urls = (URL[])classpathElements.stream().distinct().map(File::new).map(FlowFileUtils::convertToUrl).toArray(URL[]::new);
        return new ReflectionsClassFinder(urls);
    }

    public static File getTokenFile(PluginAdapterBase adapter) {
        return new File(adapter.servletResourceOutputDirectory(), "config/flow-build-info.json");
    }

    public static void prepareFrontend(PluginAdapterBase adapter) throws IOException, ExecutionFailedException, URISyntaxException {
        URI nodeDownloadRootURI = adapter.nodeDownloadRoot();
        FrontendToolsSettings settings = BuildFrontendUtil.getFrontendToolsSettings(adapter);
        FrontendTools tools = new FrontendTools(settings);
        tools.validateNodeAndNpmVersion();
        ClassFinder classFinder = adapter.getClassFinder();
        Lookup lookup = adapter.createLookup(classFinder);
        Options options = new Options(lookup, adapter.npmFolder()).withCleanOldGeneratedFiles(true).withFrontendHotdeploy(adapter.isFrontendHotdeploy()).withFrontendDirectory(BuildFrontendUtil.getFrontendDirectory(adapter)).withBuildDirectory(adapter.buildFolder()).withBuildResultFolders(adapter.frontendOutputDirectory(), adapter.servletResourceOutputDirectory()).withJarFrontendResourcesFolder(BuildFrontendUtil.getJarFrontendResourcesFolder(adapter)).createMissingPackageJson(true).enableImportsUpdate(false).enablePackagesUpdate(false).withRunNpmInstall(false).withFrontendGeneratedFolder(BuildFrontendUtil.getGeneratedFrontendDirectory(adapter)).withNodeVersion(adapter.nodeVersion()).withNodeDownloadRoot(nodeDownloadRootURI).setNodeAutoUpdate(adapter.nodeAutoUpdate()).withHomeNodeExecRequired(adapter.requireHomeNodeExec()).setJavaResourceFolder(adapter.javaResourceFolder()).withProductionMode(false).withReact(adapter.isReactEnabled()).withFrontendExtraFileExtensions(adapter.frontendExtraFileExtensions()).withNpmExcludeWebComponents(adapter.isNpmExcludeWebComponents()).withFrontendIgnoreVersionChecks(adapter.isFrontendIgnoreVersionChecks()).setCopyAssets(false);
        options.copyResources(adapter.getJarFiles());
        try {
            new NodeTasks(options).execute();
        }
        catch (ExecutionFailedException exception) {
            throw exception;
        }
        catch (Throwable throwable) {
            throw new ExecutionFailedException("Error occured during goal execution: " + throwable.getMessage() + "\n\nPlease run Maven with the -e switch (or Gradle with the --stacktrace switch), to learn the full stack trace.", throwable);
        }
    }

    private static File getJarFrontendResourcesFolder(PluginAdapterBase adapter) {
        return new File(new File(BuildFrontendUtil.getFrontendDirectory(adapter), "generated/"), "jar-resources");
    }

    private static FrontendToolsSettings getFrontendToolsSettings(PluginAdapterBase adapter) throws URISyntaxException {
        FrontendToolsSettings settings = new FrontendToolsSettings(adapter.npmFolder().getAbsolutePath(), (SerializableSupplier & Serializable)() -> FrontendUtils.getVaadinHomeDirectory().getAbsolutePath());
        settings.setNodeDownloadRoot(adapter.nodeDownloadRoot());
        settings.setNodeVersion(adapter.nodeVersion());
        settings.setAutoUpdate(adapter.nodeAutoUpdate());
        settings.setUseGlobalPnpm(adapter.useGlobalPnpm());
        settings.setForceAlternativeNode(adapter.requireHomeNodeExec());
        settings.setIgnoreVersionChecks(adapter.isFrontendIgnoreVersionChecks());
        return settings;
    }

    public static File propagateBuildInfo(PluginAdapterBase adapter) {
        File token = new File(adapter.servletResourceOutputDirectory(), "config/flow-build-info.json");
        ObjectNode buildInfo = JacksonUtils.createObjectNode();
        buildInfo.put("productionMode", false);
        buildInfo.put("eagerServerLoad", adapter.eagerServerLoad());
        buildInfo.put("npmFolder", adapter.npmFolder().getAbsolutePath());
        buildInfo.put("node.version", adapter.nodeVersion());
        if (adapter.isFrontendHotdeploy()) {
            buildInfo.put("frontend.hotdeploy", adapter.isFrontendHotdeploy());
        }
        try {
            buildInfo.put("node.download.root", adapter.nodeDownloadRoot().toString());
        }
        catch (URISyntaxException e) {
            LoggerFactory.getLogger((String)"BuildInfo").error("Configuration 'nodeDownloadRoot'  (property 'node.download.root') is defined incorrectly", (Throwable)e);
        }
        buildInfo.put("frontendFolder", BuildFrontendUtil.getFrontendDirectory(adapter).getAbsolutePath());
        buildInfo.put("connect.javaSourceFolder", adapter.javaSourceFolder().getAbsolutePath());
        buildInfo.put("javaResourceFolder", adapter.javaResourceFolder().getAbsolutePath());
        buildInfo.put("connect.applicationProperties", adapter.applicationProperties().getAbsolutePath());
        buildInfo.put("connect.openApiFile", adapter.openApiJsonFile().getAbsolutePath());
        buildInfo.put("project.frontend.generated", BuildFrontendUtil.getGeneratedFrontendDirectory(adapter).getAbsolutePath());
        buildInfo.put("pnpm.enable", adapter.pnpmEnable());
        buildInfo.put("bun.enable", adapter.bunEnable());
        buildInfo.put("require.home.node", adapter.requireHomeNodeExec());
        buildInfo.put("build.folder", adapter.buildFolder());
        if (adapter.isPrepareFrontendCacheDisabled()) {
            buildInfo.put("disable.prepare.frontend.cache", true);
        }
        buildInfo.put("react.enable", adapter.isReactEnabled());
        if (adapter.isNpmExcludeWebComponents()) {
            buildInfo.put("npm.excludeWebComponents", adapter.isNpmExcludeWebComponents());
        }
        if (!adapter.frontendExtraFileExtensions().isEmpty()) {
            buildInfo.put("devmode.frontendExtraFileExtensions", adapter.frontendExtraFileExtensions().stream().collect(Collectors.joining(",")));
        }
        try {
            FileUtils.forceMkdir((File)token.getParentFile());
            FileIOUtils.writeIfChanged((File)token, (String)(buildInfo.toPrettyString() + "\n"));
            if (adapter.isDebugEnabled()) {
                adapter.logDebug(String.format("%n>>> Running prepare-frontend%nSystem.properties:%n project.basedir: %s%nGoal parameters:%n npmFolder: %s%nToken file: %s%nToken content: %s%n", adapter.projectBaseDirectory(), adapter.npmFolder(), token.getAbsolutePath(), buildInfo));
            }
            return token;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void runNodeUpdater(PluginAdapterBuild adapter, FrontendDependenciesScanner frontendDependencies) throws ExecutionFailedException, URISyntaxException {
        Set<File> jarFiles = adapter.getJarFiles();
        URI nodeDownloadRootURI = adapter.nodeDownloadRoot();
        ClassFinder classFinder = adapter.getClassFinder();
        Lookup lookup = adapter.createLookup(classFinder);
        try {
            Options options = new Options(lookup, adapter.npmFolder()).withFrontendDirectory(BuildFrontendUtil.getFrontendDirectory(adapter)).withBuildDirectory(adapter.buildFolder()).withRunNpmInstall(adapter.runNpmInstall()).withBuildResultFolders(adapter.frontendOutputDirectory(), adapter.servletResourceOutputDirectory()).enablePackagesUpdate(true).useByteCodeScanner(adapter.optimizeBundle()).withJarFrontendResourcesFolder(BuildFrontendUtil.getJarFrontendResourcesFolder(adapter)).copyResources(jarFiles).withCopyTemplates(true).copyLocalResources(adapter.frontendResourcesDirectory()).enableImportsUpdate(true).withEmbeddableWebComponents(adapter.generateEmbeddableWebComponents()).withTokenFile(BuildFrontendUtil.getTokenFile(adapter)).withEnablePnpm(adapter.pnpmEnable()).withEnableBun(adapter.bunEnable()).useGlobalPnpm(adapter.useGlobalPnpm()).withFrontendGeneratedFolder(BuildFrontendUtil.getGeneratedFrontendDirectory(adapter)).withHomeNodeExecRequired(adapter.requireHomeNodeExec()).withNodeVersion(adapter.nodeVersion()).withNodeDownloadRoot(nodeDownloadRootURI).setNodeAutoUpdate(adapter.nodeAutoUpdate()).setJavaResourceFolder(adapter.javaResourceFolder()).withPostinstallPackages(adapter.postinstallPackages()).withCiBuild(adapter.ciBuild()).withForceProductionBuild(adapter.forceProductionBuild()).withReact(adapter.isReactEnabled()).withNpmExcludeWebComponents(adapter.isNpmExcludeWebComponents()).withFrontendExtraFileExtensions(adapter.frontendExtraFileExtensions()).withFrontendIgnoreVersionChecks(adapter.isFrontendIgnoreVersionChecks()).withFrontendDependenciesScanner(frontendDependencies).withCommercialBanner(adapter.isCommercialBannerEnabled());
            new NodeTasks(options).execute();
        }
        catch (ExecutionFailedException exception) {
            throw exception;
        }
        catch (Throwable throwable) {
            throw new ExecutionFailedException("Error occured during goal execution: " + throwable.getMessage() + "Please run Maven with the -e switch (or Gradle with the --stacktrace switch), to learn the full stack trace.", throwable);
        }
    }

    public static void runDevBuildNodeUpdater(PluginAdapterBuild adapter) throws ExecutionFailedException, URISyntaxException, IOException {
        Set<File> jarFiles = adapter.getJarFiles();
        URI nodeDownloadRootURI = adapter.nodeDownloadRoot();
        ClassFinder classFinder = adapter.getClassFinder();
        Lookup lookup = adapter.createLookup(classFinder);
        try {
            Options options = new Options(lookup, adapter.npmFolder()).withProductionMode(false).withFrontendDirectory(BuildFrontendUtil.getFrontendDirectory(adapter)).withBuildDirectory(adapter.buildFolder()).withRunNpmInstall(adapter.runNpmInstall()).withBuildResultFolders(adapter.frontendOutputDirectory(), adapter.servletResourceOutputDirectory()).enablePackagesUpdate(true).useByteCodeScanner(false).withJarFrontendResourcesFolder(BuildFrontendUtil.getJarFrontendResourcesFolder(adapter)).copyResources(jarFiles).withCopyTemplates(true).copyLocalResources(adapter.frontendResourcesDirectory()).enableImportsUpdate(true).withEmbeddableWebComponents(adapter.generateEmbeddableWebComponents()).withTokenFile(BuildFrontendUtil.getTokenFile(adapter)).withEnablePnpm(adapter.pnpmEnable()).withEnableBun(adapter.bunEnable()).useGlobalPnpm(adapter.useGlobalPnpm()).withFrontendGeneratedFolder(BuildFrontendUtil.getGeneratedFrontendDirectory(adapter)).withHomeNodeExecRequired(adapter.requireHomeNodeExec()).withNodeVersion(adapter.nodeVersion()).withNodeDownloadRoot(nodeDownloadRootURI).setNodeAutoUpdate(adapter.nodeAutoUpdate()).setJavaResourceFolder(adapter.javaResourceFolder()).withPostinstallPackages(adapter.postinstallPackages()).withBundleBuild(true).skipDevBundleBuild(adapter.skipDevBundleBuild()).withCompressBundle(adapter.compressBundle()).withReact(adapter.isReactEnabled()).withFrontendExtraFileExtensions(adapter.frontendExtraFileExtensions()).withNpmExcludeWebComponents(adapter.isNpmExcludeWebComponents()).withFrontendIgnoreVersionChecks(adapter.isFrontendIgnoreVersionChecks());
            new NodeTasks(options).execute();
        }
        catch (ExecutionFailedException exception) {
            throw exception;
        }
        catch (Throwable throwable) {
            throw new ExecutionFailedException("Error occured during goal execution: " + throwable.getMessage() + "Please run Maven with the -e switch (or Gradle with the --stacktrace switch), to learn the full stack trace.", throwable);
        }
    }

    public static File getFrontendDirectory(PluginAdapterBase adapter) {
        return FrontendUtils.getFrontendFolder((File)adapter.npmFolder(), (File)adapter.frontendDirectory());
    }

    public static File getGeneratedFrontendDirectory(PluginAdapterBase adapter) {
        if (adapter.generatedTsFolder().toPath().startsWith(adapter.frontendDirectory().toPath())) {
            File frontendDirectory = BuildFrontendUtil.getFrontendDirectory(adapter);
            return new File(frontendDirectory, "generated/");
        }
        return adapter.generatedTsFolder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runFrontendBuild(PluginAdapterBase adapter) throws TimeoutException, URISyntaxException {
        LicenseChecker.setStrictOffline((boolean)true);
        FrontendToolsSettings settings = BuildFrontendUtil.getFrontendToolsSettings(adapter);
        FrontendTools tools = new FrontendTools(settings);
        tools.validateNodeAndNpmVersion();
        BuildFrontendUtil.runVite(adapter, tools);
        String tokenContent = "";
        File tokenFile = BuildFrontendUtil.getTokenFile(adapter);
        try {
            tokenContent = Files.readString(tokenFile.toPath());
            tokenFile.delete();
        }
        catch (IOException ex) {
            BuildFrontendUtil.getLogger().error("Failed to read token file content.", (Throwable)ex);
        }
        try {
            ProdBundleUtils.compressBundle((File)adapter.projectBaseDirectory().toFile(), (File)adapter.servletResourceOutputDirectory());
        }
        finally {
            try {
                Files.writeString(tokenFile.toPath(), (CharSequence)tokenContent, new OpenOption[0]);
            }
            catch (IOException ex) {
                BuildFrontendUtil.getLogger().error("Failed to write token file content.", (Throwable)ex);
            }
        }
    }

    public static void runVite(PluginAdapterBase adapter, FrontendTools frontendTools) throws TimeoutException {
        BuildFrontendUtil.runFrontendBuildTool(adapter, frontendTools, "Vite", "vite", "vite", Collections.emptyMap(), "build");
    }

    private static void runFrontendBuildTool(PluginAdapterBase adapter, FrontendTools frontendTools, String toolName, String packageName, String binaryName, Map<String, String> environment, String ... params) throws TimeoutException {
        File buildExecutable;
        try {
            buildExecutable = frontendTools.getNpmPackageExecutable(packageName, binaryName, adapter.npmFolder()).toFile();
        }
        catch (FrontendUtils.CommandExecutionException e) {
            throw new IllegalStateException(String.format("Unable to locate %s executable. Expected the \"%s\" npm package to be installed and to provide the \"%s\" binary. Double check that the npm dependencies are installed.", toolName, packageName, binaryName));
        }
        if (!buildExecutable.isFile()) {
            throw new IllegalStateException(String.format("Unable to locate %s executable by path '%s'. Double check that the plugin is executed correctly", toolName, buildExecutable.getAbsolutePath()));
        }
        String nodePath = adapter.requireHomeNodeExec() ? frontendTools.forceAlternativeNodeExecutable() : frontendTools.getNodeExecutable();
        ArrayList<String> command = new ArrayList<String>();
        command.add(nodePath);
        command.add(buildExecutable.getAbsolutePath());
        command.addAll(Arrays.asList(params));
        ProcessBuilder builder = FrontendUtils.createProcessBuilder(command);
        ProcessExecutor processExecutor = new ProcessExecutor().command(builder.command()).environment(builder.environment()).environment(environment).directory(adapter.projectBaseDirectory().toFile());
        adapter.logInfo("Running " + toolName + " ...");
        if (adapter.isDebugEnabled()) {
            adapter.logDebug(FrontendUtils.commandToString((String)adapter.npmFolder().getAbsolutePath(), command));
        }
        try {
            processExecutor.exitValueNormal().readOutput(true).destroyOnExit().execute();
        }
        catch (InvalidExitValueException e) {
            throw new IllegalStateException(String.format("%s process exited with non-zero exit code.%nStderr: '%s'", toolName, e.getResult().outputUTF8()), e);
        }
        catch (IOException | InterruptedException e) {
            throw new IllegalStateException(String.format("Failed to run %s due to an error", toolName), e);
        }
    }

    public static boolean validateLicenses(PluginAdapterBase adapter, FrontendDependenciesScanner frontendDependencies) {
        File outputFolder = adapter.frontendOutputDirectory();
        String statsJsonContent = null;
        try {
            File statsFile = new File(adapter.servletResourceOutputDirectory(), "config//stats.json");
            statsJsonContent = !statsFile.exists() ? ProdBundleUtils.findBundleStatsJson((File)adapter.projectBaseDirectory().toFile(), (ClassFinder)adapter.getClassFinder()) : IOUtils.toString((URL)statsFile.toURI().toURL(), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (statsJsonContent == null) {
            BuildFrontendUtil.getLogger().debug("No production bundle stats.json available for licenses validation.");
            statsJsonContent = "{}";
        }
        List<Product> commercialComponents = BuildFrontendUtil.findCommercialFrontendComponents(frontendDependencies, statsJsonContent);
        commercialComponents.addAll(BuildFrontendUtil.findCommercialJavaComponents(adapter));
        for (Product component : commercialComponents) {
            try {
                LicenseChecker.checkLicense((String)component.getName(), (String)component.getVersion(), (BuildType)BuildType.PRODUCTION, null);
            }
            catch (MissingLicenseKeyException ex) {
                String productsList = commercialComponents.stream().map(product -> "* " + product.getName()).collect(Collectors.joining(System.lineSeparator()));
                if (adapter.isCommercialBannerEnabled()) {
                    throw new MissingLicenseKeyException("The application contains the unlicensed components listed below and is displaying a commercial banner.\n%1$s\n\nGo to https://vaadin.com/pricing to obtain a license\n".formatted(productsList));
                }
                BuildFrontendUtil.invalidateOutput(component, outputFolder);
                throw new LicenseException(String.format("Commercial features require a subscription.\nYour application contains the following commercial components and no license was found:\n%1$s\n\nIf you have an active subscription, please download the license key from https://vaadin.com/myaccount/licenses.\nOtherwise go to https://vaadin.com/pricing to obtain a license.\n\nYou can also build a watermarked version of the application configuring\nthe '%2$s' property of the Maven or Gradle plugin\nor run the build with the '-Dvaadin.%2$s' system parameter\n", productsList, "commercialWithBanner"));
            }
            catch (Exception e) {
                BuildFrontendUtil.invalidateOutput(component, outputFolder);
                throw e;
            }
        }
        return !commercialComponents.isEmpty();
    }

    private static void invalidateOutput(Product component, File outputFolder) {
        try {
            BuildFrontendUtil.getLogger().debug("License check for {} failed. Invalidating output", (Object)component);
            FileUtils.deleteDirectory((File)outputFolder);
        }
        catch (IOException e) {
            BuildFrontendUtil.getLogger().debug("Failed to remove {}", (Object)outputFolder);
        }
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(BuildFrontendUtil.class);
    }

    static List<Product> findCommercialFrontendComponents(FrontendDependenciesScanner scanner, String statsJsonContent) {
        ArrayList<Product> components = new ArrayList<Product>();
        ObjectNode statsJson = JacksonUtils.readTree((String)statsJsonContent);
        Set<String> usedPackages = BuildFrontendUtil.getUsedPackages(scanner);
        if (statsJson.has("cvdlModules")) {
            JsonNode cvdlModules = statsJson.get("cvdlModules");
            for (String key : JacksonUtils.getKeys((JsonNode)cvdlModules)) {
                if (!usedPackages.contains(key)) continue;
                JsonNode cvdlModule = cvdlModules.get(key);
                components.add(new Product(cvdlModule.get("name").textValue(), cvdlModule.get("version").textValue()));
            }
        }
        return components;
    }

    private static Set<String> getUsedPackages(FrontendDependenciesScanner scanner) {
        HashSet<String> usedPackages = new HashSet<String>();
        Set npmPackages = scanner.getPackages().keySet();
        HashSet jsAndCssImports = new HashSet();
        for (List modules : scanner.getModules().values()) {
            jsAndCssImports.addAll(modules);
        }
        for (List scripts : scanner.getScripts().values()) {
            jsAndCssImports.addAll(scripts);
        }
        for (String importPath : jsAndCssImports) {
            if (importPath.startsWith(".") || !importPath.contains("/")) continue;
            String[] parts = importPath.split("/");
            String potentialBasicPackage = parts[0];
            String potentialOrgPackage = parts[0] + "/" + parts[1];
            if (npmPackages.contains(potentialOrgPackage)) {
                usedPackages.add(potentialOrgPackage);
                continue;
            }
            if (npmPackages.contains(potentialBasicPackage)) {
                usedPackages.add(potentialBasicPackage);
                continue;
            }
            BuildFrontendUtil.getLogger().debug("Import from an unknown package: " + importPath);
        }
        return usedPackages;
    }

    static List<Product> findCommercialJavaComponents(PluginAdapterBase adapter) {
        ArrayList<Product> components = new ArrayList<Product>();
        for (File f : adapter.getJarFiles()) {
            try (JarFile jarFile = new JarFile(f);){
                String cvdlName;
                Attributes attributes;
                Manifest manifest = jarFile.getManifest();
                if (manifest == null || (attributes = manifest.getMainAttributes()) == null || (cvdlName = attributes.getValue("CvdlName")) == null) continue;
                String version = attributes.getValue("Implementation-Version");
                if (version == null) {
                    version = attributes.getValue("Bundle-Version");
                }
                Product p = new Product(cvdlName, version);
                components.add(p);
            }
            catch (IOException e) {
                BuildFrontendUtil.getLogger().debug("Error reading manifest for jar " + f, (Throwable)e);
            }
        }
        return components;
    }

    @Deprecated(since="24.9", forRemoval=true)
    public static void updateBuildFile(PluginAdapterBuild adapter, boolean licenseRequired) {
        BuildFrontendUtil.updateBuildFile(adapter, licenseRequired, false);
    }

    public static void updateBuildFile(PluginAdapterBuild adapter, boolean licenseRequired, boolean needsCommercialBanner) {
        if (needsCommercialBanner && !adapter.isCommercialBannerEnabled()) {
            throw new IllegalStateException("Commercial banner is required for this build but has not been enabled in the Maven or Gradle plugin configuration. This should never happen and is caused by a bug in the Vaadin plugin. Please report the error at https://github.com/vaadin/flow/issues. As a workaround, enable the commercial banner setting in the plugin configuration.");
        }
        File tokenFile = BuildFrontendUtil.getTokenFile(adapter);
        if (!tokenFile.exists()) {
            adapter.logWarn("Couldn't update devMode token due to missing token file.");
            return;
        }
        try {
            boolean applyCommercialBanner;
            String json = FileUtils.readFileToString((File)tokenFile, (String)StandardCharsets.UTF_8.name());
            ObjectNode buildInfo = JacksonUtils.readTree((String)json);
            buildInfo.remove("npmFolder");
            buildInfo.remove("node.version");
            buildInfo.remove("node.download.root");
            buildInfo.remove("frontendFolder");
            buildInfo.remove("frontend.hotdeploy");
            buildInfo.remove("devmode.frontendExtraFileExtensions");
            buildInfo.remove("pnpm.enable");
            buildInfo.remove("bun.enable");
            buildInfo.remove("vaadin.ci.build");
            buildInfo.remove("require.home.node");
            buildInfo.remove("devmode.optimizeBundle");
            buildInfo.remove("connect.javaSourceFolder");
            buildInfo.remove("javaResourceFolder");
            buildInfo.remove("connect.applicationProperties");
            buildInfo.remove("connect.openApiFile");
            buildInfo.remove("project.frontend.generated");
            buildInfo.remove("build.folder");
            buildInfo.remove("npm.excludeWebComponents");
            buildInfo.remove("premiumFeatures.enable");
            buildInfo.remove("dau.enable");
            buildInfo.remove("commercialBanner.enable");
            buildInfo.put("productionMode", true);
            buildInfo.put("applicationIdentifier", adapter.applicationIdentifier());
            boolean bl = applyCommercialBanner = needsCommercialBanner && adapter.isCommercialBannerEnabled();
            if (licenseRequired) {
                if (LocalSubscriptionKey.get() != null) {
                    adapter.logInfo("Daily Active User tracking enabled");
                    buildInfo.put("dau.enable", true);
                    BuildFrontendUtil.checkLicenseCheckerAtRuntime(adapter);
                }
                if (applyCommercialBanner) {
                    adapter.logInfo("Application commercial banner enabled");
                    buildInfo.put("commercialBanner.enable", true);
                }
            }
            if (BuildFrontendUtil.isControlCenterAvailable(adapter.getClassFinder()) && (applyCommercialBanner || LicenseChecker.isValidLicense((String)"vaadin-commercial-cc-client", null, (BuildType)BuildType.PRODUCTION))) {
                adapter.logInfo("Premium Features are enabled");
                buildInfo.put("premiumFeatures.enable", true);
            }
            FileUtils.write((File)tokenFile, (CharSequence)(buildInfo.toPrettyString() + "\n"), (String)StandardCharsets.UTF_8.name());
            tokenFile.deleteOnExit();
        }
        catch (IOException e) {
            adapter.logWarn("Unable to read token file", e);
        }
    }

    private static boolean isControlCenterAvailable(ClassFinder classFinder) {
        if (classFinder == null) {
            return false;
        }
        try {
            classFinder.loadClass("com.vaadin.controlcenter.starter.actuate.endpoint.VaadinActuatorEndpoint");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private static void checkLicenseCheckerAtRuntime(PluginAdapterBuild adapter) {
        adapter.checkRuntimeDependency("com.vaadin", "license-checker", logMessage -> adapter.logWarn("Vaadin Subscription used to build the application requires\nthe artifact com.vaadin:license-checker to be present at runtime.\n\n" + logMessage));
    }

    public static void removeBuildFile(PluginAdapterBuild adapter) throws IOException {
        File tokenFile = BuildFrontendUtil.getTokenFile(adapter);
        if (tokenFile.exists()) {
            FileUtils.delete((File)tokenFile);
        }
    }
}

