/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.osgi.support;

import com.vaadin.flow.di.Lookup;
import com.vaadin.flow.internal.ApplicationClassLoaderAccess;
import com.vaadin.flow.internal.VaadinContextInitializer;
import com.vaadin.flow.osgi.support.OSGiVaadinInitialization;
import com.vaadin.flow.osgi.support.ServletContainerInitializerClasses;
import com.vaadin.flow.osgi.support.ServletInitializationRequirements;
import com.vaadin.flow.server.AbstractConfiguration;
import com.vaadin.flow.server.HandlerHelper;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinServlet;
import com.vaadin.flow.server.VaadinServletContext;
import com.vaadin.flow.server.startup.ApplicationConfiguration;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.launch.Framework;
import org.osgi.service.http.context.ServletContextHelper;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.LoggerFactory;

class ServletInitRequirementsTracker
extends ServiceTracker<ServletInitializationRequirements, ServletInitializationRequirements>
implements BundleListener {
    private final Bundle webAppBundle;
    private final VaadinServletContext servletContext;
    private final ServletContainerInitializerClasses initializerClasses;

    ServletInitRequirementsTracker(Bundle webAppBundle, VaadinServletContext context, ServletContainerInitializerClasses initializerClasses) {
        super(webAppBundle.getBundleContext(), ServletInitializationRequirements.class, null);
        this.webAppBundle = webAppBundle;
        this.servletContext = context;
        this.initializerClasses = initializerClasses;
        webAppBundle.getBundleContext().addBundleListener((BundleListener)this);
    }

    public ServletInitializationRequirements addingService(ServiceReference<ServletInitializationRequirements> reference) {
        ServletInitializationRequirements requirements = (ServletInitializationRequirements)super.addingService(reference);
        ServletInitRequirementsTracker tracker = (ServletInitRequirementsTracker)((Object)this.servletContext.getAttribute(ServletInitRequirementsTracker.class));
        if (tracker != null) {
            this.stop();
            this.servletContext.removeAttribute(ServletInitRequirementsTracker.class);
        }
        this.initializeLookup();
        return requirements;
    }

    private boolean isFrameworkStarted() {
        Optional<Bundle> framework = Stream.of(this.context.getBundles()).filter(bundle -> Framework.class.isAssignableFrom(bundle.getClass())).findFirst();
        if (framework.isPresent()) {
            return (0x20 & framework.get().getState()) > 0;
        }
        return false;
    }

    public void bundleChanged(BundleEvent event) {
        if ((event.getType() & 4) != 0) {
            this.stop();
        }
    }

    private void stop() {
        this.close();
        this.context.removeBundleListener((BundleListener)this);
    }

    private void initializeLookup() {
        Lookup[] created = new Lookup[1];
        Lookup lookup = (Lookup)this.servletContext.getAttribute(Lookup.class, () -> {
            OsgiLookupImpl result = new OsgiLookupImpl(this.webAppBundle, this.servletContext);
            created[0] = result;
            return result;
        });
        if (lookup == null) {
            throw new IllegalStateException(VaadinContextInitializer.class.getSimpleName() + " has been executed but there is no " + ApplicationClassLoaderAccess.class.getSimpleName() + " instance available");
        }
        if (created[0] != lookup) {
            return;
        }
        if (this.isFrameworkStarted()) {
            this.registerResoures((VaadinContext)this.servletContext);
        } else {
            FrameworkListener listener = new FrameworkListener(){

                public void frameworkEvent(FrameworkEvent event) {
                    if (ServletInitRequirementsTracker.this.isFrameworkStarted()) {
                        ServletInitRequirementsTracker.this.registerResoures((VaadinContext)ServletInitRequirementsTracker.this.servletContext);
                        ServletInitRequirementsTracker.this.context.removeFrameworkListener((FrameworkListener)this);
                    }
                }
            };
            this.context.addFrameworkListener(listener);
        }
        OSGiVaadinInitialization.checkLicense((AbstractConfiguration)ApplicationConfiguration.get((VaadinContext)this.servletContext));
        this.getRegisteredVaadinServlets().stream().filter(this::isUninitializedServlet).forEach(servlet -> this.handleUninitializedServlet(lookup, (Servlet)servlet));
        this.initializerClasses.addContext(this.servletContext.getContext());
    }

    private Collection<VaadinServlet> getRegisteredVaadinServlets() {
        HashSet<VaadinServlet> result;
        block2: {
            result = new HashSet<VaadinServlet>();
            try {
                Stream.of(this.context.getAllServiceReferences(Servlet.class.getName(), null)).forEach(reference -> this.collectVaadinServlets((Set<VaadinServlet>)result, (ServiceReference<?>)reference));
            }
            catch (InvalidSyntaxException e) {
                LoggerFactory.getLogger(ServletInitRequirementsTracker.class).error("Unexpected invalid filter expression", (Throwable)e);
                if ($assertionsDisabled) break block2;
                throw new AssertionError((Object)"Implementation error: Unexpected invalid filter exception is thrown even though the service filter is null. Check the exception and update the impl");
            }
        }
        return result;
    }

    private void collectVaadinServlets(Set<VaadinServlet> servlets, ServiceReference<?> reference) {
        Bundle[] bundles = reference.getUsingBundles();
        if (bundles == null) {
            return;
        }
        Stream.of(bundles).map(bundle -> bundle.getBundleContext().getService(reference)).filter(VaadinServlet.class::isInstance).map(VaadinServlet.class::cast).forEach(servlets::add);
    }

    private void handleUninitializedServlet(Lookup lookup, Servlet servlet) {
        ServletContext ctx = servlet.getServletConfig().getServletContext();
        if (new VaadinServletContext(ctx).getAttribute(Lookup.class) != lookup) {
            return;
        }
        try {
            servlet.init(servlet.getServletConfig());
        }
        catch (ServletException e) {
            LoggerFactory.getLogger(OSGiVaadinInitialization.class).error("Couldn't initialize {} {}", new Object[]{VaadinServlet.class.getSimpleName(), servlet.getClass().getName(), e});
        }
    }

    private boolean isUninitializedServlet(VaadinServlet servlet) {
        return servlet.getServletConfig() != null && servlet.getService() == null;
    }

    private void registerResoures(VaadinContext context) {
        String contextPath = ((VaadinServletContext)context).getContext().getContextPath();
        if (contextPath.isEmpty()) {
            contextPath = "/";
        }
        this.registerPushResources(contextPath);
    }

    private void registerPushResources(String contextPath) {
        PushResourceBundleTracker resourceBoundleTracker = new PushResourceBundleTracker(this.webAppBundle, contextPath);
        resourceBoundleTracker.open();
    }

    static class OsgiLookupImpl
    implements Lookup {
        private final VaadinServletContext context;
        private final Bundle webAppBundle;

        private OsgiLookupImpl(Bundle webAppBundle, VaadinServletContext context) {
            this.webAppBundle = webAppBundle;
            this.context = context;
        }

        public <T> T lookup(Class<T> serviceClass) {
            ServiceReference reference = this.getWebAppBundle().getBundleContext().getServiceReference(serviceClass);
            if (reference == null) {
                LoggerFactory.getLogger(OsgiLookupImpl.class).debug("No service found for '{}' SPI", serviceClass);
                return null;
            }
            return (T)this.getWebAppBundle().getBundleContext().getService(reference);
        }

        public <T> Collection<T> lookupAll(Class<T> serviceClass) {
            Bundle bundle = this.getWebAppBundle();
            try {
                Collection references = bundle.getBundleContext().getServiceReferences(serviceClass, null);
                ArrayList<Object> services = new ArrayList<Object>(references.size());
                for (ServiceReference reference : references) {
                    Object service = bundle.getBundleContext().getService(reference);
                    if (service == null) continue;
                    services.add(service);
                }
                return services;
            }
            catch (InvalidSyntaxException e) {
                LoggerFactory.getLogger(ServletInitRequirementsTracker.class).error("Unexpected invalid filter expression", (Throwable)e);
                assert (false) : "Implementation error: Unexpected invalid filter exception is thrown even though the service filter is null. Check the exception and update the impl";
                return Collections.emptyList();
            }
        }

        private Bundle getWebAppBundle() {
            return this.webAppBundle;
        }
    }

    private static class PushResourceBundleTracker
    extends ResourceBundleTracker {
        private PushResourceBundleTracker(Bundle webAppBundle, String contextPath) {
            super(webAppBundle, "com.vaadin.flow.push", contextPath);
        }

        @Override
        protected String getResourceURI() {
            return "/VAADIN/static/push/*";
        }

        @Override
        protected String getResourcePath() {
            return "/META-INF/resources/VAADIN/static/push";
        }
    }

    private static abstract class ResourceBundleTracker
    extends BundleTracker<Bundle>
    implements BundleListener {
        private final String symbolicName;
        private final String contextPath;
        private ServiceRegistration<Servlet> resourceRegistration;
        private ServiceListener contextHelperListener;
        private WeakReference<Bundle> resourceBundle;

        private ResourceBundleTracker(Bundle webAppBundle, String symbolicName, String contextPath) {
            super(webAppBundle.getBundleContext(), 36, null);
            this.contextPath = contextPath;
            this.symbolicName = symbolicName;
            webAppBundle.getBundleContext().addBundleListener((BundleListener)this);
        }

        public Bundle addingBundle(Bundle bundle, BundleEvent event) {
            Bundle result = (Bundle)super.addingBundle(bundle, event);
            if ((bundle.getState() & 0x20) != 0 && this.symbolicName.equals(bundle.getSymbolicName())) {
                this.resourceBundle = new WeakReference<Bundle>(bundle);
                this.registerResource(bundle);
            }
            return result;
        }

        public void bundleChanged(BundleEvent event) {
            if ((event.getType() & 4) != 0 && event.getBundle().getBundleId() == this.context.getBundle().getBundleId()) {
                this.stop();
            }
        }

        protected abstract String getResourceURI();

        protected abstract String getResourcePath();

        private void stop() {
            this.close();
            this.context.removeBundleListener((BundleListener)this);
            Bundle bundle = (Bundle)this.resourceBundle.get();
            if (bundle == null) {
                return;
            }
            if (this.contextHelperListener != null) {
                bundle.getBundleContext().removeServiceListener(this.contextHelperListener);
            }
            if (this.resourceRegistration != null && bundle.getRegisteredServices().length > 0) {
                this.resourceRegistration.unregister();
            }
        }

        private void registerResource(Bundle bundle) {
            Hashtable<String, Object> properties = new Hashtable<String, Object>();
            ((Dictionary)properties).put("osgi.http.whiteboard.servlet.pattern", this.getResourceURI());
            String contextName = this.getContextName();
            if (contextName != null) {
                ((Dictionary)properties).put("osgi.http.whiteboard.context.select", "(osgi.http.whiteboard.context.name=" + contextName + ")");
            }
            this.resourceRegistration = bundle.getBundleContext().registerService(Servlet.class, (Object)new ResourceServlet(bundle, this.getResourcePath()), properties);
        }

        private String getContextName() {
            if ("/".equals(this.contextPath)) {
                return null;
            }
            try {
                ServiceReference[] references = this.context.getAllServiceReferences(ServletContextHelper.class.getName(), null);
                if (references == null) {
                    this.reportEmptyContextHelpers();
                    return null;
                }
                Map<Long, ServiceReference<?>> matchedReferences = this.filterReferencesByContextPath(references);
                if (matchedReferences.isEmpty()) {
                    this.reportEmptyContextHelpers();
                    return null;
                }
                if (matchedReferences.size() == 1) {
                    return this.getContextNameProperty(matchedReferences.values().iterator().next());
                }
                ServiceReference<?> reference = matchedReferences.get(this.context.getBundle().getBundleId());
                if (reference == null) {
                    reference = matchedReferences.values().iterator().next();
                    this.trackContextHelperReferences(reference);
                }
                return this.getContextNameProperty(reference);
            }
            catch (InvalidSyntaxException exception) {
                LoggerFactory.getLogger(OSGiVaadinInitialization.class).error("Couldn't get all {} services to find the context name", ServletContextHelper.class);
                return null;
            }
        }

        private void reportEmptyContextHelpers() {
            if (!"/".equals(this.contextPath)) {
                LoggerFactory.getLogger(ResourceBundleTracker.class).error("No {} services found matched context path '{}'", (Object)ServletContextHelper.class.getSimpleName(), (Object)this.contextPath);
            }
        }

        private void trackContextHelperReferences(ServiceReference<?> reference) {
            LoggerFactory.getLogger(ResourceBundleTracker.class).debug("Found several {} services matched context path '{}'. The first one is used to register a resource and it's tracked for changes.", (Object)ServletContextHelper.class.getSimpleName(), (Object)this.contextPath);
            this.contextHelperListener = event -> {
                if (reference.equals(event.getServiceReference()) && event.getType() != 1) {
                    if (this.contextHelperListener != null) {
                        reference.getBundle().getBundleContext().removeServiceListener(this.contextHelperListener);
                        this.contextHelperListener = null;
                    }
                    if (this.resourceRegistration != null) {
                        Bundle bundle = this.resourceRegistration.getReference().getBundle();
                        this.resourceRegistration.unregister();
                        this.registerResource(bundle);
                    }
                }
            };
            reference.getBundle().getBundleContext().addServiceListener(this.contextHelperListener);
        }

        private String getContextNameProperty(ServiceReference<?> reference) {
            return reference.getProperty("osgi.http.whiteboard.context.name").toString();
        }

        private Map<Long, ServiceReference<?>> filterReferencesByContextPath(ServiceReference<?>[] references) {
            HashMap matchedReferences = new HashMap();
            for (ServiceReference<?> reference : references) {
                Object path;
                Bundle[] usingBundles = reference.getUsingBundles();
                if (usingBundles == null || usingBundles.length <= 0 || !this.contextPath.equals(path = reference.getProperty("osgi.http.whiteboard.context.path"))) continue;
                matchedReferences.put(reference.getBundle().getBundleId(), reference);
            }
            return matchedReferences;
        }
    }

    private static class ResourceServlet
    extends HttpServlet {
        private final Bundle bundle;
        private final String path;

        private ResourceServlet(Bundle bundle, String path) {
            this.bundle = bundle;
            this.path = path;
        }

        protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            String pathInfo = req.getPathInfo();
            if (pathInfo == null) {
                resp.setStatus(404);
                return;
            }
            if (HandlerHelper.isPathUnsafe((String)pathInfo)) {
                resp.setStatus(403);
                return;
            }
            URL resource = this.bundle.getResource(this.path + pathInfo);
            if (resource == null) {
                resp.setStatus(404);
                return;
            }
            try (InputStream stream = resource.openStream();){
                IOUtils.copy((InputStream)stream, (OutputStream)resp.getOutputStream());
            }
        }
    }
}

