/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.osgi.support;

import com.vaadin.flow.di.DefaultInstantiator;
import com.vaadin.flow.di.Instantiator;
import com.vaadin.flow.di.InstantiatorFactory;
import com.vaadin.flow.di.Lookup;
import com.vaadin.flow.i18n.I18NProvider;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinServiceInitListener;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ServiceScope;

@Component(immediate=true, service={InstantiatorFactory.class}, scope=ServiceScope.SINGLETON)
public class OSGiInstantiatorFactory
implements InstantiatorFactory {
    public Instantiator createInstantitor(VaadinService service) {
        return new OsgiInstantiator(service);
    }

    private static final class OsgiInstantiator
    extends DefaultInstantiator
    implements Instantiator {
        private final Lookup lookup;

        private OsgiInstantiator(VaadinService service) {
            super(service);
            this.lookup = (Lookup)service.getContext().getAttribute(Lookup.class);
        }

        public Stream<VaadinServiceInitListener> getServiceInitListeners() {
            return this.lookup.lookupAll(VaadinServiceInitListener.class).stream();
        }

        public I18NProvider getI18NProvider() {
            I18NProvider provider = super.getI18NProvider();
            if (provider == null) {
                provider = (I18NProvider)this.lookup.lookup(I18NProvider.class);
            }
            return provider;
        }
    }
}

