/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.plugin.maven;

import com.vaadin.flow.plugin.maven.FlowModeAbstractMojo;
import com.vaadin.pro.licensechecker.LicenseChecker;
import com.vaadin.pro.licensechecker.LicenseException;
import com.vaadin.pro.licensechecker.LocalProKey;
import com.vaadin.pro.licensechecker.Product;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;

@Mojo(name="download-license", requiresProject=false)
public class DownloadLicenseMojo
extends FlowModeAbstractMojo {
    private static final String PRODUCT_NAME = "vaadin-maven-download";
    private static final int TIMEOUT_SECONDS = 300;

    @Override
    protected void executeInternal() throws MojoExecutionException, MojoFailureException {
        String version = this.getFlowVersion();
        if (LocalProKey.get() != null) {
            this.getLog().info((CharSequence)("A license key already exists at " + String.valueOf(LocalProKey.getLocation())));
            this.getLog().info((CharSequence)"Delete the existing key file if you want to download a new one.");
            return;
        }
        try {
            LicenseChecker.downloadLicense((LicenseChecker.DownloadOptions)new LicenseChecker.DownloadOptions(new Product(PRODUCT_NAME, version), 300));
            this.getLog().info((CharSequence)("License key downloaded and saved successfully to " + String.valueOf(LocalProKey.getLocation())));
        }
        catch (LicenseException e) {
            throw new MojoFailureException("Failed to download license key", (Throwable)e);
        }
    }

    private String getFlowVersion() {
        if (this.mojoExecution != null) {
            return this.mojoExecution.getMojoDescriptor().getPluginDescriptor().getVersion();
        }
        return "0.0.1";
    }
}

