/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.plugin.maven;

import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.flow.internal.JsonDecodingException;
import com.vaadin.flow.internal.JsonEncodingException;
import com.vaadin.flow.internal.ReflectTools;
import com.vaadin.flow.plugin.maven.FlowModeAbstractMojo;
import com.vaadin.flow.plugin.maven.FrontendScannerConfig;
import com.vaadin.flow.server.scanner.ReflectionsClassFinder;
import com.vaadin.flow.utils.FlowFileUtils;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.plugin.Mojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.classworlds.realm.NoSuchRealmException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tools.jackson.core.JacksonException;
import tools.jackson.databind.ObjectMapper;

public final class Reflector {
    public static final String INCLUDE_FROM_COMPILE_DEPS_REGEX = ".*(/|\\\\)(portlet-api|javax\\.servlet-api)-.+jar$";
    private static final Set<String> DEPENDENCIES_GROUP_EXCLUSIONS = Set.of("org.apache.maven", "org.codehaus.plexus", "org.slf4j", "org.eclipse.sisu");
    private static final Set<String> REQUIRED_PLUGIN_DEPENDENCIES = Set.of("io.github.classgraph:classgraph:jar", "org.zeroturnaround:zt-exec:jar");
    private static final ScopeArtifactFilter PRODUCTION_SCOPE_FILTER = new ScopeArtifactFilter("compile+runtime");
    private static final Logger log = LoggerFactory.getLogger(Reflector.class);
    private final URLClassLoader isolatedClassLoader;
    private List<String> dependenciesIncompatibility;
    private Object classFinder;

    Reflector(URLClassLoader isolatedClassLoader) {
        this.isolatedClassLoader = isolatedClassLoader;
    }

    private Reflector(URLClassLoader isolatedClassLoader, Object classFinder, List<String> dependenciesIncompatibility) {
        this.isolatedClassLoader = isolatedClassLoader;
        this.classFinder = classFinder;
        this.dependenciesIncompatibility = dependenciesIncompatibility;
    }

    static Reflector adapt(Object reflector) {
        if (reflector instanceof Reflector) {
            Reflector sameClassLoader = (Reflector)reflector;
            return sameClassLoader;
        }
        if (Reflector.class.getName().equals(reflector.getClass().getName())) {
            Class<?> reflectorClass = reflector.getClass();
            try {
                URLClassLoader classLoader = (URLClassLoader)ReflectTools.getJavaFieldValue((Object)reflector, (Field)Reflector.findField(reflectorClass, "isolatedClassLoader"), URLClassLoader.class);
                List dependenciesIncompatibility = (List)ReflectTools.getJavaFieldValue((Object)reflector, (Field)Reflector.findField(reflectorClass, "dependenciesIncompatibility"));
                Object classFinder = ReflectTools.getJavaFieldValue((Object)reflector, (Field)Reflector.findField(reflectorClass, "classFinder"));
                return new Reflector(classLoader, classFinder, dependenciesIncompatibility);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Object of type " + reflector.getClass().getName() + " is not a compatible Reflector", e);
            }
        }
        throw new IllegalArgumentException("Object of type " + reflector.getClass().getName() + " is not a compatible Reflector");
    }

    public URLClassLoader getIsolatedClassLoader() {
        return this.isolatedClassLoader;
    }

    public Class<?> loadClass(String className) throws ClassNotFoundException {
        return this.isolatedClassLoader.loadClass(className);
    }

    public URL getResource(String name) {
        return this.isolatedClassLoader.getResource(name);
    }

    public Mojo createMojo(FlowModeAbstractMojo sourceMojo) throws Exception {
        Class<?> targetMojoClass = this.loadClass(((Object)((Object)sourceMojo)).getClass().getName());
        Object targetMojo = targetMojoClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        this.copyFields(sourceMojo, targetMojo);
        Field classFinderField = Reflector.findField(targetMojoClass, "classFinder");
        ReflectTools.setJavaFieldValue(targetMojo, (Field)classFinderField, (Object)this.getOrCreateClassFinder());
        return (Mojo)targetMojo;
    }

    public static Reflector of(MavenProject project, MojoExecution mojoExecution, FrontendScannerConfig scannerConfig) {
        ArrayList<String> dependenciesIncompatibility = new ArrayList<String>();
        ReflectorClassLoader classLoader = Reflector.createIsolatedClassLoader(project, mojoExecution, scannerConfig, dependenciesIncompatibility);
        Reflector reflector = new Reflector(classLoader);
        reflector.dependenciesIncompatibility = dependenciesIncompatibility;
        return reflector;
    }

    void logIncompatibilities(Consumer<String> logger) {
        if (this.dependenciesIncompatibility != null && !this.dependenciesIncompatibility.isEmpty()) {
            logger.accept("Found dependencies defined with different versions in project and Vaadin maven plugin.\nProject dependencies are used, but plugin execution could fail if the versions are incompatible.\nIn case of build failure please analyze the project dependencies and update versions or configure exclusions for potential offending transitive dependencies.\nYou can use 'mvn dependency:tree -Dincludes=groupId:artifactId' to detect where the dependency is defined in the project.\n\n" + String.join((CharSequence)System.lineSeparator(), this.dependenciesIncompatibility));
        }
    }

    private synchronized Object getOrCreateClassFinder() throws Exception {
        if (this.classFinder == null) {
            Class<?> classFinderImplClass = this.loadClass(ReflectionsClassFinder.class.getName());
            URL[] scanURLs = ReflectTools.getGetter(this.isolatedClassLoader.getClass(), (String)"urlsToScan").map(m -> {
                try {
                    return (URL[])m.invoke((Object)this.isolatedClassLoader, new Object[0]);
                }
                catch (Exception e) {
                    log.debug("Cannot get scan URLs from Reflector classloader. Fallback to full URL set.");
                    return null;
                }
            }).orElseGet(this.isolatedClassLoader::getURLs);
            this.classFinder = classFinderImplClass.getConstructor(ClassLoader.class, URL[].class).newInstance(this.isolatedClassLoader, scanURLs);
        }
        return this.classFinder;
    }

    private static ReflectorClassLoader createIsolatedClassLoader(MavenProject project, MojoExecution mojoExecution, FrontendScannerConfig scannerConfig, List<String> dependenciesIncompatibility) {
        record FilterableArtifact(Artifact artifact, boolean scan) {
        }
        ClassLoader mavenApiClassLoader;
        ArrayList<URL> urls = new ArrayList<URL>();
        ArrayList<URL> filteredUrls = new ArrayList<URL>();
        String outputDirectory = project.getBuild().getOutputDirectory();
        if (outputDirectory != null) {
            URL outputDirURL = FlowFileUtils.convertToUrl((File)new File(outputDirectory));
            urls.add(outputDirURL);
            if (scannerConfig == null || scannerConfig.isIncludeOutputDirectory()) {
                filteredUrls.add(outputDirURL);
            }
        }
        Function<Artifact, String> keyMapper = artifact -> artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getType() + (String)(artifact.getClassifier() != null ? ":" + artifact.getClassifier() : "");
        if (scannerConfig != null && scannerConfig.isEnabled()) {
            log.debug("Frontend scanner configuration enabled: {}", (Object)scannerConfig);
        }
        Predicate<Artifact> shouldScan = scannerConfig == null ? FrontendScannerConfig.DEV_EXCLUSION_FILTER : FrontendScannerConfig.DEFAULT_FILTER.or(scannerConfig::shouldScan);
        Map projectDependencies = project.getArtifacts().stream().filter(artifact -> !DEPENDENCIES_GROUP_EXCLUSIONS.contains(artifact.getGroupId())).filter(Reflector::isProductionDependency).map(artifact -> new FilterableArtifact((Artifact)artifact, shouldScan.test((Artifact)artifact))).collect(Collectors.toMap(item -> (String)keyMapper.apply(item.artifact), Function.identity(), (a, b) -> a, LinkedHashMap::new));
        if (mojoExecution != null) {
            List<Artifact> pluginDependencies = mojoExecution.getMojoDescriptor().getPluginDescriptor().getArtifacts().stream().filter(artifact -> !DEPENDENCIES_GROUP_EXCLUSIONS.contains(artifact.getGroupId())).toList();
            pluginDependencies.stream().map(keyMapper).filter(REQUIRED_PLUGIN_DEPENDENCIES::contains).forEach(projectDependencies::remove);
            Map<Integer, List<Artifact>> potentialDuplicates = pluginDependencies.stream().collect(Collectors.groupingBy(pluginArtifact -> {
                FilterableArtifact projectArtifact = (FilterableArtifact)projectDependencies.get(keyMapper.apply((Artifact)pluginArtifact));
                if (projectArtifact == null) {
                    return 1;
                }
                if (projectArtifact.artifact.getId().equals(pluginArtifact.getId())) {
                    return 0;
                }
                return -1;
            }));
            if (potentialDuplicates.containsKey(-1)) {
                potentialDuplicates.get(-1).stream().map(pluginArtifact -> {
                    String key = (String)keyMapper.apply((Artifact)pluginArtifact);
                    return String.format("%s: project version [%s], plugin version [%s]", key, ((FilterableArtifact)projectDependencies.get((Object)key)).artifact.getBaseVersion(), pluginArtifact.getBaseVersion());
                }).forEach(dependenciesIncompatibility::add);
            }
            if (potentialDuplicates.containsKey(1)) {
                potentialDuplicates.get(1).forEach(artifact -> projectDependencies.put((String)keyMapper.apply((Artifact)artifact), new FilterableArtifact((Artifact)artifact, false)));
            }
        }
        for (FilterableArtifact item2 : projectDependencies.values()) {
            URL url = FlowFileUtils.convertToUrl((File)item2.artifact.getFile());
            if (item2.scan) {
                filteredUrls.add(url);
            }
            urls.add(url);
        }
        if (mojoExecution != null) {
            ClassRealm pluginClassRealm = mojoExecution.getMojoDescriptor().getPluginDescriptor().getClassRealm();
            try {
                mavenApiClassLoader = pluginClassRealm.getWorld().getRealm("maven.api");
            }
            catch (NoSuchRealmException e) {
                throw new RuntimeException(e);
            }
        }
        mavenApiClassLoader = Mojo.class.getClassLoader();
        if (mavenApiClassLoader instanceof ClassRealm) {
            ClassRealm classRealm = (ClassRealm)mavenApiClassLoader;
            try {
                mavenApiClassLoader = classRealm.getWorld().getRealm("maven.api");
            }
            catch (NoSuchRealmException noSuchRealmException) {
                // empty catch block
            }
        }
        return new ReflectorClassLoader(urls.toArray(new URL[0]), filteredUrls.toArray(new URL[0]), mavenApiClassLoader);
    }

    private static boolean isProductionDependency(Artifact artifact) {
        return artifact.getFile() != null && artifact.getArtifactHandler().isAddedToClasspath() && PRODUCTION_SCOPE_FILTER.include(artifact);
    }

    private void copyFields(FlowModeAbstractMojo sourceMojo, Object targetMojo) throws IllegalAccessException, NoSuchFieldException {
        Class<?> targetClass = targetMojo.getClass();
        for (Class<?> sourceClass = ((Object)((Object)sourceMojo)).getClass(); sourceClass != null && sourceClass != Object.class; sourceClass = sourceClass.getSuperclass()) {
            for (Field sourceField : sourceClass.getDeclaredFields()) {
                Reflector.copyField(sourceMojo, targetMojo, sourceField, targetClass);
            }
            targetClass = targetClass.getSuperclass();
        }
    }

    private static void copyField(FlowModeAbstractMojo sourceMojo, Object targetMojo, Field sourceField, Class<?> targetClass) throws IllegalAccessException, NoSuchFieldException {
        Field targetField;
        if (Modifier.isStatic(sourceField.getModifiers())) {
            return;
        }
        sourceField.setAccessible(true);
        Object value = sourceField.get((Object)sourceMojo);
        if (value == null) {
            return;
        }
        try {
            targetField = targetClass.getDeclaredField(sourceField.getName());
        }
        catch (NoSuchFieldException ex) {
            String message = "Field " + sourceField.getName() + " defined in " + sourceField.getDeclaringClass().getName() + " is missing in " + targetClass.getName();
            sourceMojo.logError(message, ex);
            throw ex;
        }
        Class<?> sourceFieldType = sourceField.getType();
        Class<?> targetFieldType = targetField.getType();
        if (!targetFieldType.isAssignableFrom(sourceFieldType)) {
            if (sourceField.isAnnotationPresent(Cloneable.class) || sourceFieldType.isAnnotationPresent(Cloneable.class)) {
                try {
                    value = Reflector.cloneWithTargetClassloader(value, targetFieldType);
                }
                catch (JsonDecodingException | JsonEncodingException e) {
                    String message = "Field " + targetField.getName() + " in class " + targetClass.getName() + " of type " + targetFieldType.getName() + " is loaded from different class loaders.  Source class is annotated with @" + Cloneable.class.getName() + " but the JSON " + (e instanceof JsonEncodingException ? "encoding" : "decoding") + " operation failed. Source class loader: " + String.valueOf(sourceFieldType.getClassLoader()) + ", Target class loader: " + String.valueOf(targetFieldType.getClassLoader()) + ". This is likely a bug in the Vaadin Maven plugin. Please, report the error on the issue tracker.";
                    sourceMojo.logError(message);
                    throw e;
                }
            } else {
                String message = "Field " + targetField.getName() + " in class " + targetClass.getName() + " of type " + targetFieldType.getName() + " is loaded from different class loaders. Source class loader: " + String.valueOf(sourceFieldType.getClassLoader()) + ", Target class loader: " + String.valueOf(targetFieldType.getClassLoader()) + ". This is likely a bug in the Vaadin Maven plugin. Please, report the error on the issue tracker.";
                sourceMojo.logError(message);
                throw new NoSuchFieldException(message);
            }
        }
        targetField.setAccessible(true);
        targetField.set(targetMojo, value);
    }

    private static Field findField(Class<?> clazz, String fieldName) throws NoSuchFieldException {
        while (clazz != null && !clazz.equals(Object.class)) {
            try {
                return clazz.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException e) {
                clazz = clazz.getSuperclass();
            }
        }
        throw new NoSuchFieldException(fieldName);
    }

    private static Object cloneWithTargetClassloader(Object source, Class<?> targetClass) throws JsonEncodingException, JsonDecodingException {
        String json;
        ObjectMapper mapper = JacksonUtils.getMapper();
        try {
            json = mapper.writeValueAsString(source);
        }
        catch (JacksonException e) {
            throw new JsonEncodingException("Cannot encode " + targetClass.getName() + " object to JSON", (Throwable)e);
        }
        try {
            return mapper.readValue(json, targetClass);
        }
        catch (JacksonException e) {
            throw new JsonDecodingException("Cannot decode JSON to " + targetClass.getName() + " object", (Throwable)e);
        }
    }

    static final class ReflectorClassLoader
    extends URLClassLoader {
        private final ClassLoader delegate;
        private final URL[] urlsToScan;

        private ReflectorClassLoader(URL[] urls, URL[] urlsToScan, ClassLoader delegate) {
            super(urls, (ClassLoader)null);
            this.urlsToScan = urlsToScan;
            this.delegate = delegate;
        }

        @Override
        public Class<?> loadClass(String name) throws ClassNotFoundException {
            try {
                return super.loadClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (this.delegate != null) {
                    try {
                        return this.delegate.loadClass(name);
                    }
                    catch (ClassNotFoundException classNotFoundException2) {
                        // empty catch block
                    }
                }
                return ClassLoader.getPlatformClassLoader().loadClass(name);
            }
        }

        @Override
        public URL getResource(String name) {
            URL url = super.getResource(name);
            if (url == null && this.delegate != null) {
                url = this.delegate.getResource(name);
            }
            if (url == null) {
                url = ClassLoader.getPlatformClassLoader().getResource(name);
            }
            return url;
        }

        @Override
        public Enumeration<URL> getResources(String name) throws IOException {
            URL url;
            ArrayList<URL> allResources = new ArrayList<URL>();
            Enumeration<URL> resources = super.getResources(name);
            while (resources.hasMoreElements()) {
                allResources.add(resources.nextElement());
            }
            if (this.delegate != null) {
                resources = this.delegate.getResources(name);
                while (resources.hasMoreElements()) {
                    url = resources.nextElement();
                    if (allResources.contains(url)) continue;
                    allResources.add(url);
                }
            }
            resources = ClassLoader.getPlatformClassLoader().getResources(name);
            while (resources.hasMoreElements()) {
                url = resources.nextElement();
                if (allResources.contains(url)) continue;
                allResources.add(url);
            }
            return Collections.enumeration(allResources);
        }

        public URL[] getUrlsToScan() {
            return this.urlsToScan;
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE, ElementType.FIELD})
    @Documented
    public static @interface Cloneable {
    }
}

