/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.plugin.maven;

import com.vaadin.experimental.FeatureFlags;
import com.vaadin.flow.plugin.base.BuildFrontendUtil;
import com.vaadin.flow.plugin.base.PluginAdapterBase;
import com.vaadin.flow.plugin.base.PluginAdapterBuild;
import com.vaadin.flow.plugin.maven.FlowModeAbstractMojo;
import com.vaadin.flow.server.frontend.BundleValidationUtil;
import com.vaadin.flow.server.frontend.ExecutionFailedException;
import com.vaadin.flow.server.frontend.FrontendUtils;
import com.vaadin.flow.server.frontend.Options;
import com.vaadin.flow.server.frontend.TaskCleanFrontendFiles;
import com.vaadin.flow.server.frontend.scanner.FrontendDependenciesScanner;
import com.vaadin.pro.licensechecker.LicenseChecker;
import com.vaadin.pro.licensechecker.MissingLicenseKeyException;
import java.io.File;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="build-frontend", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, defaultPhase=LifecyclePhase.PREPARE_PACKAGE)
public class BuildFrontendMojo
extends FlowModeAbstractMojo
implements PluginAdapterBuild {
    @Parameter(defaultValue="true")
    private boolean generateBundle;
    @Parameter(defaultValue="true")
    private boolean runNpmInstall;
    @Parameter(defaultValue="true")
    private boolean generateEmbeddableWebComponents;
    @Parameter(defaultValue="${project.basedir}/src/main/resources/META-INF/resources/frontend")
    private File frontendResourcesDirectory;
    @Parameter(defaultValue="true")
    private boolean optimizeBundle;
    @Parameter(property="vaadin.ci.build", defaultValue="false")
    private boolean ciBuild;
    @Parameter(property="vaadin.force.production.build", defaultValue="false")
    private boolean forceProductionBuild;
    @Parameter(property="vaadin.clean.build.frontend.files", defaultValue="true")
    private boolean cleanFrontendFiles;
    @Parameter(defaultValue="${project.build.outputDirectory}/META-INF/resources/")
    private File resourcesOutputDirectory;

    @Override
    protected void executeInternal() throws MojoExecutionException, MojoFailureException {
        boolean commercialBannerRequired;
        boolean licenseRequired;
        long start = System.nanoTime();
        if (!BuildFrontendUtil.getTokenFile((PluginAdapterBase)this).exists()) {
            File file = BuildFrontendUtil.propagateBuildInfo((PluginAdapterBase)this);
        }
        Options options = new Options(null, this.getClassFinder(), this.npmFolder()).withFrontendDirectory(this.frontendDirectory()).withFrontendGeneratedFolder(this.generatedTsFolder());
        TaskCleanFrontendFiles cleanTask = new TaskCleanFrontendFiles(options);
        boolean reactEnabled = this.isReactEnabled() && FrontendUtils.isReactRouterRequired((File)BuildFrontendUtil.getFrontendDirectory((PluginAdapterBase)this));
        FeatureFlags featureFlags = new FeatureFlags(this.createLookup(this.getClassFinder()));
        if (this.javaResourceFolder() != null) {
            featureFlags.setPropertiesLocation(this.javaResourceFolder());
        }
        FrontendDependenciesScanner frontendDependencies = new FrontendDependenciesScanner.FrontendDependenciesScannerFactory().createScanner(!this.optimizeBundle, this.getClassFinder(), this.generateEmbeddableWebComponents, featureFlags, reactEnabled);
        try {
            BuildFrontendUtil.runNodeUpdater((PluginAdapterBuild)this, (FrontendDependenciesScanner)frontendDependencies);
        }
        catch (ExecutionFailedException | URISyntaxException exception) {
            throw new MojoFailureException("Could not execute build-frontend goal", exception);
        }
        if (this.generateBundle() && BundleValidationUtil.needsBundleBuild((File)this.servletResourceOutputDirectory())) {
            try {
                BuildFrontendUtil.runFrontendBuild((PluginAdapterBase)this);
                if (this.cleanFrontendFiles()) {
                    cleanTask.execute();
                }
            }
            catch (ExecutionFailedException | URISyntaxException | TimeoutException exception) {
                throw new MojoExecutionException(exception.getMessage(), (Exception)exception);
            }
        }
        LicenseChecker.setStrictOffline((boolean)true);
        try {
            licenseRequired = BuildFrontendUtil.validateLicenses((PluginAdapterBase)this, (FrontendDependenciesScanner)frontendDependencies);
            commercialBannerRequired = false;
        }
        catch (MissingLicenseKeyException ex) {
            licenseRequired = true;
            commercialBannerRequired = true;
            this.getLog().info((CharSequence)ex.getMessage());
        }
        BuildFrontendUtil.updateBuildFile((PluginAdapterBuild)this, (boolean)licenseRequired, (boolean)commercialBannerRequired);
        long ms = (System.nanoTime() - start) / 1000000L;
        this.getLog().info((CharSequence)("Build frontend completed in " + ms + " ms."));
    }

    protected boolean cleanFrontendFiles() {
        if (this.isHillaUsed(this.frontendDirectory())) {
            return false;
        }
        return this.cleanFrontendFiles;
    }

    public File frontendResourcesDirectory() {
        return this.frontendResourcesDirectory;
    }

    public boolean generateBundle() {
        return this.generateBundle;
    }

    public boolean generateEmbeddableWebComponents() {
        return this.generateEmbeddableWebComponents;
    }

    public boolean optimizeBundle() {
        return this.optimizeBundle;
    }

    public boolean runNpmInstall() {
        return this.runNpmInstall;
    }

    public boolean ciBuild() {
        return this.ciBuild;
    }

    public boolean forceProductionBuild() {
        return this.forceProductionBuild;
    }

    public boolean compressBundle() {
        return true;
    }

    public File resourcesOutputDirectory() {
        return this.resourcesOutputDirectory;
    }

    public boolean checkRuntimeDependency(String groupId, String artifactId, Consumer<String> missingDependencyMessage) {
        List<Artifact> deps;
        Objects.requireNonNull(groupId, "groupId cannot be null");
        Objects.requireNonNull(artifactId, "artifactId cannot be null");
        if (missingDependencyMessage == null) {
            missingDependencyMessage = text -> {};
        }
        if ((deps = this.project.getArtifacts().stream().filter(artifact -> groupId.equals(artifact.getGroupId()) && artifactId.equals(artifact.getArtifactId())).toList()).isEmpty()) {
            missingDependencyMessage.accept(String.format("The dependency %1$s:%2$s has not been found in the project configuration.\nPlease add the following dependency to your POM file:\n\n<dependency>\n    <groupId>%1$s</groupId>\n    <artifactId>%2$s</artifactId>\n    <scope>runtime</scope>\n</dependency>\n", groupId, artifactId));
            return false;
        }
        if (deps.stream().noneMatch(artifact -> !artifact.isOptional() && artifact.getArtifactHandler().isAddedToClasspath() && ("compile".equals(artifact.getScope()) || "provided".equals(artifact.getScope()) || "runtime".equals(artifact.getScope())))) {
            missingDependencyMessage.accept(String.format("The dependency %1$s:%2$s has been found in the project configuration,\nbut with a scope that does not guarantee its presence at runtime.\nPlease check that the dependency has 'compile', 'provided' or 'runtime' scope.\nTo check the current dependency scope, you can run 'mvn dependency:tree -Dincludes=%1$s:%2$s'\n", groupId, artifactId));
            return false;
        }
        return true;
    }
}

