/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.plugin.maven;

import com.vaadin.flow.plugin.maven.Reflector;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.maven.artifact.Artifact;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Reflector.Cloneable
public class FrontendScannerConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(FrontendScannerConfig.class);
    static final Predicate<Artifact> DEFAULT_FILTER = FrontendScannerConfig.withDefaults()::shouldScan;
    private final boolean silent;
    private boolean enabled = true;
    private boolean includeOutputDirectory = true;
    private AnnotationScannerMode scannerMode = AnnotationScannerMode.FULL;
    private final List<ArtifactMatcher> includes = new ArrayList<ArtifactMatcher>();
    private final List<ArtifactMatcher> excludes = new ArrayList<ArtifactMatcher>();

    public FrontendScannerConfig() {
        this.silent = false;
    }

    private FrontendScannerConfig(boolean silent) {
        this.silent = silent;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setIncludeOutputDirectory(boolean includeOutputDirectory) {
        this.includeOutputDirectory = includeOutputDirectory;
    }

    public boolean isIncludeOutputDirectory() {
        return this.includeOutputDirectory;
    }

    public void setScannerMode(AnnotationScannerMode scannerMode) {
        this.scannerMode = Objects.requireNonNull(scannerMode, "Scanner mode must not be null");
    }

    public AnnotationScannerMode getScannerMode() {
        return this.scannerMode;
    }

    public List<ArtifactMatcher> getExcludes() {
        return List.copyOf(this.excludes);
    }

    public void addExclude(ArtifactMatcher artifactMatcher) {
        this.excludes.add(Objects.requireNonNull(artifactMatcher, "Artifact matcher must not be null"));
    }

    public List<ArtifactMatcher> getIncludes() {
        return List.copyOf(this.includes);
    }

    public void addInclude(ArtifactMatcher artifactMatcher) {
        this.includes.add(Objects.requireNonNull(artifactMatcher, "Artifact matcher must not be null"));
    }

    boolean shouldScan(Artifact artifact) {
        if (!this.enabled) {
            return true;
        }
        if (!this.excludes.isEmpty() && this.excludes.stream().anyMatch(matcher -> matcher.matches(artifact))) {
            this.log("Artifact {} rejected by exclusion rules", artifact.getId());
            return false;
        }
        if (!this.includes.isEmpty() && this.includes.stream().noneMatch(matcher -> matcher.matches(artifact))) {
            this.log("Artifact {} rejected because not matching inclusion rules", artifact.getId());
            return false;
        }
        this.log("Artifact {} accepted", artifact.getId());
        return true;
    }

    private void log(String message, Object ... args) {
        if (!this.silent && LOGGER.isDebugEnabled()) {
            LOGGER.debug(message, args);
        }
    }

    private static FrontendScannerConfig withDefaults() {
        FrontendScannerConfig out = new FrontendScannerConfig(true);
        out.addInclude(new ArtifactMatcher("com.vaadin", "*"));
        out.addExclude(new ArtifactMatcher("com.vaadin.external.gw", "*"));
        out.addExclude(new ArtifactMatcher("com.vaadin.servletdetector", "*"));
        out.addExclude(new ArtifactMatcher("com.vaadin", "open"));
        out.addExclude(new ArtifactMatcher("com.vaadin", "license-checker"));
        return out;
    }

    public String toString() {
        return "FrontendScannerConfig { enabled=" + this.enabled + ", includeOutputDirectory=" + this.includeOutputDirectory + ", scannerMode=" + this.scannerMode + ", includes=" + this.includes + ", excludes=" + this.excludes + "}";
    }

    public static enum AnnotationScannerMode {
        ADD_ON,
        FULL;

    }

    public static class ArtifactMatcher {
        private String groupIdPattern;
        private String artifactPattern;

        public ArtifactMatcher() {
        }

        public ArtifactMatcher(String groupId, String artifactId) {
            this.groupIdPattern = groupId;
            this.artifactPattern = artifactId;
        }

        public String getGroupId() {
            return this.groupIdPattern;
        }

        public void setGroupId(String groupId) {
            ArtifactMatcher.validatePattern(groupId);
            this.groupIdPattern = groupId;
        }

        public String getArtifactId() {
            return this.artifactPattern;
        }

        public void setArtifactId(String artifactId) {
            ArtifactMatcher.validatePattern(artifactId);
            this.artifactPattern = artifactId;
        }

        public boolean matches(Artifact artifact) {
            boolean allArtifacts;
            if (artifact == null) {
                return false;
            }
            boolean allGroups = this.groupIdPattern == null || this.groupIdPattern.isBlank() || "*".equals(this.groupIdPattern);
            boolean bl = allArtifacts = this.artifactPattern == null || this.artifactPattern.isBlank() || "*".equals(this.artifactPattern);
            if (allGroups && allArtifacts) {
                return true;
            }
            if (!allGroups && !ArtifactMatcher.matchesPattern(this.groupIdPattern, artifact.getGroupId())) {
                return false;
            }
            return allArtifacts || ArtifactMatcher.matchesPattern(this.artifactPattern, artifact.getArtifactId());
        }

        private static boolean matchesPattern(String pattern, String value) {
            boolean endWildcard;
            boolean startWildcard = pattern.charAt(0) == '*';
            int patternLength = pattern.length();
            boolean bl = endWildcard = pattern.charAt(patternLength - 1) == '*';
            if (startWildcard && endWildcard) {
                return value.contains(pattern.substring(1, patternLength - 1));
            }
            if (startWildcard) {
                return value.endsWith(pattern.substring(1));
            }
            if (endWildcard) {
                return value.startsWith(pattern.substring(0, patternLength - 1));
            }
            return value.equals(pattern);
        }

        private static void validatePattern(String pattern) {
            if (pattern != null) {
                long wildcards = pattern.chars().filter(c -> c == 42).count();
                int idx = pattern.indexOf(42);
                int lastIdx = pattern.lastIndexOf(42);
                if (wildcards > 2L || idx > 0 && idx < pattern.length() - 1 || lastIdx > 0 && lastIdx < pattern.length() - 1) {
                    throw new IllegalArgumentException("Invalid pattern: '" + pattern + "'. * can be only at the begin and the end of the pattern");
                }
            }
        }

        public String toString() {
            return (this.groupIdPattern != null && !this.groupIdPattern.isBlank() ? this.groupIdPattern : "*") + ":" + (this.artifactPattern != null && !this.artifactPattern.isBlank() ? this.artifactPattern : "*");
        }
    }
}

