/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.littemplate.internal;

import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.littemplate.BundleLitParser;
import com.vaadin.flow.component.littemplate.LitTemplate;
import com.vaadin.flow.component.littemplate.LitTemplateParser;
import com.vaadin.flow.di.Lookup;
import com.vaadin.flow.di.ResourceProvider;
import com.vaadin.flow.internal.AnnotationReader;
import com.vaadin.flow.internal.Pair;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.frontend.FrontendUtils;
import com.vaadin.flow.shared.ui.Dependency;
import com.vaadin.flow.shared.ui.LoadMode;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.jsoup.nodes.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LitTemplateParserImpl
implements LitTemplateParser {
    private static final LitTemplateParser INSTANCE = new LitTemplateParserImpl();

    protected LitTemplateParserImpl() {
    }

    public static LitTemplateParser getInstance() {
        return INSTANCE;
    }

    @Override
    public LitTemplateParser.TemplateData getTemplateContent(Class<? extends LitTemplate> clazz, String tag, VaadinService service) {
        List dependencies = AnnotationReader.getAnnotationsFor(clazz, JsModule.class).stream().map(jsModule -> new Dependency(Dependency.Type.JS_MODULE, jsModule.value(), LoadMode.EAGER)).collect(Collectors.toList());
        for (Object filter : service.getDependencyFilters()) {
            dependencies = filter.filter(new ArrayList(dependencies), service);
        }
        Pair chosenDep = null;
        for (Dependency dependency : dependencies) {
            String url;
            String source;
            if (dependency.getType() != Dependency.Type.JS_MODULE || (source = this.getSourcesFromTemplate(service, tag, url = dependency.getUrl())) == null) continue;
            if (chosenDep == null) {
                chosenDep = new Pair((Serializable)dependency, (Serializable)((Object)source));
            }
            if (!this.dependencyHasTagName(dependency, tag)) continue;
            chosenDep = new Pair((Serializable)dependency, (Serializable)((Object)source));
            break;
        }
        Element templateElement = null;
        if (chosenDep != null) {
            templateElement = BundleLitParser.parseLitTemplateElement(((Dependency)chosenDep.getFirst()).getUrl(), (String)((Object)chosenDep.getSecond()));
        }
        if (templateElement != null) {
            Element parent = new Element(tag);
            parent.attr("id", tag);
            templateElement.appendTo(parent);
            return new LitTemplateParser.TemplateData(((Dependency)chosenDep.getFirst()).getUrl(), templateElement);
        }
        this.getLogger().info("Couldn't find the definition of the element with tag '{}' in any lit template file declared using '@{}' annotations. In a Spring Boot project, please ensure that the template's groupId is added to the vaadin.allowed-packages property. Otherwise, please Check the availability of the template files in your WAR file or provide alternative implementation of the method LitTemplateParser.getTemplateContent() which should return an element representing the content of the template file", (Object)tag, (Object)JsModule.class.getSimpleName());
        return null;
    }

    private boolean dependencyHasTagName(Dependency dependency, String tag) {
        String url = FilenameUtils.removeExtension((String)dependency.getUrl()).toLowerCase(Locale.ENGLISH);
        return url.endsWith("/" + tag);
    }

    protected String getSourcesFromTemplate(VaadinService service, String tag, String url) {
        String pathWithoutPrefix;
        InputStream content = this.getResourceStream(service, url);
        if (content == null) {
            content = FrontendUtils.getFrontendFileFromDevModeHandler((VaadinService)service, (String)url);
        }
        if (content == null) {
            pathWithoutPrefix = url.replaceFirst("^\\./", "");
            String vaadinDirectory = "META-INF/VAADIN/config/templates/";
            String resourceUrl = vaadinDirectory + pathWithoutPrefix;
            content = this.getResourceStream(service, resourceUrl);
        }
        if (content == null) {
            pathWithoutPrefix = url.replaceFirst("^\\./", "");
            Path subFolder = Path.of("dev-bundle", "config", "templates", pathWithoutPrefix);
            File templateFile = new File(new File(service.getDeploymentConfiguration().getProjectFolder(), service.getDeploymentConfiguration().getBuildFolder()), subFolder.toString());
            try {
                content = new FileInputStream(templateFile);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        if (content != null) {
            this.getLogger().debug("Found sources from the tag '{}' in the template '{}'", (Object)tag, (Object)url);
            return FrontendUtils.streamToString((InputStream)content);
        }
        return null;
    }

    private InputStream getResourceStream(VaadinService service, String url) {
        ResourceProvider resourceProvider = (ResourceProvider)((Lookup)service.getContext().getAttribute(Lookup.class)).lookup(ResourceProvider.class);
        URL resourceUrl = resourceProvider.getApplicationResource(url);
        if (resourceUrl != null) {
            try {
                return resourceUrl.openStream();
            }
            catch (IOException e) {
                this.getLogger().warn("Exception accessing resource " + resourceUrl, (Throwable)e);
            }
        }
        return null;
    }

    private Logger getLogger() {
        return LoggerFactory.getLogger((String)LitTemplateParserImpl.class.getName());
    }
}

