/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.littemplate;

import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.littemplate.LitTemplate;
import com.vaadin.flow.component.littemplate.LitTemplateParser;
import com.vaadin.flow.component.template.internal.IdCollector;
import com.vaadin.flow.component.template.internal.ParserData;
import com.vaadin.flow.internal.AnnotationReader;
import com.vaadin.flow.server.VaadinService;
import java.io.Serializable;
import java.util.Collections;
import java.util.Optional;
import org.jsoup.nodes.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LitTemplateDataAnalyzer
implements Serializable {
    private final Class<? extends LitTemplate> templateClass;
    private final LitTemplateParser parser;
    private final VaadinService service;
    private final String tag;

    LitTemplateDataAnalyzer(Class<? extends LitTemplate> templateClass, LitTemplateParser parser, VaadinService service) {
        this.templateClass = templateClass;
        this.parser = parser;
        this.service = service;
        this.tag = this.getTag(templateClass);
    }

    ParserData parseTemplate() {
        LitTemplateParser.TemplateData templateData = this.parser.getTemplateContent(this.templateClass, this.tag, this.service);
        if (templateData == null) {
            LitTemplateDataAnalyzer.getLogger().info("Couldn't parse template for {} class. Only specific Lit template format is supported. Please check that your template definition directly contains 'render' method which returns html`_template_content_`.", this.templateClass);
        }
        Element templateRoot = templateData == null ? null : templateData.getTemplateElement();
        String modulePath = templateData == null ? null : templateData.getModulePath();
        IdCollector idExtractor = new IdCollector(this.templateClass, modulePath, templateRoot);
        idExtractor.collectInjectedIds(Collections.emptySet());
        return new ParserData(idExtractor.getIdByField(), idExtractor.getTagById(), idExtractor.getAttributes());
    }

    private String getTag(Class<? extends LitTemplate> clazz) {
        Optional<String> tagNameAnnotation = AnnotationReader.getAnnotationFor(clazz, Tag.class).map(Tag::value);
        assert (tagNameAnnotation.isPresent());
        return tagNameAnnotation.get();
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger((String)LitTemplateDataAnalyzer.class.getName());
    }
}

