/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.html;

import com.vaadin.flow.component.AbstractSinglePropertyField;
import com.vaadin.flow.component.Focusable;
import com.vaadin.flow.component.HasAriaLabel;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.PropertyDescriptor;
import com.vaadin.flow.component.PropertyDescriptors;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.data.value.HasValueChangeMode;
import com.vaadin.flow.data.value.ValueChangeMode;
import com.vaadin.flow.dom.DomListenerRegistration;
import com.vaadin.flow.signals.shared.SharedNumberSignal;
import java.util.Arrays;
import java.util.Objects;

@Tag(value="input")
public class RangeInput
extends AbstractSinglePropertyField<RangeInput, Double>
implements Focusable<RangeInput>,
HasSize,
HasStyle,
HasValueChangeMode,
HasAriaLabel {
    private static final PropertyDescriptor<String, String> typeDescriptor = PropertyDescriptors.attributeWithDefault((String)"type", (String)"text");
    private static final PropertyDescriptor<String, String> minDescriptor = PropertyDescriptors.attributeWithDefault((String)"min", (String)"0");
    private static final PropertyDescriptor<String, String> maxDescriptor = PropertyDescriptors.attributeWithDefault((String)"max", (String)"100");
    private static final PropertyDescriptor<String, String> stepDescriptor = PropertyDescriptors.attributeWithDefault((String)"step", (String)"1");
    private static final PropertyDescriptor<String, String> orientDescriptor = PropertyDescriptors.attributeWithDefault((String)"orient", (String)Orientation.HORIZONTAL.getValue());
    private int valueChangeTimeout = 400;
    private ValueChangeMode currentMode;
    private boolean readOnly = false;
    private boolean enabled = true;

    public RangeInput() {
        this(ValueChangeMode.ON_CHANGE);
    }

    public RangeInput(ValueChangeMode valueChangeMode) {
        super("value", (Object)0.0, false);
        this.setValueChangeMode(valueChangeMode);
        this.set(typeDescriptor, "range");
    }

    public ValueChangeMode getValueChangeMode() {
        return this.currentMode;
    }

    public void setValueChangeMode(ValueChangeMode valueChangeMode) {
        this.currentMode = valueChangeMode;
        this.setSynchronizedEvent(ValueChangeMode.eventForMode((ValueChangeMode)valueChangeMode, (String)"input"));
        this.applyChangeTimeout();
    }

    public void setValueChangeTimeout(int valueChangeTimeout) {
        this.valueChangeTimeout = valueChangeTimeout;
        this.applyChangeTimeout();
    }

    public int getValueChangeTimeout() {
        return this.valueChangeTimeout;
    }

    private void applyChangeTimeout() {
        ValueChangeMode.applyChangeTimeout((ValueChangeMode)this.currentMode, (int)this.valueChangeTimeout, (DomListenerRegistration)this.getSynchronizationRegistration());
    }

    public double getMin() {
        return Double.parseDouble((String)this.get(minDescriptor));
    }

    public void setMin(double min) {
        this.set(minDescriptor, "" + min);
    }

    public void bindMin(SharedNumberSignal minSignal) {
        Objects.requireNonNull(minSignal, "Signal cannot be null");
        this.getElement().bindAttribute("min", minSignal.map(Object::toString));
    }

    public double getMax() {
        return Double.parseDouble((String)this.get(maxDescriptor));
    }

    public void setMax(double max) {
        this.set(maxDescriptor, "" + max);
    }

    public void bindMax(SharedNumberSignal maxSignal) {
        Objects.requireNonNull(maxSignal, "Signal cannot be null");
        this.getElement().bindAttribute("max", maxSignal.map(Object::toString));
    }

    public Double getStep() {
        String step = (String)this.get(stepDescriptor);
        return "any".equals(step) ? null : Double.valueOf(Double.parseDouble(step));
    }

    public void setStep(Double step) {
        this.set(stepDescriptor, step == null ? "any" : "" + step);
    }

    public void setOrientation(Orientation orientation) {
        Objects.requireNonNull(orientation);
        this.set(orientDescriptor, orientation.getValue());
        if (orientation == Orientation.VERTICAL) {
            this.getStyle().set("-webkit-appearance", "slider-vertical");
            this.getStyle().set("appearance", "slider-vertical");
            this.getStyle().set("writing-mode", "bt-lr");
        } else {
            this.getStyle().remove("-webkit-appearance");
            this.getStyle().remove("appearance");
            this.getStyle().remove("writing-mode");
        }
    }

    public Orientation getOrientation() {
        String orientation = (String)this.get(orientDescriptor);
        return Arrays.stream(Orientation.values()).filter(it -> it.getValue().equals(orientation)).findAny().orElse(Orientation.HORIZONTAL);
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
        this.updateEnabled();
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        this.updateEnabled();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    private void updateEnabled() {
        super.setEnabled(this.enabled && !this.readOnly);
    }

    public static enum Orientation {
        HORIZONTAL("horizontal"),
        VERTICAL("vertical");

        private final String value;

        private Orientation(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

