/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.html;

import com.vaadin.flow.component.ClickNotifier;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.DomEvent;
import com.vaadin.flow.component.HtmlComponent;
import com.vaadin.flow.component.HtmlContainer;
import com.vaadin.flow.component.Synchronize;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.shared.Registration;
import com.vaadin.signals.Signal;
import java.util.Objects;

@Tag(value="details")
public class NativeDetails
extends HtmlComponent
implements ClickNotifier<NativeDetails> {
    private final Summary summary = new Summary();
    private Component content;

    public NativeDetails() {
        this.getElement().appendChild(new Element[]{this.summary.getElement()});
    }

    public NativeDetails(String summary) {
        this();
        this.summary.setText(summary);
    }

    public NativeDetails(Signal<String> summarySignal) {
        this();
        Objects.requireNonNull(summarySignal, "summarySignal must not be null");
        this.bindSummaryText(summarySignal);
    }

    public NativeDetails(Component summaryContent) {
        this();
        this.summary.add(new Component[]{summaryContent});
    }

    public NativeDetails(String summary, Component content) {
        this(summary);
        this.setContent(content);
    }

    public NativeDetails(Signal<String> summarySignal, Component content) {
        this(summarySignal);
        this.setContent(content);
    }

    public NativeDetails(Component summaryContent, Component content) {
        this(summaryContent);
        this.setContent(content);
    }

    public Summary getSummary() {
        return this.summary;
    }

    public String getSummaryText() {
        return this.summary.getText();
    }

    public void setSummaryText(String summary) {
        this.summary.setText(summary);
    }

    public void bindSummaryText(Signal<String> summarySignal) {
        this.summary.getElement().bindText(summarySignal);
    }

    public void setSummary(Component ... summaryContent) {
        this.summary.removeAll();
        this.summary.add(summaryContent);
    }

    public Component getContent() {
        return this.content;
    }

    public void setContent(Component content) {
        Objects.requireNonNull(content, "Content to set cannot be null");
        if (this.content != null) {
            this.content.getElement().removeFromParent();
        }
        this.content = content;
        this.getElement().appendChild(new Element[]{content.getElement()});
    }

    @Synchronize(property="open", value={"toggle"}, allowInert=true)
    public boolean isOpen() {
        return this.getElement().getProperty("open", false);
    }

    public void setOpen(boolean open) {
        this.getElement().setProperty("open", open);
    }

    public Registration addToggleListener(ComponentEventListener<ToggleEvent> listener) {
        return ComponentUtil.addListener((Component)this, ToggleEvent.class, listener);
    }

    @Tag(value="summary")
    public static class Summary
    extends HtmlContainer
    implements ClickNotifier<Summary> {
    }

    @DomEvent(value="toggle")
    public static class ToggleEvent
    extends ComponentEvent<NativeDetails> {
        private final boolean open;

        public ToggleEvent(NativeDetails source, boolean fromClient) {
            super((Component)source, fromClient);
            this.open = source.isOpen();
        }

        public boolean isOpened() {
            return this.open;
        }
    }
}

