/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.html;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasAriaLabel;
import com.vaadin.flow.component.HtmlContainer;
import com.vaadin.flow.component.Tag;
import com.vaadin.signals.Signal;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;

@Tag(value="fieldset")
public class FieldSet
extends HtmlContainer
implements HasAriaLabel {
    public FieldSet() {
    }

    public FieldSet(String legendText) {
        this();
        if (legendText != null && !legendText.isEmpty()) {
            this.addComponentAsFirst((Component)new Legend(legendText));
        }
    }

    public FieldSet(Signal<String> textSignal) {
        this.addComponentAsFirst((Component)new Legend(textSignal));
    }

    public FieldSet(Component ... content) {
        super(content);
    }

    public FieldSet(String legendText, Component content) {
        this(legendText);
        this.add(new Component[]{content});
    }

    public Legend getLegend() {
        return this.findLegend();
    }

    public void setLegendText(String text) {
        Legend legend = this.findLegend();
        if (text != null && !text.isEmpty()) {
            if (legend == null) {
                legend = new Legend(text);
                this.addComponentAsFirst((Component)legend);
            } else {
                legend.setText(text);
            }
        } else if (legend != null) {
            this.remove(new Component[]{legend});
        }
    }

    public String getLegendText() {
        Legend legend = this.findLegend();
        return legend != null ? legend.getText() : null;
    }

    public void bindLegendText(Signal<String> legendTextSignal) {
        Legend legend = this.findLegend();
        if (legendTextSignal != null) {
            if (legend == null) {
                legend = new Legend();
                this.addComponentAsFirst((Component)legend);
            }
            legend.bindText(legendTextSignal);
        } else if (legend != null) {
            legend.bindText(null);
        }
    }

    public Stream<Component> getContent() {
        return this.getChildren().filter(c -> !(c instanceof Legend));
    }

    public void setContent(Component ... content) {
        Objects.requireNonNull(content, "Content should not be null");
        for (Component c : content) {
            if (!(c instanceof Legend)) continue;
            throw new IllegalArgumentException("Legend should not be included in the content. Use constructor params or setLegend.. methods instead.");
        }
        this.removeAll();
        Legend legend = this.findLegend();
        if (legend != null) {
            this.addComponentAsFirst((Component)legend);
        }
        this.add(content);
    }

    private Legend findLegend() {
        Optional<Component> legend = this.getChildren().filter(c -> c instanceof Legend).findFirst();
        return legend.orElse(null);
    }

    @Tag(value="legend")
    public static class Legend
    extends HtmlContainer {
        public Legend() {
        }

        public Legend(String text) {
            this();
            this.setText(text);
        }

        public Legend(Signal<String> textSignal) {
            Objects.requireNonNull(textSignal, "textSignal must not be null");
            this.bindText(textSignal);
        }
    }
}

