/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.html;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Focusable;
import com.vaadin.flow.component.HasAriaLabel;
import com.vaadin.flow.component.HtmlContainer;
import com.vaadin.flow.component.PropertyDescriptor;
import com.vaadin.flow.component.PropertyDescriptors;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.html.AnchorTarget;
import com.vaadin.flow.component.html.AnchorTargetValue;
import com.vaadin.flow.component.html.AttachmentType;
import com.vaadin.flow.server.AbstractStreamResource;
import com.vaadin.flow.server.StreamResourceRegistry;
import com.vaadin.flow.server.streams.AbstractDownloadHandler;
import com.vaadin.flow.server.streams.DownloadHandler;
import com.vaadin.flow.server.streams.ElementRequestHandler;
import com.vaadin.flow.signals.Signal;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;

@Tag(value="a")
public class Anchor
extends HtmlContainer
implements Focusable<Anchor>,
HasAriaLabel {
    private static final PropertyDescriptor<String, String> hrefDescriptor = PropertyDescriptors.attributeWithDefault((String)"href", (String)"", (boolean)false);
    private static final PropertyDescriptor<String, Optional<String>> targetDescriptor = PropertyDescriptors.optionalAttributeWithDefault((String)"target", (String)AnchorTarget.DEFAULT.getValue());
    private static final String ROUTER_IGNORE_ATTRIBUTE = "router-ignore";
    private Serializable href;

    public Anchor() {
    }

    public Anchor(String href, String text) {
        this.setHref(href);
        this.setText(text);
    }

    public Anchor(String href, Signal<String> textSignal) {
        this.setHref(href);
        Objects.requireNonNull(textSignal, "textSignal must not be null");
        this.bindText(textSignal);
    }

    public Anchor(String href, String text, AnchorTarget target) {
        this.setHref(href);
        this.setText(text);
        this.setTarget(target);
    }

    @Deprecated(since="24.8", forRemoval=true)
    public Anchor(AbstractStreamResource href, String text) {
        this.setHref(href);
        this.setText(text);
    }

    public Anchor(DownloadHandler downloadHandler, String text) {
        AttachmentType att = downloadHandler instanceof AbstractDownloadHandler ? this.getLinkMode(downloadHandler) : AttachmentType.DOWNLOAD;
        this.setHref(downloadHandler, att);
        this.setText(text);
    }

    public Anchor(DownloadHandler downloadHandler, Signal<String> textSignal) {
        AttachmentType att = downloadHandler instanceof AbstractDownloadHandler ? this.getLinkMode(downloadHandler) : AttachmentType.DOWNLOAD;
        this.setHref(downloadHandler, att);
        Objects.requireNonNull(textSignal, "textSignal must not be null");
        this.bindText(textSignal);
    }

    public Anchor(DownloadHandler downloadHandler, AttachmentType attachmentType, String text) {
        this.setHref(downloadHandler, attachmentType == null ? AttachmentType.DOWNLOAD : attachmentType);
        this.setText(text);
    }

    public Anchor(String href, Component ... components) {
        this.setHref(href);
        this.add(components);
    }

    public void setHref(String href) {
        if (href == null) {
            throw new IllegalArgumentException("Href must not be null");
        }
        this.href = href;
        this.assignHrefAttribute();
    }

    public void removeHref() {
        this.getElement().removeAttribute("href");
        this.href = null;
    }

    @Deprecated(since="24.8", forRemoval=true)
    public void setHref(AbstractStreamResource href) {
        this.href = href;
        this.setRouterIgnore(true);
        this.assignHrefAttribute();
    }

    public void setHref(DownloadHandler downloadHandler) {
        this.setHref(downloadHandler, this.getLinkMode(downloadHandler));
    }

    private AttachmentType getLinkMode(DownloadHandler downloadHandler) {
        if (downloadHandler instanceof AbstractDownloadHandler) {
            AbstractDownloadHandler abstractDownloadHandler = (AbstractDownloadHandler)downloadHandler;
            if (abstractDownloadHandler.isInline()) {
                return AttachmentType.INLINE;
            }
            return AttachmentType.DOWNLOAD;
        }
        return this.isDownload() ? AttachmentType.DOWNLOAD : AttachmentType.INLINE;
    }

    public void setHref(DownloadHandler downloadHandler, AttachmentType attachmentType) {
        this.href = new StreamResourceRegistry.ElementStreamResource((ElementRequestHandler)downloadHandler, this.getElement());
        this.setRouterIgnore(true);
        this.assignHrefAttribute();
        this.setDownload(attachmentType == null || attachmentType.equals((Object)AttachmentType.DOWNLOAD));
    }

    public void setDownload(boolean download) {
        if (download) {
            this.getElement().setAttribute("download", true);
        } else {
            this.getElement().removeAttribute("download");
        }
    }

    public boolean isDownload() {
        return this.getElement().hasAttribute("download");
    }

    public void setRouterIgnore(boolean ignore) {
        this.getElement().setAttribute(ROUTER_IGNORE_ATTRIBUTE, ignore);
    }

    public boolean isRouterIgnore() {
        return this.getElement().hasAttribute(ROUTER_IGNORE_ATTRIBUTE);
    }

    public String getHref() {
        if (this.href instanceof String) {
            return (String)((Object)this.href);
        }
        if (this.href instanceof AbstractStreamResource) {
            return StreamResourceRegistry.getURI((AbstractStreamResource)((AbstractStreamResource)this.href)).toString();
        }
        return (String)this.get(hrefDescriptor);
    }

    public void onEnabledStateChanged(boolean enabled) {
        super.onEnabledStateChanged(enabled);
        this.assignHrefAttribute();
    }

    private void assignHrefAttribute() {
        if (this.isEnabled()) {
            if (this.href != null) {
                if (this.href instanceof AbstractStreamResource) {
                    this.getElement().setAttribute("href", (AbstractStreamResource)this.href);
                } else {
                    this.set(hrefDescriptor, (String)((Object)this.href));
                }
            }
        } else {
            this.getElement().removeAttribute("href");
        }
    }

    public void setTarget(String target) {
        this.set(targetDescriptor, target);
    }

    public Optional<String> getTarget() {
        return (Optional)this.get(targetDescriptor);
    }

    public void setTarget(AnchorTargetValue target) {
        Objects.requireNonNull(target, "target cannot be null.");
        this.setTarget(target.getValue());
    }

    public AnchorTargetValue getTargetValue() {
        Optional<String> target = this.getTarget();
        if (target.isPresent()) {
            return AnchorTargetValue.forString(target.get());
        }
        return AnchorTarget.DEFAULT;
    }
}

