/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.html;

import com.vaadin.flow.component.ClickNotifier;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HtmlContainer;
import com.vaadin.flow.component.Tag;
import com.vaadin.signals.Signal;
import java.util.Objects;

@Tag(value="td")
public class NativeTableCell
extends HtmlContainer
implements ClickNotifier<NativeTableCell> {
    final String ATTRIBUTE_COLSPAN = "colspan";
    final String ATTRIBUTE_ROWSPAN = "rowspan";

    public NativeTableCell() {
    }

    public NativeTableCell(Component ... components) {
        super(components);
    }

    public NativeTableCell(String text) {
        this.setText(text);
    }

    public NativeTableCell(Signal<String> textSignal) {
        Objects.requireNonNull(textSignal, "textSignal must not be null");
        this.bindText(textSignal);
    }

    public void setColspan(int colspan) {
        if (colspan < 0) {
            throw new IllegalArgumentException("colspan must be a non-negative integer value");
        }
        this.getElement().setAttribute("colspan", String.valueOf(colspan));
    }

    public int getColspan() {
        String colspan = this.getElement().getAttribute("colspan");
        if (colspan == null) {
            colspan = "1";
        }
        return Integer.parseInt(colspan);
    }

    public void resetColspan() {
        this.getElement().removeAttribute("colspan");
    }

    public void setRowspan(int rowspan) {
        if (rowspan < 0) {
            throw new IllegalArgumentException("rowspan must be a non-negative integer value");
        }
        this.getElement().setAttribute("rowspan", String.valueOf(rowspan));
    }

    public int getRowspan() {
        String rowspan = this.getElement().getAttribute("rowspan");
        if (rowspan == null) {
            rowspan = "1";
        }
        return Integer.parseInt(rowspan);
    }

    public void resetRowspan() {
        this.getElement().removeAttribute("rowspan");
    }
}

