/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.html;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HtmlContainer;
import com.vaadin.flow.component.PropertyDescriptor;
import com.vaadin.flow.component.PropertyDescriptors;
import com.vaadin.flow.component.Tag;
import com.vaadin.signals.Signal;
import java.util.Objects;
import java.util.Optional;

@Tag(value="label")
public class NativeLabel
extends HtmlContainer {
    private static final PropertyDescriptor<String, Optional<String>> forDescriptor = PropertyDescriptors.optionalAttributeWithDefault((String)"for", (String)"");

    public NativeLabel() {
    }

    public NativeLabel(String text) {
        this();
        this.setText(text);
    }

    public NativeLabel(Signal<String> textSignal) {
        Objects.requireNonNull(textSignal, "textSignal must not be null");
        this.bindText(textSignal);
    }

    public void setFor(Component forComponent) {
        if (forComponent == null) {
            throw new IllegalArgumentException("The provided component cannot be null");
        }
        this.setFor((String)forComponent.getId().orElseThrow(() -> new IllegalArgumentException("The provided component must have an id")));
    }

    public void setFor(String forId) {
        this.set(forDescriptor, forId);
    }

    public Optional<String> getFor() {
        return (Optional)this.get(forDescriptor);
    }
}

