/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.html;

import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HtmlContainer;
import com.vaadin.flow.component.PropertyDescriptor;
import com.vaadin.flow.component.PropertyDescriptors;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.LoggerFactory;

@Tag(value="label")
@Deprecated(since="24.1", forRemoval=true)
public class Label
extends HtmlContainer {
    private static final PropertyDescriptor<String, Optional<String>> forDescriptor = PropertyDescriptors.optionalAttributeWithDefault((String)"for", (String)"");
    private static Boolean productionMode = null;
    private Registration checkForAttributeOnAttach;

    public Label() {
    }

    public Label(String text) {
        this();
        this.setText(text);
    }

    public void setFor(Component forComponent) {
        if (forComponent == null) {
            throw new IllegalArgumentException("The provided component cannot be null");
        }
        this.setFor((String)forComponent.getId().orElseThrow(() -> new IllegalArgumentException("The provided component must have an id")));
    }

    public void setFor(String forId) {
        this.set(forDescriptor, forId);
    }

    public Optional<String> getFor() {
        return (Optional)this.get(forDescriptor);
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        if (Label.skipForAttributeCheck() || !attachEvent.isInitialAttach()) {
            return;
        }
        if (this.checkForAttributeOnAttach == null) {
            this.checkForAttributeOnAttach = attachEvent.getUI().beforeClientResponse((Component)this, (SerializableConsumer & Serializable)ctx -> {
                if (this.getFor().isEmpty() && this.getChildren().findAny().isEmpty() && !Objects.equals(this.getElement().getAttribute("slot"), "label")) {
                    LoggerFactory.getLogger((String)Label.class.getName()).warn("The Label '{}' was not associated with a component. Labels should not be used for loose text on the page. Consider alternatives like Text, Paragraph, Span or Div. See the JavaDocs and Deprecation Warning for more Information.", (Object)this.getText());
                }
                this.checkForAttributeOnAttach.remove();
            });
        }
    }

    private static boolean skipForAttributeCheck() {
        if (productionMode != null) {
            return productionMode;
        }
        VaadinService service = VaadinService.getCurrent();
        if (service == null) {
            return true;
        }
        productionMode = service.getDeploymentConfiguration().isProductionMode();
        return productionMode;
    }
}

