/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.gradle;

import com.vaadin.experimental.FeatureFlags;
import com.vaadin.flow.gradle.GradlePluginAdapter;
import com.vaadin.flow.gradle.PluginEffectiveConfiguration;
import com.vaadin.flow.plugin.base.BuildFrontendUtil;
import com.vaadin.flow.plugin.base.PluginAdapterBase;
import com.vaadin.flow.plugin.base.PluginAdapterBuild;
import com.vaadin.flow.server.frontend.BundleValidationUtil;
import com.vaadin.flow.server.frontend.FrontendUtils;
import com.vaadin.flow.server.frontend.Options;
import com.vaadin.flow.server.frontend.TaskCleanFrontendFiles;
import com.vaadin.flow.server.frontend.scanner.ClassFinder;
import com.vaadin.flow.server.frontend.scanner.FrontendDependenciesScanner;
import com.vaadin.pro.licensechecker.LicenseChecker;
import com.vaadin.pro.licensechecker.MissingLicenseKeyException;
import java.io.File;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.DefaultTask;
import org.gradle.api.Task;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.bundling.Jar;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\b\u001a\u00020\tH\u0014J\u0015\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b\u000eJ\b\u0010\u000f\u001a\u00020\u000bH\u0007R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048aX\u00a0\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lcom/vaadin/flow/gradle/VaadinBuildFrontendTask;", "Lorg/gradle/api/DefaultTask;", "()V", "adapter", "Lorg/gradle/api/provider/Property;", "Lcom/vaadin/flow/gradle/GradlePluginAdapter;", "getAdapter$flow_gradle_plugin", "()Lorg/gradle/api/provider/Property;", "cleanFrontendFiles", "", "configure", "", "config", "Lcom/vaadin/flow/gradle/PluginEffectiveConfiguration;", "configure$flow_gradle_plugin", "vaadinBuildFrontend", "flow-gradle-plugin"})
public abstract class VaadinBuildFrontendTask
extends DefaultTask {
    public VaadinBuildFrontendTask() {
        this.setGroup("Vaadin");
        this.setDescription("Builds the frontend bundle with webpack");
        Object[] objectArray = new Object[]{"vaadinPrepareFrontend"};
        this.dependsOn(objectArray);
        objectArray = new Object[]{"classes"};
        this.dependsOn(objectArray);
        this.getProject().getTasks().withType(Jar.class, arg_0 -> VaadinBuildFrontendTask._init_$lambda$0(1.INSTANCE, arg_0));
    }

    @Internal
    @NotNull
    public abstract Property<GradlePluginAdapter> getAdapter$flow_gradle_plugin();

    public final void configure$flow_gradle_plugin(@NotNull PluginEffectiveConfiguration config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.getAdapter$flow_gradle_plugin().set((Object)new GradlePluginAdapter((Task)this, config, false));
    }

    @TaskAction
    public final void vaadinBuildFrontend() {
        Pair pair;
        PluginEffectiveConfiguration config = ((GradlePluginAdapter)this.getAdapter$flow_gradle_plugin().get()).getConfig$flow_gradle_plugin();
        this.getLogger().info("Running the vaadinBuildFrontend task with effective configuration " + config);
        File tokenFile = BuildFrontendUtil.getTokenFile((PluginAdapterBase)((PluginAdapterBase)this.getAdapter$flow_gradle_plugin().get()));
        if (!tokenFile.exists()) {
            this.getLogger().info("Token file does not exist, propagating build info");
            BuildFrontendUtil.propagateBuildInfo((PluginAdapterBase)((PluginAdapterBase)this.getAdapter$flow_gradle_plugin().get()));
        }
        Options options = new Options(null, ((GradlePluginAdapter)this.getAdapter$flow_gradle_plugin().get()).getClassFinder(), (File)config.getNpmFolder().get()).withFrontendDirectory(BuildFrontendUtil.getFrontendDirectory((PluginAdapterBase)((PluginAdapterBase)this.getAdapter$flow_gradle_plugin().get()))).withFrontendGeneratedFolder((File)config.getGeneratedTsFolder().get());
        TaskCleanFrontendFiles cleanTask = new TaskCleanFrontendFiles(options);
        boolean reactEnabled = ((GradlePluginAdapter)this.getAdapter$flow_gradle_plugin().get()).isReactEnabled() && FrontendUtils.isReactRouterRequired((File)BuildFrontendUtil.getFrontendDirectory((PluginAdapterBase)((PluginAdapterBase)this.getAdapter$flow_gradle_plugin().get())));
        FeatureFlags featureFlags = new FeatureFlags(((GradlePluginAdapter)this.getAdapter$flow_gradle_plugin().get()).createLookup(((GradlePluginAdapter)this.getAdapter$flow_gradle_plugin().get()).getClassFinder()));
        if (((GradlePluginAdapter)this.getAdapter$flow_gradle_plugin().get()).javaResourceFolder() != null) {
            featureFlags.setPropertiesLocation(((GradlePluginAdapter)this.getAdapter$flow_gradle_plugin().get()).javaResourceFolder());
        }
        FrontendDependenciesScanner frontendDependenciesScanner = new FrontendDependenciesScanner.FrontendDependenciesScannerFactory().createScanner(!((GradlePluginAdapter)this.getAdapter$flow_gradle_plugin().get()).optimizeBundle(), ((GradlePluginAdapter)this.getAdapter$flow_gradle_plugin().get()).getClassFinder(), ((GradlePluginAdapter)this.getAdapter$flow_gradle_plugin().get()).generateEmbeddableWebComponents(), featureFlags, reactEnabled);
        Intrinsics.checkNotNullExpressionValue((Object)frontendDependenciesScanner, (String)"createScanner(...)");
        FrontendDependenciesScanner frontendDependencies = frontendDependenciesScanner;
        BuildFrontendUtil.runNodeUpdater((PluginAdapterBuild)((PluginAdapterBuild)this.getAdapter$flow_gradle_plugin().get()), (FrontendDependenciesScanner)frontendDependencies);
        if (((GradlePluginAdapter)this.getAdapter$flow_gradle_plugin().get()).generateBundle() && BundleValidationUtil.needsBundleBuild((File)((GradlePluginAdapter)this.getAdapter$flow_gradle_plugin().get()).servletResourceOutputDirectory())) {
            BuildFrontendUtil.runFrontendBuild((PluginAdapterBase)((PluginAdapterBase)this.getAdapter$flow_gradle_plugin().get()));
            if (this.cleanFrontendFiles()) {
                cleanTask.execute();
            }
        }
        LicenseChecker.setStrictOffline((boolean)true);
        try {
            pair = new Pair((Object)BuildFrontendUtil.validateLicenses((PluginAdapterBase)((PluginAdapterBase)this.getAdapter$flow_gradle_plugin().get()), (FrontendDependenciesScanner)frontendDependencies), (Object)false);
        }
        catch (MissingLicenseKeyException e) {
            this.getLogger().info(e.getMessage());
            pair = new Pair((Object)true, (Object)true);
        }
        Pair pair2 = pair;
        boolean licenseRequired = (Boolean)pair2.component1();
        boolean commercialBannerRequired = (Boolean)pair2.component2();
        BuildFrontendUtil.updateBuildFile((PluginAdapterBuild)((PluginAdapterBuild)this.getAdapter$flow_gradle_plugin().get()), (boolean)licenseRequired, (boolean)commercialBannerRequired);
    }

    protected boolean cleanFrontendFiles() {
        if (FrontendUtils.isHillaUsed((File)BuildFrontendUtil.getFrontendDirectory((PluginAdapterBase)((PluginAdapterBase)this.getAdapter$flow_gradle_plugin().get())), (ClassFinder)((GradlePluginAdapter)this.getAdapter$flow_gradle_plugin().get()).getClassFinder())) {
            return false;
        }
        Object object = ((GradlePluginAdapter)this.getAdapter$flow_gradle_plugin().get()).getConfig$flow_gradle_plugin().getCleanFrontendFiles().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (Boolean)object;
    }

    private static final void _init_$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }
}

