/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.dnd;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dnd.DragEndEvent;
import com.vaadin.flow.component.dnd.DragStartEvent;
import com.vaadin.flow.component.dnd.EffectAllowed;
import com.vaadin.flow.component.dnd.internal.DndUtil;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.Style;
import com.vaadin.flow.internal.nodefeature.VirtualChildrenList;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.Locale;
import org.slf4j.LoggerFactory;

@JsModule(value="./dndConnector.js")
public interface DragSource<T extends Component>
extends HasElement {
    public static <T extends Component> DragSource<T> create(T component) {
        return DragSource.configure(component, true);
    }

    public static <T extends Component> DragSource<T> configure(final T component) {
        return new DragSource<T>(){

            @Override
            public T getDragSourceComponent() {
                return component;
            }
        };
    }

    public static <T extends Component> DragSource<T> configure(T component, boolean draggable) {
        DragSource<T> dragSource = DragSource.configure(component);
        dragSource.setDraggable(draggable);
        return dragSource;
    }

    default public T getDragSourceComponent() {
        return (T)((Component)this);
    }

    default public Element getElement() {
        return this.getDragSourceComponent().getElement();
    }

    default public Element getDraggableElement() {
        return this.getDragSourceComponent().getElement();
    }

    default public void setDraggable(boolean draggable) {
        if (draggable == this.isDraggable()) {
            return;
        }
        if (draggable) {
            this.getDraggableElement().setProperty("draggable", Boolean.TRUE.toString());
            DndUtil.updateDragSourceActivation(this);
            Registration startListenerRegistration = this.addDragStartListener((ComponentEventListener & Serializable)event -> ((UI)this.getDragSourceComponent().getUI().orElseThrow(() -> new IllegalStateException("DragSource not attached to an UI but received a drag start event."))).getInternals().setActiveDragSourceComponent(this.getDragSourceComponent()));
            Registration endListenerRegistration = this.addDragEndListener((ComponentEventListener & Serializable)event -> this.getDragSourceComponent().getUI().orElse(UI.getCurrent()).getInternals().setActiveDragSourceComponent(null));
            ComponentUtil.setData(this.getDragSourceComponent(), (String)"_startListenerRegistration", (Object)startListenerRegistration);
            ComponentUtil.setData(this.getDragSourceComponent(), (String)"_endListenerRegistration", (Object)endListenerRegistration);
        } else {
            Object endListenerRegistration;
            this.getDraggableElement().removeProperty("draggable");
            DndUtil.updateDragSourceActivation(this);
            Object startListenerRegistration = ComponentUtil.getData(this.getDragSourceComponent(), (String)"_startListenerRegistration");
            if (startListenerRegistration instanceof Registration) {
                ((Registration)startListenerRegistration).remove();
            }
            if ((endListenerRegistration = ComponentUtil.getData(this.getDragSourceComponent(), (String)"_endListenerRegistration")) instanceof Registration) {
                ((Registration)endListenerRegistration).remove();
            }
        }
        DndUtil.reportUsage();
    }

    default public boolean isDraggable() {
        return this.getDraggableElement().hasProperty("draggable");
    }

    default public void setDragData(Object data) {
        ComponentUtil.setData(this.getDragSourceComponent(), (String)"drag-source-data", (Object)data);
    }

    default public Object getDragData() {
        return ComponentUtil.getData(this.getDragSourceComponent(), (String)"drag-source-data");
    }

    default public void setEffectAllowed(EffectAllowed effect) {
        if (effect == null) {
            throw new IllegalArgumentException("Allowed effect cannot be null");
        }
        this.getDraggableElement().setProperty("__effectAllowed", effect.getClientPropertyValue());
    }

    default public EffectAllowed getEffectAllowed() {
        return EffectAllowed.valueOf(this.getDraggableElement().getProperty("__effectAllowed", EffectAllowed.UNINITIALIZED.getClientPropertyValue().toUpperCase(Locale.ENGLISH)));
    }

    default public void setDragImage(Component dragImage) {
        this.setDragImage(dragImage, 0, 0);
    }

    default public void setDragImage(Component dragImage, int offsetX, int offsetY) {
        VirtualChildrenList childrenList;
        if (dragImage != null && !dragImage.isVisible()) {
            throw new IllegalStateException("Drag image element is not visible and will not show.\nMake element visible to use as drag image!");
        }
        if (this.getDragImage() != null && this.getDragImage() != dragImage && this.getDraggableElement().getNode().hasFeature(VirtualChildrenList.class) && (childrenList = (VirtualChildrenList)this.getDraggableElement().getNode().getFeature(VirtualChildrenList.class)).size() > 0) {
            this.getDraggableElement().removeVirtualChild(new Element[]{this.getDragImage().getElement()});
        }
        if (dragImage != null && !dragImage.isAttached()) {
            if (!this.getDragSourceComponent().isAttached()) {
                this.getDragSourceComponent().addAttachListener((ComponentEventListener & Serializable)event -> {
                    if (!dragImage.isAttached() && dragImage.getParent().isEmpty()) {
                        this.appendDragElement(dragImage.getElement());
                    }
                    event.unregisterListener();
                });
            } else {
                this.appendDragElement(dragImage.getElement());
            }
        }
        ComponentUtil.setData(this.getDragSourceComponent(), (String)"drag-source-image", (Object)dragImage);
        this.getDraggableElement().executeJs("window.Vaadin.Flow.dndConnector.setDragImage($0, $1, $2, $3)", new Object[]{dragImage, dragImage == null ? 0 : offsetX, dragImage == null ? 0 : offsetY, this.getDraggableElement()});
    }

    private void appendDragElement(Element dragElement) {
        if (dragElement.getTag().equals("img")) {
            this.getDraggableElement().appendVirtualChild(new Element[]{dragElement});
        } else {
            LoggerFactory.getLogger(DragSource.class).debug("Attaching child to dom in position -100,-100. Consider adding the component manually to not get overlapping components on drag for element.");
            this.getDraggableElement().appendChild(new Element[]{dragElement});
            Style style = dragElement.getStyle();
            style.set("position", "absolute");
            style.set("top", "-100px");
            style.set("left", "-100px");
            style.set("display", "none");
        }
    }

    default public Component getDragImage() {
        return (Component)ComponentUtil.getData(this.getDragSourceComponent(), (String)"drag-source-image");
    }

    default public Registration addDragStartListener(ComponentEventListener<DragStartEvent<T>> listener) {
        return ComponentUtil.addListener(this.getDragSourceComponent(), DragStartEvent.class, listener);
    }

    default public Registration addDragEndListener(ComponentEventListener<DragEndEvent<T>> listener) {
        return ComponentUtil.addListener(this.getDragSourceComponent(), DragEndEvent.class, listener);
    }
}

