/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.validator;

import com.vaadin.flow.data.validator.RangeValidator;
import com.vaadin.flow.data.validator.ValidatorTestBase;
import java.time.LocalDate;
import org.junit.Test;

public class RangeValidatorTest
extends ValidatorTestBase {
    @Test
    public void testIntegerRangeValidIntPasses() {
        this.assertPasses(10, RangeValidator.of((String)"Must be between -123 and 42", (Comparable)Integer.valueOf(-123), (Comparable)Integer.valueOf(42)));
    }

    @Test
    public void testIntegerRangeInvalidIntFails() {
        this.assertFails(123, RangeValidator.of((String)"Must be between -123 and 42", (Comparable)Integer.valueOf(-123), (Comparable)Integer.valueOf(42)));
    }

    @Test
    public void testRangeWithoutUpperBoundLargeIntegerPasses() {
        this.assertPasses(Integer.MAX_VALUE, RangeValidator.of((String)"Must be at least 18", (Comparable)Integer.valueOf(18), null));
    }

    @Test
    public void testRangeWithoutUpperBoundSmallIntegerFails() {
        this.assertFails(17, RangeValidator.of((String)"Must be at least 18", (Comparable)Integer.valueOf(18), null));
    }

    @Test
    public void testRangeWithoutLowerBoundSmallIntegerPasses() {
        this.assertPasses(Integer.MIN_VALUE, RangeValidator.of((String)"Must be at most 0", null, (Comparable)Integer.valueOf(0)));
    }

    @Test
    public void testRangeWithoutLowerBoundLargeIntegerFails() {
        this.assertFails(1, RangeValidator.of((String)"Must be at most 0", null, (Comparable)Integer.valueOf(0)));
    }

    @Test
    public void testUnboundedRangePassesEverything() {
        RangeValidator v = RangeValidator.of((String)"This should not happen!", null, null);
        this.assertPasses(Integer.MIN_VALUE, v);
        this.assertPasses(0, v);
        this.assertPasses(null, v);
        this.assertPasses(Integer.MAX_VALUE, v);
    }

    @Test
    public void testBoundsInclusiveByDefault() {
        RangeValidator v = RangeValidator.of((String)"Must be between -10 and 10", (Comparable)Integer.valueOf(-10), (Comparable)Integer.valueOf(10));
        this.assertPasses(-10, v);
        this.assertPasses(10, v);
    }

    @Test
    public void testUpperBoundExclusive() {
        RangeValidator v = RangeValidator.of((String)"Must be between -10 and 10", (Comparable)Integer.valueOf(-10), (Comparable)Integer.valueOf(10));
        v.setMaxValueIncluded(false);
        this.assertPasses(-10, v);
        this.assertPasses(9, v);
        this.assertFails(10, v);
    }

    @Test
    public void testLowerBoundExclusive() {
        RangeValidator v = RangeValidator.of((String)"Must be between -10 and 10", (Comparable)Integer.valueOf(-10), (Comparable)Integer.valueOf(10));
        v.setMinValueIncluded(false);
        this.assertFails(-10, v);
        this.assertPasses(-9, v);
        this.assertPasses(10, v);
    }

    @Test
    public void testNullLessThanEverything() {
        RangeValidator v = RangeValidator.of((String)"Must be any integer", (Comparable)Integer.valueOf(Integer.MIN_VALUE), (Comparable)Integer.valueOf(Integer.MAX_VALUE));
        this.assertPasses(null, v);
        v = RangeValidator.of((String)"Must be very small", null, (Comparable)Integer.valueOf(Integer.MIN_VALUE));
        this.assertPasses(null, v);
    }

    @Test
    public void testDateRange() {
        RangeValidator v = RangeValidator.of((String)"Date must be in 2016", (Comparable)LocalDate.of(2016, 1, 1), (Comparable)LocalDate.of(2016, 12, 31));
        this.assertFails(LocalDate.ofEpochDay(0L), v);
        this.assertPasses(LocalDate.of(2016, 7, 31), v);
        this.assertFails(LocalDate.ofEpochDay(1000000000L), v);
    }
}

